/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.turret.TurretInfo;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.TmrCreativeTabs;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class ItemTurret
extends Item {
    @SideOnly(value=Side.CLIENT)
    private Map<UUID, IIcon> iconMap;

    public ItemTurret() {
        this.func_77637_a(TmrCreativeTabs.TURRETS);
        this.func_77655_b("sapturretmod:turret_placer");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        TurretInfo type = ItemTurret.getTurretInfo(stack);
        if (type != null) {
            return this.iconMap.get(type.getUUID());
        }
        return super.getIcon(stack, pass);
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        List<TurretInfo> types = TurretRegistry.INSTANCE.getRegisteredInfos();
        this.iconMap = new HashMap<UUID, IIcon>(types.size());
        for (TurretInfo type : types) {
            IIcon icon = iconRegister.func_94245_a(String.format("%s:turrets/%s", "sapturretmod", type.getIcon()));
            if (this.field_77791_bV == null) {
                this.field_77791_bV = icon;
            }
            this.iconMap.put(type.getUUID(), icon);
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean advInfo) {
        Float health;
        String name;
        super.func_77624_a(stack, player, lines, advInfo);
        TurretInfo info = ItemTurret.getTurretInfo(stack);
        if (info != null) {
            lines.add(Lang.translateEntityCls(info.getTurretClass()));
        }
        if ((name = ItemTurret.getTurretName(stack)) != null) {
            lines.add(String.format(Lang.translate("%s.turret_name", this.func_77658_a()), name));
        }
        if ((health = ItemTurret.getTurretHealth(stack)) != null) {
            lines.add(String.format(Lang.translate("%s.health", this.func_77658_a()), health));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float offX, float offY, float offZ) {
        if (!world.field_72995_K) {
            EntityTurret turret;
            Block block = world.func_147439_a(x, y, z);
            x += Facing.field_71586_b[side];
            y += Facing.field_71587_c[side];
            z += Facing.field_71585_d[side];
            double shiftY = 0.0;
            if (side == EnumFacing.UP.ordinal() && block.func_149645_b() == 11) {
                shiftY = 0.5;
            }
            if (EntityTurret.canTurretBePlaced(world, x, y, z, false, side == EnumFacing.DOWN.ordinal()) && (turret = ItemTurret.spawnTurret(world, ItemTurret.getTurretInfo(stack), (double)x + 0.5, (double)y + shiftY, (double)z + 0.5, side == EnumFacing.DOWN.ordinal(), player)) != null) {
                String name;
                Float initHealth = ItemTurret.getTurretHealth(stack);
                if (initHealth != null) {
                    turret.func_70606_j(initHealth.floatValue());
                }
                if ((name = ItemTurret.getTurretName(stack)) != null) {
                    turret.func_94058_c(name);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
            if (movingobjectposition == null) {
                return stack;
            }
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                EntityTurret turret;
                int x = movingobjectposition.field_72311_b;
                int y = movingobjectposition.field_72312_c;
                int z = movingobjectposition.field_72309_d;
                if (!world.func_72962_a(player, x, y, z)) {
                    return stack;
                }
                if (!player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, stack)) {
                    return stack;
                }
                if (world.func_147439_a(x, y, z) instanceof BlockLiquid && (turret = ItemTurret.spawnTurret(world, ItemTurret.getTurretInfo(stack), x, y, z, false, player)) != null) {
                    String name;
                    Float initHealth = ItemTurret.getTurretHealth(stack);
                    if (initHealth != null) {
                        turret.func_70606_j(initHealth.floatValue());
                    }
                    if ((name = ItemTurret.getTurretName(stack)) != null) {
                        turret.func_94058_c(name);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
            }
        }
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (TurretInfo type : TurretRegistry.INSTANCE.getRegisteredInfos()) {
            list.add(this.getTurretItem(1, type));
        }
    }

    public static TurretInfo getTurretInfo(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("turretInfoUUID")) {
            return TurretRegistry.INSTANCE.getInfo(UUID.fromString(nbt.func_74779_i("turretInfoUUID")));
        }
        return null;
    }

    public static Float getTurretHealth(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("turretHealth")) {
            return Float.valueOf(nbt.func_74760_g("turretHealth"));
        }
        return null;
    }

    public static String getTurretName(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("turretName")) {
            return nbt.func_74779_i("turretName");
        }
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return null;
    }

    public ItemStack getTurretItem(int stackSize, TurretInfo type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get turret item with NULL type!");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("turretInfoUUID", type.getUUID().toString());
        ItemStack stack = new ItemStack((Item)this, stackSize);
        stack.func_77982_d(nbt);
        return stack;
    }

    public ItemStack getTurretItem(int stackSize, TurretInfo type, EntityTurret turret) {
        ItemStack stack = this.getTurretItem(stackSize, type);
        stack.func_77978_p().func_74776_a("turretHealth", turret.func_110143_aJ());
        if (turret.func_94056_bM()) {
            stack.func_77978_p().func_74778_a("turretName", turret.func_94057_bL());
        }
        return stack;
    }

    public static EntityTurret spawnTurret(World world, TurretInfo info, double x, double y, double z, boolean isUpsideDown, EntityPlayer owner) {
        EntityTurret turret = ItemTurret.createEntity(info, world, isUpsideDown, owner);
        if (turret != null) {
            turret.func_70012_b(x, y - (isUpsideDown ? 1.0 : 0.0), z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            turret.field_70759_as = turret.field_70177_z;
            turret.field_70761_aq = turret.field_70177_z;
            turret.func_110161_a(null);
            world.func_72838_d((Entity)turret);
            turret.func_70642_aH();
        }
        return turret;
    }

    private static EntityTurret createEntity(TurretInfo info, World world, boolean isUpsideDown, EntityPlayer owner) {
        EntityTurret entity = null;
        try {
            Class<? extends EntityTurret> entityClass = info.getTurretClass();
            if (entityClass != null) {
                entity = entityClass.getConstructor(World.class, Boolean.TYPE, EntityPlayer.class).newInstance(world, isUpsideDown, owner);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            TurretModRebirth.LOG.log(Level.ERROR, "Cannot instanciate turret!", (Throwable)ex);
        }
        if (entity == null) {
            TurretModRebirth.LOG.printf(Level.WARN, "Skipping turret with name %s", new Object[]{info.getName()});
        }
        return entity;
    }
}

