/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import de.sanandrew.mods.turretmod.tileentity.TileEntityTurretAssembly;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketInitAssemblyCrafting
extends AbstractMessage<PacketInitAssemblyCrafting> {
    private int x;
    private int y;
    private int z;
    private String crfUUID;
    private int count;

    public PacketInitAssemblyCrafting() {
    }

    public PacketInitAssemblyCrafting(TileEntityTurretAssembly assembly, UUID uuid, int count) {
        this.x = assembly.field_145851_c;
        this.y = assembly.field_145848_d;
        this.z = assembly.field_145849_e;
        this.crfUUID = uuid == null ? null : uuid.toString();
        this.count = count;
    }

    public PacketInitAssemblyCrafting(TileEntityTurretAssembly assembly) {
        this.x = assembly.field_145851_c;
        this.y = assembly.field_145848_d;
        this.z = assembly.field_145849_e;
        this.crfUUID = null;
        this.count = 0;
    }

    public void handleClientMessage(PacketInitAssemblyCrafting packet, EntityPlayer player) {
    }

    public void handleServerMessage(PacketInitAssemblyCrafting packet, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(packet.x, packet.y, packet.z);
        if (te instanceof TileEntityTurretAssembly) {
            if (packet.crfUUID.equals("[CANCEL]")) {
                ((TileEntityTurretAssembly)te).cancelCrafting();
            } else {
                ((TileEntityTurretAssembly)te).beginCrafting(UUID.fromString(packet.crfUUID), packet.count);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.crfUUID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.count = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        if (this.crfUUID == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"[CANCEL]");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.crfUUID);
        }
        buf.writeByte(this.count);
    }
}

