/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketSyncTileEntity
extends AbstractMessage<PacketSyncTileEntity> {
    private int x;
    private int y;
    private int z;
    private byte[] tileBytes;

    public PacketSyncTileEntity() {
    }

    public PacketSyncTileEntity(TileClientSync tile) {
        this.x = tile.getTile().field_145851_c;
        this.y = tile.getTile().field_145848_d;
        this.z = tile.getTile().field_145849_e;
        ByteBuf buf = Unpooled.buffer();
        tile.toBytes(buf);
        this.tileBytes = buf.array();
    }

    public void handleClientMessage(PacketSyncTileEntity packet, EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(packet.x, packet.y, packet.z);
        if (te instanceof TileClientSync) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])packet.tileBytes);
            ((TileClientSync)te).fromBytes(buf);
        }
    }

    public void handleServerMessage(PacketSyncTileEntity packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int arrSz = buf.readInt();
        this.tileBytes = new byte[arrSz];
        buf.readBytes(this.tileBytes, 0, arrSz);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.tileBytes.length);
        buf.writeBytes(this.tileBytes);
    }

    public static void sync(TileClientSync te) {
        TileEntity tile = te.getTile();
        PacketRegistry.sendToAllAround((IMessage)new PacketSyncTileEntity(te), tile.func_145831_w().field_73011_w.field_76574_g, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 64.0);
    }
}

