/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.UUID;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpdateTargets
extends AbstractMessage<PacketUpdateTargets> {
    private Class[] entityTargets;
    private UUID[] playerTargets;
    private int turretID;

    public PacketUpdateTargets() {
    }

    public PacketUpdateTargets(TargetProcessor processor) {
        this.entityTargets = processor.getEnabledEntityTargets();
        this.playerTargets = processor.getEnabledPlayerTargets();
        this.turretID = processor.getTurret().func_145782_y();
    }

    public void handleClientMessage(PacketUpdateTargets packet, EntityPlayer player) {
        this.handleServerMessage(packet, player);
    }

    public void handleServerMessage(PacketUpdateTargets packet, EntityPlayer player) {
        Entity e = player.field_70170_p.func_73045_a(packet.turretID);
        if (e instanceof EntityTurret) {
            TargetProcessor processor = ((EntityTurret)e).getTargetProcessor();
            processor.updateEntityTargets(packet.entityTargets);
            processor.updatePlayerTargets(packet.playerTargets);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.turretID = buf.readInt();
        this.entityTargets = new Class[buf.readInt()];
        for (i = 0; i < this.entityTargets.length; ++i) {
            try {
                this.entityTargets[i] = Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf));
                continue;
            }
            catch (ClassNotFoundException ex) {
                this.entityTargets[i] = null;
            }
        }
        this.playerTargets = new UUID[buf.readInt()];
        for (i = 0; i < this.playerTargets.length; ++i) {
            try {
                this.playerTargets[i] = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.playerTargets[i] = null;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.turretID);
        buf.writeInt(this.entityTargets.length);
        for (Class clazz : this.entityTargets) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)clazz.getName());
        }
        buf.writeInt(this.playerTargets.length);
        for (Serializable serializable : this.playerTargets) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((UUID)serializable).toString());
        }
    }
}

