/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import io.netty.buffer.ByteBuf;
import net.darkhax.bookshelf.common.network.AbstractMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketUpdateTurretState
extends AbstractMessage<PacketUpdateTurretState> {
    private int turretId;
    private int entityToAttackId;
    private int currAmmoCap;
    private ItemStack ammoStack;

    public PacketUpdateTurretState() {
    }

    public PacketUpdateTurretState(EntityTurret turret) {
        this.turretId = turret.func_145782_y();
        TargetProcessor tgtProc = turret.getTargetProcessor();
        this.entityToAttackId = tgtProc.hasTarget() ? tgtProc.getTarget().func_145782_y() : -1;
        this.currAmmoCap = turret.getTargetProcessor().getAmmoCount();
        this.ammoStack = turret.getTargetProcessor().getAmmoStack();
    }

    public void handleClientMessage(PacketUpdateTurretState packet, EntityPlayer player) {
        Entity e = player.field_70170_p.func_73045_a(packet.turretId);
        if (e instanceof EntityTurret) {
            EntityTurret turret = (EntityTurret)e;
            turret.getTargetProcessor().updateClientState(packet.entityToAttackId, packet.currAmmoCap, packet.ammoStack);
        }
    }

    public void handleServerMessage(PacketUpdateTurretState packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        this.turretId = buf.readInt();
        this.entityToAttackId = buf.readInt();
        this.currAmmoCap = buf.readInt();
        this.ammoStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.turretId);
        buf.writeInt(this.entityToAttackId);
        buf.writeInt(this.currAmmoCap);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.ammoStack);
    }
}

