/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileCryoCell;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurretCryolator;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmoRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.TurretAmmo;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;

public abstract class TurretAmmoCryoCell
implements TurretAmmo {
    public static final UUID CELL_MK1_UUID = UUID.fromString("0B567594-E5CA-48B5-A538-E87C213F439C");
    public static final UUID PACK_MK1_UUID = UUID.fromString("7DE80386-CE9E-4039-ADA6-F7131996E522");
    public static final UUID CELL_MK2_UUID = UUID.fromString("CB5BE826-0480-4D30-AF1F-23BE19329B37");
    public static final UUID PACK_MK2_UUID = UUID.fromString("82D1E748-ABDE-4911-96B3-B43E5AA716CB");
    public static final UUID CELL_MK3_UUID = UUID.fromString("3181E328-0151-44E0-ADD2-5FCB6B724AEC");
    public static final UUID PACK_MK3_UUID = UUID.fromString("399B8468-B68F-40FD-B442-156760161283");
    public static final UUID TYPE_MK1_UUID = CELL_MK1_UUID;
    public static final UUID TYPE_MK2_UUID = CELL_MK2_UUID;
    public static final UUID TYPE_MK3_UUID = CELL_MK3_UUID;
    private final String name;
    private final UUID uuid;
    private final int capacity;

    public TurretAmmoCryoCell(String name, UUID uuid, int capacity) {
        this.name = name;
        this.uuid = uuid;
        this.capacity = capacity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public String getItemDesc() {
        return null;
    }

    @Override
    public int getAmmoCapacity() {
        return this.capacity;
    }

    @Override
    public Class<? extends IProjectile> getEntityClass() {
        return EntityProjectileCryoCell.class;
    }

    @Override
    public Class<? extends EntityTurret> getTurret() {
        return EntityTurretCryolator.class;
    }

    @Override
    public float getInfoDamage() {
        return 0.0f;
    }

    @Override
    public UUID getGroupId() {
        return TYPE_MK1_UUID;
    }

    @Override
    public String getInfoName() {
        return "cryocell";
    }

    @Override
    public ItemStack getStoringAmmoItem() {
        return ItemRegistry.ammo.getAmmoItem(1, AmmoRegistry.INSTANCE.getType(this.getTypeId()));
    }

    public static class MultiMK3
    extends TurretAmmoCryoCell {
        public MultiMK3() {
            super("cryocell_pack_3", PACK_MK3_UUID, 16);
        }

        @Override
        public UUID getTypeId() {
            return TYPE_MK3_UUID;
        }

        @Override
        public String getIcon() {
            return "cryocell_pack_3";
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.CRYOCELL_3_MTP;
        }

        @Override
        public IProjectile getEntity(EntityTurret turret) {
            return new EntityProjectileCryoCell(turret.field_70170_p, (Entity)turret, turret.getTargetProcessor().getTarget()).setLevelAndDuration(4, 100);
        }
    }

    public static class SingleMK3
    extends TurretAmmoCryoCell {
        public SingleMK3() {
            super("cryocell_3", CELL_MK3_UUID, 1);
        }

        @Override
        public String getIcon() {
            return "cryocell_3";
        }

        @Override
        public UUID getTypeId() {
            return TYPE_MK3_UUID;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.CRYOCELL_3_SNG;
        }

        @Override
        public IProjectile getEntity(EntityTurret turret) {
            return new EntityProjectileCryoCell(turret.field_70170_p, (Entity)turret, turret.getTargetProcessor().getTarget()).setLevelAndDuration(4, 100);
        }
    }

    public static class MultiMK2
    extends TurretAmmoCryoCell {
        public MultiMK2() {
            super("cryocell_pack_2", PACK_MK2_UUID, 16);
        }

        @Override
        public UUID getTypeId() {
            return TYPE_MK2_UUID;
        }

        @Override
        public String getIcon() {
            return "cryocell_pack_2";
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.CRYOCELL_2_MTP;
        }

        @Override
        public IProjectile getEntity(EntityTurret turret) {
            return new EntityProjectileCryoCell(turret.field_70170_p, (Entity)turret, turret.getTargetProcessor().getTarget()).setLevelAndDuration(2, 200);
        }
    }

    public static class SingleMK2
    extends TurretAmmoCryoCell {
        public SingleMK2() {
            super("cryocell_2", CELL_MK2_UUID, 1);
        }

        @Override
        public String getIcon() {
            return "cryocell_2";
        }

        @Override
        public UUID getTypeId() {
            return TYPE_MK2_UUID;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.CRYOCELL_2_SNG;
        }

        @Override
        public IProjectile getEntity(EntityTurret turret) {
            return new EntityProjectileCryoCell(turret.field_70170_p, (Entity)turret, turret.getTargetProcessor().getTarget()).setLevelAndDuration(2, 200);
        }
    }

    public static class MultiMK1
    extends TurretAmmoCryoCell {
        public MultiMK1() {
            super("cryocell_pack_1", PACK_MK1_UUID, 16);
        }

        @Override
        public UUID getTypeId() {
            return TYPE_MK1_UUID;
        }

        @Override
        public String getIcon() {
            return "cryocell_pack_1";
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.CRYOCELL_1_MTP;
        }

        @Override
        public IProjectile getEntity(EntityTurret turret) {
            return new EntityProjectileCryoCell(turret.field_70170_p, (Entity)turret, turret.getTargetProcessor().getTarget()).setLevelAndDuration(0, 300);
        }
    }

    public static class SingleMK1
    extends TurretAmmoCryoCell {
        public SingleMK1() {
            super("cryocell_1", CELL_MK1_UUID, 1);
        }

        @Override
        public String getIcon() {
            return "cryocell_1";
        }

        @Override
        public UUID getTypeId() {
            return TYPE_MK1_UUID;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.CRYOCELL_1_SNG;
        }

        @Override
        public IProjectile getEntity(EntityTurret turret) {
            return new EntityProjectileCryoCell(turret.field_70170_p, (Entity)turret, turret.getTargetProcessor().getTarget()).setLevelAndDuration(0, 300);
        }
    }
}

