/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import de.sanandrew.mods.turretmod.util.TmrUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeEntryItem {
    public int stackSize;
    public ItemStack[] normalAlternatives;
    public String[] oreDictAlternatives;
    private boolean drawTooltip;
    private WeakReference<ItemStack[]> cachedEntryStacks;

    public RecipeEntryItem(int count) {
        this.stackSize = count;
        this.drawTooltip = false;
        this.normalAlternatives = new ItemStack[0];
        this.oreDictAlternatives = new String[0];
    }

    private RecipeEntryItem(int count, ItemStack[] normalAlternatives, String[] oreDictAlternatives) {
        this.stackSize = count;
        this.drawTooltip = false;
        this.normalAlternatives = normalAlternatives;
        this.oreDictAlternatives = oreDictAlternatives;
    }

    public RecipeEntryItem put(Item ... items) {
        return this.put(false, items);
    }

    public RecipeEntryItem put(boolean allDmg, Item ... items) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        newStacks.addAll(Arrays.asList(this.normalAlternatives));
        for (Item item : items) {
            newStacks.add(new ItemStack(item, 1, allDmg ? Short.MAX_VALUE : 0));
        }
        this.normalAlternatives = newStacks.toArray(new ItemStack[newStacks.size()]);
        return this;
    }

    public RecipeEntryItem put(Block ... blocks) {
        return this.put(false, blocks);
    }

    public RecipeEntryItem put(boolean allDmg, Block ... blocks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        newStacks.addAll(Arrays.asList(this.normalAlternatives));
        for (Block block : blocks) {
            newStacks.add(new ItemStack(block, 1, allDmg ? Short.MAX_VALUE : 0));
        }
        this.normalAlternatives = newStacks.toArray(new ItemStack[newStacks.size()]);
        return this;
    }

    public RecipeEntryItem put(ItemStack ... stacks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        newStacks.addAll(Arrays.asList(this.normalAlternatives));
        newStacks.addAll(Arrays.asList(stacks));
        this.normalAlternatives = newStacks.toArray(new ItemStack[newStacks.size()]);
        return this;
    }

    public RecipeEntryItem put(String ... oreDictNames) {
        ArrayList<String> newNames = new ArrayList<String>();
        newNames.addAll(Arrays.asList(this.oreDictAlternatives));
        newNames.addAll(Arrays.asList(oreDictNames));
        this.oreDictAlternatives = newNames.toArray(new String[newNames.size()]);
        return this;
    }

    public RecipeEntryItem drawTooltip() {
        this.drawTooltip = true;
        return this;
    }

    public boolean shouldDrawTooltip() {
        return this.drawTooltip;
    }

    public RecipeEntryItem copy() {
        ItemStack[] stacksToCopy = new ItemStack[this.normalAlternatives.length];
        for (int i = 0; i < stacksToCopy.length; ++i) {
            stacksToCopy[i] = this.normalAlternatives[i].func_77946_l();
        }
        return new RecipeEntryItem(this.stackSize, stacksToCopy, (String[])this.oreDictAlternatives.clone());
    }

    public boolean isItemFitting(ItemStack stack) {
        int[] stackOreIds;
        for (ItemStack nrmStack : this.normalAlternatives) {
            if ((!nrmStack.func_77942_o() || !TmrUtils.areStacksEqual(nrmStack, stack, TmrUtils.NBT_COMPARATOR_FIXD)) && (nrmStack.func_77942_o() || !ItemStackUtils.areStacksEqual((ItemStack)nrmStack, (ItemStack)stack, (boolean)false))) continue;
            return true;
        }
        for (int oreId : stackOreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreIdName = OreDictionary.getOreName((int)oreId);
            if (!ArrayUtils.contains((Object[])this.oreDictAlternatives, (Object)oreIdName)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getEntryItemStacks() {
        if (this.cachedEntryStacks == null || this.cachedEntryStacks.get() == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fltStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.normalAlternatives) {
                if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                    itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                    continue;
                }
                stacks.add(itemStack);
            }
            for (ItemStack itemStack : this.oreDictAlternatives) {
                for (ItemStack stack : OreDictionary.getOres((String)itemStack)) {
                    if (stack.func_77960_j() == Short.MAX_VALUE) {
                        stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                        continue;
                    }
                    stacks.add(stack);
                }
            }
            for (ItemStack stack : stacks) {
                ItemStack valid = stack.func_77946_l();
                for (ItemStack fltStack : fltStacks) {
                    if (!fltStack.func_77969_a(valid)) continue;
                    valid = null;
                    break;
                }
                if (valid == null) continue;
                valid.field_77994_a = this.stackSize;
                fltStacks.add(valid);
            }
            this.cachedEntryStacks = new WeakReference<ItemStack[]>(fltStacks.toArray(new ItemStack[fltStacks.size()]));
        }
        return (ItemStack[])this.cachedEntryStacks.get();
    }
}

