/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.upgrades.TurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.NBTTagCompound;

public abstract class UpgradeHealth
implements TurretUpgrade {
    private final String name;
    private AttributeModifier modifier;

    public UpgradeHealth(String name, String modUUID) {
        this.name = name;
        this.modifier = new AttributeModifier(UUID.fromString(modUUID), String.format("%s:%s", "sapturretmod", name), 0.25, 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getModId() {
        return "sapturretmod";
    }

    @Override
    public String getIconTexture() {
        return "sapturretmod:upgrades/" + this.name;
    }

    @Override
    public boolean isTurretApplicable(Class<? extends EntityTurret> turretCls) {
        return true;
    }

    @Override
    public void onApply(EntityTurret turret) {
        if (!turret.field_70170_p.field_72995_K) {
            IAttributeInstance attrib = turret.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (attrib.func_111127_a(this.modifier.func_111167_a()) != null) {
                attrib.func_111124_b(this.modifier);
            }
            attrib.func_111121_a(this.modifier);
        }
    }

    @Override
    public void onRemove(EntityTurret turret) {
        IAttributeInstance attrib;
        if (!turret.field_70170_p.field_72995_K && (attrib = turret.func_110148_a(SharedMonsterAttributes.field_111267_a)).func_111127_a(this.modifier.func_111167_a()) != null) {
            attrib.func_111124_b(this.modifier);
            turret.func_70606_j(Math.min(turret.func_110143_aJ(), turret.func_110138_aP()));
        }
    }

    @Override
    public void onLoad(EntityTurret turret, NBTTagCompound nbt) {
    }

    @Override
    public void onSave(EntityTurret turret, NBTTagCompound nbt) {
    }

    public static class UpgradeHealthMK4
    extends UpgradeHealth {
        private final TurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(UpgradeRegistry.HEALTH_III);

        public UpgradeHealthMK4() {
            super("health_iv", "9431A60C-B995-4547-B143-2BEDC67467E1");
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return this.dependant;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_HEALTH_MK4;
        }
    }

    public static class UpgradeHealthMK3
    extends UpgradeHealth {
        private final TurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(UpgradeRegistry.HEALTH_II);

        public UpgradeHealthMK3() {
            super("health_iii", "D49F43AE-5EA4-4DD2-B08A-9B5F1966C091");
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return this.dependant;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_HEALTH_MK3;
        }
    }

    public static class UpgradeHealthMK2
    extends UpgradeHealth {
        private final TurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(UpgradeRegistry.HEALTH_I);

        public UpgradeHealthMK2() {
            super("health_ii", "B7E5ADFA-517C-4167-A2FD-E0D31FA6E9BE");
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return this.dependant;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_HEALTH_MK2;
        }
    }

    public static class UpgradeHealthMK1
    extends UpgradeHealth {
        public UpgradeHealthMK1() {
            super("health_i", "673176FC-51F9-4CBC-BA12-5073B6867644");
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return null;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_HEALTH_MK1;
        }
    }
}

