/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.upgrades.TurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeAmmoStorage;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeHealth;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeReloadTime;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeSmartTargeting;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeUpgStorage;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class UpgradeRegistry {
    public static final UUID EMPTY = new UUID(0L, 0L);
    public static final UUID UPG_STORAGE_I = UUID.fromString("1749478F-2A8E-4C56-BC03-6C76CB5DE921");
    public static final UUID UPG_STORAGE_II = UUID.fromString("DEFFE281-A2F5-488A-95C1-E9A3BB6E0DD1");
    public static final UUID UPG_STORAGE_III = UUID.fromString("50DB1AC3-1CCD-4CB0-AD5A-0777C548655D");
    public static final UUID AMMO_STORAGE = UUID.fromString("2C850D81-0C01-47EA-B3AD-86E4FF523521");
    public static final UUID HEALTH_I = UUID.fromString("13218AB7-3DA6-461D-9882-13482291164B");
    public static final UUID HEALTH_II = UUID.fromString("612A78CB-ED0C-4990-B1F3-041BE8171B1A");
    public static final UUID HEALTH_III = UUID.fromString("2239A7BB-DD38-4764-9FFC-6E04934F9B3C");
    public static final UUID HEALTH_IV = UUID.fromString("FF6CC60F-EEC7-40C5-92D8-A614DFA06777");
    public static final UUID RELOAD_I = UUID.fromString("4ED4E813-E2D8-43E9-B499-9911E214C5E9");
    public static final UUID RELOAD_II = UUID.fromString("80877F84-F03D-4ED8-A9D3-BAF6DF4F3BF1");
    public static final UUID SMART_TGT = UUID.fromString("12435AB9-5AA3-4DB9-9B76-7943BA71597A");
    public static final UpgradeRegistry INSTANCE = new UpgradeRegistry();
    private Map<UUID, TurretUpgrade> upgradeToUuidMap = new HashMap<UUID, TurretUpgrade>();
    private Map<TurretUpgrade, UUID> uuidToUpgradeMap = new HashMap<TurretUpgrade, UUID>();
    private List<TurretUpgrade> upgradeList = new ArrayList<TurretUpgrade>();
    private static TurretUpgrade emptyInst;
    private List<String> errored = new ArrayList<String>();

    public void registerUpgrade(UUID uuid, TurretUpgrade upgrade) {
        if (this.upgradeToUuidMap.containsKey(uuid)) {
            this.upgradeList.set(this.upgradeList.indexOf(this.upgradeToUuidMap.get(uuid)), upgrade);
        } else {
            this.upgradeList.add(upgrade);
        }
        this.upgradeToUuidMap.put(uuid, upgrade);
        this.uuidToUpgradeMap.put(upgrade, uuid);
    }

    public TurretUpgrade getUpgrade(UUID uuid) {
        return TmrUtils.valueOrDefault(this.upgradeToUuidMap.get(uuid), emptyInst);
    }

    public UUID getUpgradeUUID(TurretUpgrade upg) {
        return TmrUtils.valueOrDefault(this.uuidToUpgradeMap.get(upg), EMPTY);
    }

    public TurretUpgrade getUpgrade(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return emptyInst;
        }
        String uid = TmrUtils.valueOrDefault(stack.func_77978_p(), new NBTTagCompound()).func_74779_i("upgradeId");
        try {
            return this.getUpgrade(UUID.fromString(uid));
        }
        catch (IllegalArgumentException ex) {
            if (!this.errored.contains(uid)) {
                TurretModRebirth.LOG.log(Level.WARN, "There was an error at parsing the UUID for a turret upgrade item!", (Throwable)ex);
                this.errored.add(uid);
            }
            return emptyInst;
        }
    }

    public TurretUpgrade[] getRegisteredUpgrades() {
        return this.upgradeList.toArray(new TurretUpgrade[this.upgradeList.size()]);
    }

    public void initialize() {
        this.registerUpgrade(EMPTY, new EmptyUpgrade());
        this.registerUpgrade(UPG_STORAGE_I, new UpgradeUpgStorage.UpgradeStorageMK1());
        this.registerUpgrade(UPG_STORAGE_II, new UpgradeUpgStorage.UpgradeStorageMK2());
        this.registerUpgrade(UPG_STORAGE_III, new UpgradeUpgStorage.UpgradeStorageMK3());
        this.registerUpgrade(AMMO_STORAGE, new UpgradeAmmoStorage());
        this.registerUpgrade(HEALTH_I, new UpgradeHealth.UpgradeHealthMK1());
        this.registerUpgrade(HEALTH_II, new UpgradeHealth.UpgradeHealthMK2());
        this.registerUpgrade(HEALTH_III, new UpgradeHealth.UpgradeHealthMK3());
        this.registerUpgrade(HEALTH_IV, new UpgradeHealth.UpgradeHealthMK4());
        this.registerUpgrade(RELOAD_I, new UpgradeReloadTime.UpgradeReloadTimeMK1());
        this.registerUpgrade(RELOAD_II, new UpgradeReloadTime.UpgradeReloadTimeMK2());
        this.registerUpgrade(SMART_TGT, new UpgradeSmartTargeting());
        emptyInst = this.upgradeToUuidMap.get(EMPTY);
    }

    public ItemStack getUpgradeItem(UUID uuid) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("upgradeId", uuid.toString());
        ItemStack stack = new ItemStack((Item)ItemRegistry.turretUpgrade, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    public ItemStack getUpgradeItem(TurretUpgrade upgrade) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("upgradeId", this.getUpgradeUUID(upgrade).toString());
        ItemStack stack = new ItemStack((Item)ItemRegistry.turretUpgrade, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    private static final class EmptyUpgrade
    implements TurretUpgrade {
        private EmptyUpgrade() {
        }

        @Override
        public String getName() {
            return "empty";
        }

        @Override
        public String getModId() {
            return "sapturretmod";
        }

        @Override
        public String getIconTexture() {
            return "sapturretmod:upgrades/empty";
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return null;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_EMPTY;
        }

        @Override
        public boolean isTurretApplicable(Class<? extends EntityTurret> turretCls) {
            return false;
        }

        @Override
        public void onApply(EntityTurret turret) {
        }

        @Override
        public void onLoad(EntityTurret turret, NBTTagCompound nbt) {
        }

        @Override
        public void onSave(EntityTurret turret, NBTTagCompound nbt) {
        }

        @Override
        public void onRemove(EntityTurret turret) {
        }
    }
}

