/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.upgrades.TurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.NBTTagCompound;

public abstract class UpgradeReloadTime
implements TurretUpgrade {
    private final String name;
    private AttributeModifier modifier;

    public UpgradeReloadTime(String name, String modUUID, double value) {
        this.name = name;
        this.modifier = new AttributeModifier(UUID.fromString(modUUID), String.format("%s:%s", "sapturretmod", name), value, 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getModId() {
        return "sapturretmod";
    }

    @Override
    public String getIconTexture() {
        return "sapturretmod:upgrades/" + this.name;
    }

    @Override
    public boolean isTurretApplicable(Class<? extends EntityTurret> turretCls) {
        return true;
    }

    @Override
    public void onApply(EntityTurret turret) {
        if (!turret.field_70170_p.field_72995_K) {
            IAttributeInstance attrib = turret.func_110148_a(TurretAttributes.MAX_RELOAD_TICKS);
            if (attrib.func_111127_a(this.modifier.func_111167_a()) != null) {
                attrib.func_111124_b(this.modifier);
            }
            attrib.func_111121_a(this.modifier);
        }
    }

    @Override
    public void onRemove(EntityTurret turret) {
        IAttributeInstance attrib;
        if (!turret.field_70170_p.field_72995_K && (attrib = turret.func_110148_a(TurretAttributes.MAX_RELOAD_TICKS)).func_111127_a(this.modifier.func_111167_a()) != null) {
            attrib.func_111124_b(this.modifier);
            turret.func_70606_j(Math.min(turret.func_110143_aJ(), turret.func_110138_aP()));
        }
    }

    @Override
    public void onLoad(EntityTurret turret, NBTTagCompound nbt) {
    }

    @Override
    public void onSave(EntityTurret turret, NBTTagCompound nbt) {
    }

    public static class UpgradeReloadTimeMK2
    extends UpgradeReloadTime {
        private final TurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(UpgradeRegistry.RELOAD_I);

        public UpgradeReloadTimeMK2() {
            super("reload_ii", "BA6FE867-0EBF-4E1A-9ED9-05E2B47143F8", -0.35);
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return this.dependant;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_RELOAD_2;
        }
    }

    public static class UpgradeReloadTimeMK1
    extends UpgradeReloadTime {
        public UpgradeReloadTimeMK1() {
            super("reload_i", "E6DAE7D4-A730-4F57-B3F9-61C369033625", -0.15);
        }

        @Override
        public TurretUpgrade getDependantOn() {
            return null;
        }

        @Override
        public UUID getRecipeId() {
            return TurretAssemblyRecipes.UPG_RELOAD_1;
        }
    }
}

