/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.entity.turret.TargetingListener;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.registry.upgrades.TurretUpgrade;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class UpgradeSmartTargeting
implements TurretUpgrade {
    private final TargetingListener targetingListener = new TargetingListener(){

        @Override
        public boolean isTargetApplicable(EntityTurret turret, Entity target, boolean currValue) {
            double range = turret.getTargetProcessor().getRange();
            AxisAlignedBB rangeAABB = turret.field_70121_D.func_72314_b(range, range, range);
            List entities = turret.field_70170_p.func_72872_a(((Object)((Object)turret)).getClass(), rangeAABB);
            for (Object eObj : entities) {
                if (!(eObj instanceof EntityTurret) || eObj == turret || ((EntityTurret)((Object)eObj)).getTargetProcessor().getTarget() != target) continue;
                return false;
            }
            return currValue;
        }

        @Override
        public int getPriority() {
            return 0;
        }
    };
    private final String name;

    public UpgradeSmartTargeting() {
        this.name = "smart_tgt";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getModId() {
        return "sapturretmod";
    }

    @Override
    public String getIconTexture() {
        return "sapturretmod:upgrades/" + this.name;
    }

    @Override
    public TurretUpgrade getDependantOn() {
        return null;
    }

    @Override
    public boolean isTurretApplicable(Class<? extends EntityTurret> turretCls) {
        return true;
    }

    @Override
    public void onApply(EntityTurret turret) {
        if (!turret.field_70170_p.field_72995_K) {
            turret.getTargetProcessor().addTargetingListener(this.targetingListener);
        }
    }

    @Override
    public void onRemove(EntityTurret turret) {
    }

    @Override
    public UUID getRecipeId() {
        return TurretAssemblyRecipes.UPG_SMART_TGT;
    }

    @Override
    public void onLoad(EntityTurret turret, NBTTagCompound nbt) {
        if (!turret.field_70170_p.field_72995_K) {
            turret.getTargetProcessor().addTargetingListener(this.targetingListener);
        }
    }

    @Override
    public void onSave(EntityTurret turret, NBTTagCompound nbt) {
    }
}

