/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncTileEntity;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityElectrolyteGenerator
extends TileEntity
implements ISidedInventory,
TileClientSync,
IEnergyProvider {
    public static final int MAX_FLUX_STORAGE = 500000;
    public static final int MAX_FLUX_EXTRACT = 1000;
    public static final int MAX_FLUX_GENERATED = 200;
    public int fluxExtractPerTick;
    public short[] progress = new short[9];
    public short[] maxProgress = new short[this.progress.length];
    public float effectiveness;
    public boolean isItemRendered;
    private ItemStack[] invStacks = new ItemStack[23];
    private static final int[] SLOTS_INSERT = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] SLOTS_PROCESSING = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
    private static final int[] SLOTS_EXTRACT = new int[]{18, 19, 20, 21, 22};
    private ItemStack[] progExcessComm = new ItemStack[this.progress.length];
    private ItemStack[] progExcessRare = new ItemStack[this.progress.length];
    private int fluxAmount;
    private int prevFluxAmount;
    private boolean doSync;
    private int fluxBuffer;
    private static final Map<Item, Fuel> FUELS = new HashMap<Item, Fuel>(3);
    private String customName;

    public TileEntityElectrolyteGenerator() {
        this.isItemRendered = false;
    }

    public TileEntityElectrolyteGenerator(boolean itemRendered) {
        this.isItemRendered = itemRendered;
    }

    public static void initializeRecipes() {
        FUELS.put(Items.field_151174_bG, new Fuel(1.0f, 200, new ItemStack(Items.field_151102_aT, 1), new ItemStack(Items.field_151168_bH, 1)));
        FUELS.put(Items.field_151172_bF, new Fuel(1.0f, 200, new ItemStack(Items.field_151102_aT, 1), new ItemStack(Items.field_151137_ax, 1)));
        FUELS.put(Items.field_151170_bI, new Fuel(1.2f, 150, new ItemStack(Items.field_151102_aT, 1), new ItemStack(Items.field_151075_bm, 1)));
        FUELS.put(Items.field_151034_e, new Fuel(1.3f, 220, new ItemStack(Items.field_151014_N, 1), new ItemStack(Items.field_151074_bl, 1)));
    }

    public static Map<Item, Fuel> getFuels() {
        return new HashMap<Item, Fuel>(FUELS);
    }

    public boolean canUpdate() {
        return true;
    }

    public int[] func_94128_d(int side) {
        return side == ForgeDirection.DOWN.ordinal() ? SLOTS_EXTRACT : (side == ForgeDirection.UP.ordinal() ? new int[]{} : SLOTS_INSERT);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack) && side != ForgeDirection.DOWN.ordinal() && side != ForgeDirection.UP.ordinal();
    }

    public int getGeneratedFlux() {
        return this.effectiveness < 0.1f ? 0 : Math.min(200, (int)Math.round(Math.pow(1.6, this.effectiveness) / 68.71947673597977 * 80.0));
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.fluxExtractPerTick = Math.min(this.fluxAmount, 1000);
            float prevEffective = this.effectiveness;
            if (this.fluxBuffer > 0) {
                int fluxSubtracted = Math.min(500000 - this.fluxAmount, Math.min(200, this.fluxBuffer));
                this.fluxBuffer -= fluxSubtracted;
                this.fluxAmount += fluxSubtracted;
            }
            if (this.fluxBuffer <= 200 && this.fluxAmount < 500000) {
                int fluxEff = this.getGeneratedFlux();
                this.effectiveness = 0.0f;
                for (int i = 0; i < SLOTS_PROCESSING.length; ++i) {
                    if (this.invStacks[SLOTS_PROCESSING[i]] != null) {
                        if (this.progExcessComm[i] != null && !TmrUtils.canStackFitInInventory(this.progExcessComm[i], (IInventory)this, true, 64, SLOTS_EXTRACT[0], SLOTS_EXTRACT[SLOTS_EXTRACT.length - 1]) || this.progExcessRare[i] != null && !TmrUtils.canStackFitInInventory(this.progExcessRare[i], (IInventory)this, true, 64, SLOTS_EXTRACT[0], SLOTS_EXTRACT[SLOTS_EXTRACT.length - 1])) continue;
                        if (this.progress[i] <= 0) {
                            if (this.progExcessComm[i] != null) {
                                TmrUtils.addStackToInventory(this.progExcessComm[i], (IInventory)this, true, 64);
                            }
                            if (this.progExcessRare[i] != null) {
                                TmrUtils.addStackToInventory(this.progExcessRare[i], (IInventory)this, true, 64);
                            }
                            this.invStacks[TileEntityElectrolyteGenerator.SLOTS_PROCESSING[i]] = null;
                            this.func_70296_d();
                        } else {
                            this.effectiveness += TileEntityElectrolyteGenerator.FUELS.get((Object)this.invStacks[TileEntityElectrolyteGenerator.SLOTS_PROCESSING[i]].func_77973_b()).effect;
                            int n = i;
                            this.progress[n] = (short)(this.progress[n] - 1);
                        }
                        this.doSync = true;
                    }
                    if (this.invStacks[SLOTS_PROCESSING[i]] != null || this.invStacks[SLOTS_INSERT[i]] == null) continue;
                    this.invStacks[TileEntityElectrolyteGenerator.SLOTS_PROCESSING[i]] = this.invStacks[SLOTS_INSERT[i]].func_77946_l();
                    this.invStacks[TileEntityElectrolyteGenerator.SLOTS_PROCESSING[i]].field_77994_a = 1;
                    if (--this.invStacks[TileEntityElectrolyteGenerator.SLOTS_INSERT[i]].field_77994_a < 1) {
                        this.invStacks[TileEntityElectrolyteGenerator.SLOTS_INSERT[i]] = null;
                    }
                    Fuel fuel = FUELS.get(this.invStacks[SLOTS_PROCESSING[i]].func_77973_b());
                    this.progress[i] = fuel.ticksProc;
                    this.maxProgress[i] = fuel.ticksProc;
                    this.progExcessComm[i] = TmrUtils.RNG.nextInt(10) == 0 ? fuel.trash.func_77946_l() : null;
                    this.progExcessRare[i] = TmrUtils.RNG.nextInt(100) == 0 ? fuel.treasure.func_77946_l() : null;
                    this.func_70296_d();
                    this.doSync = true;
                }
                if (this.effectiveness > 0.1f) {
                    this.fluxBuffer += fluxEff;
                }
            }
            if (prevEffective < this.effectiveness - 0.01f || prevEffective > this.effectiveness + 0.01f) {
                this.doSync = true;
            }
            if (this.fluxExtractPerTick > 0) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (direction == ForgeDirection.UP) continue;
                    ForgeDirection otherDir = direction.getOpposite();
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                    if (te instanceof IEnergyReceiver) {
                        IEnergyReceiver receiver = (IEnergyReceiver)te;
                        if (!receiver.canConnectEnergy(otherDir)) continue;
                        int extractable = this.extractEnergy(direction, 1000, true);
                        int receivable = receiver.receiveEnergy(otherDir, extractable, false);
                        this.extractEnergy(direction, receivable, false);
                    }
                    if (this.fluxExtractPerTick <= 0) break;
                }
            }
            if (this.prevFluxAmount != this.fluxAmount) {
                this.doSync = true;
            }
            if (this.doSync) {
                PacketRegistry.sendToAllAround((IMessage)new PacketSyncTileEntity(this), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
            }
            this.prevFluxAmount = this.fluxAmount;
        }
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side == ForgeDirection.DOWN.ordinal() && ArrayUtils.contains((int[])SLOTS_EXTRACT, (int)slot);
    }

    public int func_70302_i_() {
        return this.invStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.invStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.invStacks[slot] != null) {
            if (this.invStacks[slot].field_77994_a <= size) {
                ItemStack itemstack = this.invStacks[slot];
                this.invStacks[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.invStacks[slot].func_77979_a(size);
            if (this.invStacks[slot].field_77994_a == 0) {
                this.invStacks[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readNbt(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNbt(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeNbt(nbt);
    }

    private void writeNbt(NBTTagCompound nbt) {
        nbt.func_74768_a("fluxAmount", this.fluxAmount);
        nbt.func_74768_a("fluxBuffer", this.fluxBuffer);
        NBTTagList progress = new NBTTagList();
        for (short s : this.progress) {
            progress.func_74742_a((NBTBase)new NBTTagShort(s));
        }
        for (short s : this.maxProgress) {
            progress.func_74742_a((NBTBase)new NBTTagShort(s));
        }
        nbt.func_74782_a("progress", (NBTBase)progress);
        nbt.func_74782_a("inventory", (NBTBase)TmrUtils.writeItemStacksToTag(this.invStacks, 64));
        if (this.func_145818_k_()) {
            nbt.func_74778_a("customName", this.customName);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNbt(nbt);
        for (int i = 0; i < this.progress.length; ++i) {
            if (this.invStacks[SLOTS_PROCESSING[i]] == null) continue;
            Fuel fuel = FUELS.get(this.invStacks[SLOTS_PROCESSING[i]].func_77973_b());
            this.progExcessComm[i] = TmrUtils.RNG.nextInt(100) == 0 ? fuel.trash.func_77946_l() : null;
            this.progExcessRare[i] = TmrUtils.RNG.nextInt(100) == 0 ? fuel.treasure.func_77946_l() : null;
        }
    }

    private void readNbt(NBTTagCompound nbt) {
        int i;
        this.fluxAmount = nbt.func_74762_e("fluxAmount");
        this.fluxBuffer = nbt.func_74762_e("fluxBuffer");
        NBTTagList progress = nbt.func_150295_c("progress", 2);
        for (i = 0; i < this.progress.length; ++i) {
            this.progress[i] = TmrUtils.getShortTagAt(progress, i);
        }
        for (i = 0; i < this.maxProgress.length; ++i) {
            this.maxProgress[i] = TmrUtils.getShortTagAt(progress, i + this.progress.length);
        }
        TmrUtils.readItemStacksFromTag(this.invStacks, nbt.func_150295_c("inventory", 10));
        if (nbt.func_150297_b("customName", 8)) {
            this.customName = nbt.func_74779_i("customName");
        }
    }

    public ItemStack func_70304_b(int slot) {
        if (this.invStacks[slot] != null) {
            ItemStack itemstack = this.invStacks[slot];
            this.invStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        int stackLimit;
        this.invStacks[slot] = stack;
        int n = stackLimit = ArrayUtils.contains((int[])SLOTS_EXTRACT, (int)slot) ? 64 : this.func_70297_j_();
        if (stack != null && stack.field_77994_a > stackLimit) {
            stack.field_77994_a = stackLimit;
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : BlockRegistry.potatoGenerator.func_149739_a() + ".name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!ItemStackUtils.isValidStack((ItemStack)stack)) {
            return stack == null;
        }
        if (ArrayUtils.contains((int[])SLOTS_INSERT, (int)slot)) {
            return FUELS.containsKey(stack.func_77973_b()) && this.invStacks[slot] == null;
        }
        return ArrayUtils.contains((int[])SLOTS_EXTRACT, (int)slot);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.fluxAmount);
        buf.writeFloat(this.effectiveness);
        for (short s : this.progress) {
            buf.writeShort((int)s);
        }
        for (short s : this.maxProgress) {
            buf.writeShort((int)s);
        }
        for (int slot : SLOTS_PROCESSING) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.func_70301_a(slot));
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        int i;
        this.fluxAmount = buf.readInt();
        this.effectiveness = buf.readFloat();
        for (i = 0; i < this.progress.length; ++i) {
            this.progress[i] = buf.readShort();
        }
        for (i = 0; i < this.maxProgress.length; ++i) {
            this.maxProgress[i] = buf.readShort();
        }
        for (int slot : SLOTS_PROCESSING) {
            this.func_70299_a(slot, ByteBufUtils.readItemStack((ByteBuf)buf));
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.fluxExtractPerTick, Math.min(1000, maxExtract));
        if (!simulate) {
            this.fluxAmount -= energyExtracted;
            this.fluxExtractPerTick -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.fluxAmount;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 500000;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    public static boolean isSlotProcessing(int slot) {
        return ArrayUtils.contains((int[])SLOTS_PROCESSING, (int)slot);
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public static Fuel getFuel(Item item) {
        return FUELS.get(item);
    }

    public static final class Fuel {
        public final float effect;
        public final short ticksProc;
        public final ItemStack trash;
        public final ItemStack treasure;

        public Fuel(float effectiveness, int ticksProcessing, ItemStack trash, ItemStack treasure) {
            this.effect = effectiveness;
            this.ticksProc = (short)ticksProcessing;
            this.trash = trash;
            this.treasure = treasure;
        }
    }
}

