/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import de.sanandrew.mods.turretmod.item.ItemAssemblyFilter;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncTileEntity;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRecipes;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.darkhax.bookshelf.lib.javatuples.Pair;
import net.darkhax.bookshelf.lib.javatuples.Triplet;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurretAssembly
extends TileEntity
implements ISidedInventory,
IEnergyHandler,
TileClientSync {
    public static final int MAX_FLUX_STORAGE = 75000;
    public static final int MAX_FLUX_INSERT = 500;
    private static final int[] SLOTS_INSERT = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
    private static final int[] SLOTS_EXTRACT = new int[]{0};
    public float robotArmX = 2.0f;
    public float robotArmY = -9.0f;
    public float prevRobotArmX;
    public float prevRobotArmY;
    public float robotMotionX = 0.0f;
    public float robotMotionY = 0.0f;
    public float robotEndX;
    public float robotEndY;
    public boolean isItemRendered = false;
    public Triplet<Float, Float, Float> spawnParticle = null;
    private boolean prevActive;
    private boolean automate;
    public boolean isActive;
    private boolean isActiveClient;
    private int fluxAmount;
    private ItemStack[] assemblyStacks = new ItemStack[23];
    public boolean syncStacks = true;
    public Pair<UUID, ItemStack> currCrafting;
    public int ticksCrafted = 0;
    public int maxTicksCrafted = 0;
    public int fluxConsumption = 0;
    private boolean doSync = false;
    private long ticksExisted = 0L;

    public TileEntityTurretAssembly() {
        this.isItemRendered = false;
    }

    public TileEntityTurretAssembly(boolean itemRendered) {
        this.isItemRendered = itemRendered;
    }

    public void beginCrafting(UUID recipe, int count) {
        ItemStack stackRes;
        if (this.currCrafting != null && recipe.equals(this.currCrafting.getValue0()) && !this.automate) {
            if (((ItemStack)this.currCrafting.getValue1()).field_77994_a + count < 1) {
                this.cancelCrafting();
            } else if (((ItemStack)this.currCrafting.getValue1()).field_77994_a + count * TurretAssemblyRecipes.INSTANCE.getRecipeResult((UUID)recipe).field_77994_a <= ((ItemStack)this.currCrafting.getValue1()).func_77976_d()) {
                ((ItemStack)this.currCrafting.getValue1()).field_77994_a += count;
                this.doSync = true;
            } else {
                ((ItemStack)this.currCrafting.getValue1()).field_77994_a = ((ItemStack)this.currCrafting.getValue1()).func_77976_d();
                this.doSync = true;
            }
        } else if (this.currCrafting == null && (stackRes = TurretAssemblyRecipes.INSTANCE.getRecipeResult(recipe)) != null) {
            stackRes = stackRes.func_77946_l();
            stackRes.field_77994_a = this.automate ? 1 : count;
            this.currCrafting = Pair.with((Object)recipe, (Object)stackRes);
            this.maxTicksCrafted = TurretAssemblyRecipes.INSTANCE.getRecipeEntry((UUID)recipe).ticksProcessing;
            this.doSync = true;
        }
    }

    public void cancelCrafting() {
        this.currCrafting = null;
        this.ticksCrafted = 0;
        this.fluxConsumption = 0;
        this.maxTicksCrafted = 0;
        this.isActive = false;
        this.doSync = true;
    }

    private void initCrafting() {
        if (this.currCrafting != null && (this.assemblyStacks[0] == null || this.assemblyStacks[0].field_77994_a < this.assemblyStacks[0].func_77976_d())) {
            UUID currCrfUUID = (UUID)this.currCrafting.getValue0();
            ItemStack addStacks = ((ItemStack)this.currCrafting.getValue1()).func_77946_l();
            ItemStack recipe = TurretAssemblyRecipes.INSTANCE.getRecipeResult(currCrfUUID);
            if (recipe != null) {
                addStacks.field_77994_a = recipe.field_77994_a;
                if (TmrUtils.canStack(this.assemblyStacks[0], addStacks, true) && TurretAssemblyRecipes.INSTANCE.checkAndConsumeResources((IInventory)this, currCrfUUID)) {
                    TurretAssemblyRecipes.RecipeEntry currentlyCrafted = TurretAssemblyRecipes.INSTANCE.getRecipeEntry(currCrfUUID);
                    this.maxTicksCrafted = currentlyCrafted.ticksProcessing;
                    this.fluxConsumption = MathHelper.func_76123_f((float)((float)currentlyCrafted.fluxPerTick * (this.hasSpeedUpgrade() ? 1.1f : 1.0f)));
                    this.ticksCrafted = 0;
                    this.isActive = true;
                    this.doSync = true;
                }
            } else {
                this.cancelCrafting();
            }
        }
    }

    public boolean hasAutoUpgrade() {
        return ItemStackUtils.isValidStack((ItemStack)this.assemblyStacks[1]) && this.assemblyStacks[1].func_77973_b() == ItemRegistry.asbAuto;
    }

    public boolean hasSpeedUpgrade() {
        return ItemStackUtils.isValidStack((ItemStack)this.assemblyStacks[2]) && this.assemblyStacks[2].func_77973_b() == ItemRegistry.asbSpeed;
    }

    public boolean hasFilterUpgrade() {
        return ItemStackUtils.isValidStack((ItemStack)this.assemblyStacks[3]) && this.assemblyStacks[3].func_77973_b() == ItemRegistry.asbFilter;
    }

    public ItemStack[] getFilterStacks() {
        if (this.hasFilterUpgrade()) {
            return ItemRegistry.asbFilter.getFilterStacks(this.assemblyStacks[3], false);
        }
        return ItemAssemblyFilter.EMPTY_INV;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.automate && !this.hasAutoUpgrade()) {
                this.automate = false;
                this.cancelCrafting();
            }
            int maxLoop = this.hasSpeedUpgrade() ? 4 : 1;
            boolean markDirty = false;
            for (int i = 0; i < maxLoop; ++i) {
                this.isActiveClient = this.isActive;
                if (this.isActive && this.currCrafting != null) {
                    if (this.fluxAmount >= this.fluxConsumption && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                        this.fluxAmount -= this.fluxConsumption;
                        if (++this.ticksCrafted >= this.maxTicksCrafted) {
                            ItemStack stack = TurretAssemblyRecipes.INSTANCE.getRecipeResult((UUID)this.currCrafting.getValue0());
                            if (this.assemblyStacks[0] != null) {
                                this.assemblyStacks[0].field_77994_a += stack.field_77994_a;
                            } else {
                                this.assemblyStacks[0] = stack.func_77946_l();
                            }
                            if (this.assemblyStacks[0].field_77994_a + stack.field_77994_a > this.assemblyStacks[0].func_77976_d()) {
                                this.isActive = false;
                                this.isActiveClient = false;
                            }
                            if (!TurretAssemblyRecipes.INSTANCE.checkAndConsumeResources((IInventory)this, (UUID)this.currCrafting.getValue0())) {
                                this.isActive = false;
                                this.isActiveClient = false;
                            }
                            if (((ItemStack)this.currCrafting.getValue1()).field_77994_a > 1) {
                                if (!this.automate) {
                                    --((ItemStack)this.currCrafting.getValue1()).field_77994_a;
                                }
                            } else if (!this.automate) {
                                this.currCrafting = null;
                                this.maxTicksCrafted = 0;
                                this.isActive = false;
                                this.isActiveClient = false;
                                this.fluxConsumption = 0;
                            }
                            this.ticksCrafted = 0;
                            markDirty = true;
                        }
                        this.doSync = true;
                        continue;
                    }
                    this.isActiveClient = false;
                    this.doSync = true;
                    continue;
                }
                this.initCrafting();
                this.isActiveClient = false;
            }
            if (markDirty) {
                this.func_70296_d();
            }
            if (this.doSync) {
                PacketSyncTileEntity.sync(this);
                this.doSync = false;
            }
        } else {
            this.processRobotArm();
        }
        this.prevActive = this.isActive;
        ++this.ticksExisted;
    }

    private void processRobotArm() {
        this.prevRobotArmX = this.robotArmX;
        this.prevRobotArmY = this.robotArmY;
        this.robotArmX += this.robotMotionX;
        this.robotArmY += this.robotMotionY;
        if (this.robotArmX > this.robotEndX && this.robotMotionX > 0.0f) {
            this.robotArmX = this.robotEndX;
            this.robotMotionX = 0.0f;
        } else if (this.robotArmX < this.robotEndX && this.robotMotionX < 0.0f) {
            this.robotArmX = this.robotEndX;
            this.robotMotionX = 0.0f;
        }
        if (this.robotArmY > this.robotEndY && this.robotMotionY > 0.0f) {
            this.robotArmY = this.robotEndY;
            this.robotMotionY = 0.0f;
        } else if (this.robotArmY < this.robotEndY && this.robotMotionY < 0.0f) {
            this.robotArmY = this.robotEndY;
            this.robotMotionY = 0.0f;
        }
        if (this.isActiveClient && (!this.prevActive || this.ticksExisted % 20L == 0L)) {
            this.animateRobotArmRng();
        } else if (this.prevActive && !this.isActiveClient) {
            this.animateRobotArmReset();
            this.spawnParticle = null;
        }
        if (this.isActiveClient && this.spawnParticle != null) {
            TurretModRebirth.proxy.spawnParticle(EnumParticle.ASSEMBLY_SPARK, ((Float)this.spawnParticle.getValue0()).floatValue(), ((Float)this.spawnParticle.getValue1()).floatValue() + 0.05f, ((Float)this.spawnParticle.getValue2()).floatValue(), null);
            this.spawnParticle = null;
        }
    }

    private void animateRobotArmRng() {
        float endX = 4.0f + TmrUtils.RNG.nextFloat() * 6.0f;
        float endY = -3.5f + TmrUtils.RNG.nextFloat() * -6.0f;
        this.robotMotionX = (0.1f + TmrUtils.RNG.nextFloat() * 0.1f) * (endX > this.robotArmX ? 1.0f : -1.0f);
        this.robotMotionY = (0.1f + TmrUtils.RNG.nextFloat() * 0.1f) * (endY > this.robotArmY ? 1.0f : -1.0f);
        this.robotEndX = endX;
        this.robotEndY = endY;
    }

    private void animateRobotArmReset() {
        float endX = 2.0f;
        float endY = -9.0f;
        this.robotMotionX = (0.1f + TmrUtils.RNG.nextFloat() * 0.1f) * (endX > this.robotArmX ? 1.0f : -1.0f);
        this.robotMotionY = (0.1f + TmrUtils.RNG.nextFloat() * 0.1f) * (endY > this.robotArmY ? 1.0f : -1.0f);
        this.robotEndX = endX;
        this.robotEndY = endY;
    }

    public boolean canUpdate() {
        return true;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readNBT(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNBT(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
        this.doSync = true;
    }

    private void writeNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isActive", this.isActive);
        nbt.func_74768_a("flux", this.fluxAmount);
        nbt.func_74782_a("inventory", (NBTBase)TmrUtils.writeItemStacksToTag(this.assemblyStacks, 64));
        if (this.currCrafting != null) {
            nbt.func_74778_a("craftingUUID", ((UUID)this.currCrafting.getValue0()).toString());
            ItemStackUtils.writeStackToTag((ItemStack)((ItemStack)this.currCrafting.getValue1()), (NBTTagCompound)nbt, (String)"craftingStack");
        }
        nbt.func_74768_a("ticksCrafted", this.ticksCrafted);
        nbt.func_74768_a("maxTicksCrafted", this.maxTicksCrafted);
        nbt.func_74768_a("fluxConsumption", this.fluxConsumption);
        nbt.func_74757_a("automate", this.automate);
    }

    private void readNBT(NBTTagCompound nbt) {
        this.isActive = nbt.func_74767_n("isActive");
        this.fluxAmount = nbt.func_74762_e("flux");
        TmrUtils.readItemStacksFromTag(this.assemblyStacks, nbt.func_150295_c("inventory", 10));
        if (nbt.func_74764_b("craftingUUID") && nbt.func_74764_b("craftingStack")) {
            this.currCrafting = Pair.with((Object)UUID.fromString(nbt.func_74779_i("craftingUUID")), (Object)ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("craftingStack")));
        }
        this.ticksCrafted = nbt.func_74762_e("ticksCrafted");
        this.maxTicksCrafted = nbt.func_74762_e("maxTicksCrafted");
        this.fluxConsumption = nbt.func_74762_e("fluxConsumption");
        this.automate = nbt.func_74767_n("automate");
    }

    private boolean isStackAcceptable(ItemStack stack, int insrtSlot) {
        if (this.hasFilterUpgrade()) {
            ItemStack[] filter = this.getFilterStacks();
            if (TmrUtils.isStackInArray(stack, filter)) {
                return TmrUtils.areStacksEqual(stack, filter[insrtSlot], TmrUtils.NBT_COMPARATOR_FIXD);
            }
            return !ItemStackUtils.isValidStack((ItemStack)filter[insrtSlot]);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        return side == ForgeDirection.DOWN.ordinal() ? SLOTS_EXTRACT : (side == ForgeDirection.UP.ordinal() ? new int[]{} : SLOTS_INSERT);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack) && side != ForgeDirection.DOWN.ordinal() && side != ForgeDirection.UP.ordinal();
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0 && side == ForgeDirection.DOWN.ordinal();
    }

    public int func_70302_i_() {
        return this.assemblyStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.assemblyStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (!this.hasAutoUpgrade()) {
            this.automate = false;
        }
        if (this.assemblyStacks[slot] != null) {
            if (this.assemblyStacks[slot].field_77994_a <= size) {
                ItemStack itemstack = this.assemblyStacks[slot];
                this.assemblyStacks[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.assemblyStacks[slot].func_77979_a(size);
            if (this.assemblyStacks[slot].field_77994_a == 0) {
                this.assemblyStacks[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.assemblyStacks[slot] != null) {
            ItemStack itemstack = this.assemblyStacks[slot];
            this.assemblyStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.hasAutoUpgrade()) {
            this.automate = false;
        }
        this.assemblyStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 && ItemStackUtils.isValidStack((ItemStack)stack) && (slot > 4 && this.isStackAcceptable(stack, slot - 5) || slot == 1 && stack.func_77973_b() == ItemRegistry.asbAuto || slot == 2 && stack.func_77973_b() == ItemRegistry.asbSpeed || slot == 3 && stack.func_77973_b() == ItemRegistry.asbFilter);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.getMaxEnergyStored(from) - this.fluxAmount, Math.min(500, maxReceive));
        if (!simulate) {
            this.fluxAmount += energyReceived;
            this.doSync = true;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.fluxAmount;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 75000;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.fluxAmount);
        buf.writeInt(this.fluxConsumption);
        buf.writeBoolean(this.isActive);
        buf.writeInt(this.ticksCrafted);
        buf.writeInt(this.maxTicksCrafted);
        buf.writeBoolean(this.automate);
        buf.writeBoolean(this.isActiveClient);
        if (this.currCrafting != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.currCrafting.getValue1()));
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((UUID)this.currCrafting.getValue0()).toString());
        } else {
            ByteBufUtils.writeItemStack((ByteBuf)buf, null);
        }
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.assemblyStacks[0]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.assemblyStacks[1]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.assemblyStacks[2]);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.assemblyStacks[3]);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.fluxAmount = buf.readInt();
        this.fluxConsumption = buf.readInt();
        this.isActive = buf.readBoolean();
        this.ticksCrafted = buf.readInt();
        this.maxTicksCrafted = buf.readInt();
        this.automate = buf.readBoolean();
        this.isActiveClient = buf.readBoolean();
        ItemStack crfStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.currCrafting = crfStack != null ? Pair.with((Object)UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf)), (Object)crfStack) : null;
        if (this.syncStacks) {
            this.assemblyStacks[0] = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.assemblyStacks[1] = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.assemblyStacks[2] = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.assemblyStacks[3] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void setAutomated(boolean b) {
        if (this.currCrafting == null) {
            this.automate = b;
            this.doSync = true;
        }
    }

    public boolean isAutomated() {
        return this.automate;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }
}

