/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class TmrCreativeTabs {
    private static final Comparator<ItemStack> ITM_TYPE_COMP = new ItemTypeComparator();
    private static final Comparator<ItemStack> ITM_NAME_COMP = new ItemNameComparator();
    public static final CreativeTabs TURRETS = new CreativeTabs("sapturretmod:turrets"){
        private ItemStack[] tabIcons;

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            return Items.field_151065_br;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            if (this.tabIcons == null) {
                ArrayList subItms = new ArrayList();
                ItemRegistry.turret.func_150895_a(ItemRegistry.turret, this, subItms);
                this.tabIcons = subItms.toArray(new ItemStack[subItms.size()]);
            }
            return this.tabIcons[(int)(System.currentTimeMillis() / 4250L) % this.tabIcons.length];
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(List itmList) {
            super.func_78018_a(itmList);
            Collections.sort(itmList, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    return o1 != null && o1.func_77973_b() == ItemRegistry.turret ? 1 : (o2 != null && o2.func_77973_b() == ItemRegistry.turret ? -1 : 0);
                }
            });
            TmrCreativeTabs.sortItemsBySubItems(itmList, this);
        }
    };
    public static final CreativeTabs MISC = new CreativeTabs("sapturretmod:misc"){

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            return ItemRegistry.tcu;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(List itmList) {
            super.func_78018_a(itmList);
            TmrCreativeTabs.sortItemsBySubItems(itmList, this);
        }
    };
    public static final CreativeTabs UPGRADES = new CreativeTabs("sapturretmod:upgrades"){
        private ItemStack[] tabIcons;

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            return ItemRegistry.turretUpgrade;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            if (this.tabIcons == null) {
                ArrayList subItms = new ArrayList();
                ItemRegistry.turretUpgrade.func_150895_a(ItemRegistry.turretUpgrade, this, subItms);
                this.tabIcons = subItms.toArray(new ItemStack[subItms.size()]);
            }
            return this.tabIcons[(int)(System.currentTimeMillis() / 4250L) % this.tabIcons.length];
        }

        @SideOnly(value=Side.CLIENT)
        public void func_78018_a(List itmList) {
            super.func_78018_a(itmList);
            TmrCreativeTabs.sortItemsByName(itmList);
            TmrCreativeTabs.sortItemsBySubItems(itmList, this);
        }
    };

    protected static void sortItemsByType(List<ItemStack> items) {
        Collections.sort(items, ITM_TYPE_COMP);
    }

    protected static void sortItemsByName(List<ItemStack> items) {
        Collections.sort(items, ITM_NAME_COMP);
    }

    protected static void sortItemsBySubItems(List<ItemStack> items, CreativeTabs tab) {
        Collections.sort(items, new ItemSubComparator(tab));
    }

    private static class ItemSubComparator
    implements Comparator<ItemStack> {
        private final CreativeTabs tab;

        private ItemSubComparator(CreativeTabs thisTab) {
            this.tab = thisTab;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            if (o1.func_77973_b() != o2.func_77973_b()) {
                return -1;
            }
            ArrayList<ItemStack> subItms = new ArrayList<ItemStack>();
            o1.func_77973_b().func_150895_a(o1.func_77973_b(), this.tab, subItms);
            return ItemSubComparator.getStackIndexInList(o2, subItms) > ItemSubComparator.getStackIndexInList(o1, subItms) ? -1 : 1;
        }

        private static int getStackIndexInList(ItemStack stack, List<ItemStack> stackArray) {
            for (ItemStack stackElem : stackArray) {
                if (!ItemStackUtils.areStacksEqual((ItemStack)stack, (ItemStack)stackElem, (boolean)true)) continue;
                return stackArray.indexOf(stackElem);
            }
            return -1;
        }
    }

    private static class ItemNameComparator
    implements Comparator<ItemStack> {
        private ItemNameComparator() {
        }

        @Override
        public int compare(ItemStack stack1, ItemStack stack2) {
            return stack2.func_77977_a().compareTo(stack1.func_77977_a());
        }
    }

    private static class ItemTypeComparator
    implements Comparator<ItemStack> {
        private ItemTypeComparator() {
        }

        @Override
        public int compare(ItemStack stack1, ItemStack stack2) {
            return ItemBlock.class.isAssignableFrom(stack1.func_77973_b().getClass()) && !ItemBlock.class.isAssignableFrom(stack2.func_77973_b().getClass()) ? -1 : 1;
        }
    }
}

