/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.darkhax.bookshelf.lib.javatuples.Pair;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.ReflectionUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TmrUtils {
    public static final Random RNG = new Random();
    public static final int ATTR_ADD_VAL_TO_BASE = 0;
    public static final int ATTR_ADD_PERC_VAL_TO_SUM = 1;
    public static final int RISE_SUM_WITH_PERC_VAL = 2;
    public static final Comparator<NBTTagCompound> NBT_COMPARATOR_FIXD = new Comparator<NBTTagCompound>(){

        @Override
        public int compare(NBTTagCompound firstTag, NBTTagCompound secondTag) {
            return firstTag != null ? (firstTag.equals((Object)secondTag) ? 0 : 1) : (secondTag != null ? -1 : 0);
        }
    };

    public static Entity getEntityByUUID(World worldObj, UUID uuid) {
        for (Object entity : worldObj.field_72996_f) {
            if (!(entity instanceof Entity) || !((Entity)entity).func_110124_au().equals(uuid)) continue;
            return (Entity)entity;
        }
        return null;
    }

    public static <T> T valueOrDefault(T val, T def) {
        return val != null ? val : def;
    }

    public static boolean getIsAIEnabled(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        return (Boolean)ReflectionUtils.invokeCachedMethod(EntityLivingBase.class, (Object)entity, (String)"isAIEnabled", (String)"func_70650_aV", null, null);
    }

    public static boolean getIsPotionSplash(PotionEffect potionEffect) {
        if (potionEffect == null) {
            return false;
        }
        return (Boolean)ReflectionUtils.getCachedFieldValue(PotionEffect.class, (Object)potionEffect, (String)"isSplashPotion", (String)"field_82723_d");
    }

    public static int getOreRecipeWidth(ShapedOreRecipe recipe) {
        if (recipe == null) {
            return 0;
        }
        return (Integer)ReflectionUtils.getCachedFieldValue(ShapedOreRecipe.class, (Object)recipe, (String)"width", (String)"width");
    }

    public static int getOreRecipeHeight(ShapedOreRecipe recipe) {
        if (recipe == null) {
            return 0;
        }
        return (Integer)ReflectionUtils.getCachedFieldValue(ShapedOreRecipe.class, (Object)recipe, (String)"height", (String)"height");
    }

    public static float getLastDamage(EntityLivingBase entity) {
        if (entity == null) {
            return 0.0f;
        }
        return ((Float)ReflectionUtils.getCachedFieldValue(EntityLivingBase.class, (Object)entity, (String)"lastDamage", (String)"field_110153_bc")).floatValue();
    }

    public static void setAiMoveTowardsTargetEntity(EntityAIMoveTowardsTarget ai, EntityLivingBase e) {
        ReflectionUtils.setCachedFieldValue(EntityAIMoveTowardsTarget.class, (Object)ai, (String)"targetEntity", (String)"field_75429_b", (Object)e);
    }

    public static short getShortTagAt(NBTTagList list, int index) {
        List tagList = (List)ReflectionUtils.getCachedFieldValue(NBTTagList.class, (Object)list, (String)"tagList", (String)"field_74747_a");
        if (index >= 0 && index < tagList.size()) {
            NBTBase nbtbase = (NBTBase)tagList.get(index);
            return nbtbase.func_74732_a() == 2 ? ((NBTTagShort)nbtbase).func_150289_e() : (short)0;
        }
        return 0;
    }

    public static ShapedRecipes findShapedRecipe(ItemStack result) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (Object recipe : recipes) {
            ShapedRecipes sRecipe;
            ItemStack recipeResult;
            if (!(recipe instanceof ShapedRecipes) || !TmrUtils.areStacksEqual(recipeResult = (sRecipe = (ShapedRecipes)recipe).func_77571_b(), result, result.func_77942_o() ? NBT_COMPARATOR_FIXD : null)) continue;
            return sRecipe;
        }
        return null;
    }

    public static ShapedOreRecipe findShapedOreRecipe(ItemStack result) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (Object recipe : recipes) {
            ShapedOreRecipe sRecipe;
            ItemStack recipeResult;
            if (!(recipe instanceof ShapedOreRecipe) || !TmrUtils.areStacksEqual(recipeResult = (sRecipe = (ShapedOreRecipe)recipe).func_77571_b(), result, result.func_77942_o() ? NBT_COMPARATOR_FIXD : null)) continue;
            return sRecipe;
        }
        return null;
    }

    public static ShapelessRecipes findShapelessRecipe(ItemStack result) {
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (Object recipe : recipes) {
            ShapelessRecipes sRecipe;
            ItemStack recipeResult;
            if (!(recipe instanceof ShapelessRecipes) || !TmrUtils.areStacksEqual(recipeResult = (sRecipe = (ShapelessRecipes)recipe).func_77571_b(), result, result.func_77942_o() ? NBT_COMPARATOR_FIXD : null)) continue;
            return sRecipe;
        }
        return null;
    }

    public static EntityAIBase getAIFromTaskList(List<?> taskList, Class<?> cls) {
        for (Object obj : taskList) {
            if (!(obj instanceof EntityAITasks.EntityAITaskEntry)) continue;
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)obj;
            if (!entry.field_75733_a.getClass().equals(cls)) continue;
            return entry.field_75733_a;
        }
        return null;
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack, Comparator<NBTTagCompound> comparator) {
        if (firstStack != null && secondStack != null) {
            Item firstItem = firstStack.func_77973_b();
            Item secondItem = secondStack.func_77973_b();
            return firstItem != null && secondItem != null ? !(firstItem != secondItem || comparator != null && comparator.compare(firstStack.func_77978_p(), secondStack.func_77978_p()) != 0 || firstStack.func_77960_j() != Short.MAX_VALUE && secondStack.func_77960_j() != Short.MAX_VALUE && firstStack.func_77960_j() != secondStack.func_77960_j()) : firstItem == secondItem;
        }
        return firstStack == secondStack;
    }

    public static boolean isStackInArray(ItemStack stack, ItemStack ... stacks) {
        for (ItemStack currentStack : stacks) {
            if (!TmrUtils.areStacksEqual(stack, currentStack, NBT_COMPARATOR_FIXD)) continue;
            return true;
        }
        return false;
    }

    public static Pair<Integer, ItemStack> getSimilarStackFromInventory(ItemStack stack, IInventory inv, Comparator<NBTTagCompound> comparator) {
        if (!ItemStackUtils.isValidStack((ItemStack)stack)) {
            return null;
        }
        if (inv == null) {
            return null;
        }
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (!ItemStackUtils.isValidStack((ItemStack)invStack) || !(comparator == null ? ItemStackUtils.areStacksEqual((ItemStack)stack, (ItemStack)invStack, (boolean)false) : TmrUtils.areStacksEqual(stack, invStack, comparator))) continue;
            return Pair.with((Object)i, (Object)invStack);
        }
        return null;
    }

    public static ItemStack addStackToInventory(ItemStack is, IInventory inv) {
        return TmrUtils.addStackToInventory(is, inv, true);
    }

    public static boolean canStackFitInInventory(ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize) {
        return TmrUtils.canStackFitInInventory(is, inv, checkNBT, maxStackSize, 0, inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0));
    }

    public static boolean canStackFitInInventory(ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize, int begin, int end) {
        ItemStack stack = is.func_77946_l();
        for (int i = begin; i < end; ++i) {
            ItemStack invIS = inv.func_70301_a(i);
            if (invIS != null && (checkNBT && TmrUtils.areStacksEqual(is, invIS, NBT_COMPARATOR_FIXD) || !checkNBT && ItemStackUtils.areStacksEqual((ItemStack)is, (ItemStack)invIS, (boolean)false))) {
                int fit = StrictMath.min(invIS.func_77976_d(), maxStackSize) - invIS.field_77994_a;
                if (fit >= stack.field_77994_a) {
                    return true;
                }
                stack.field_77994_a -= fit;
                continue;
            }
            if (invIS != null || !inv.func_94041_b(i, stack)) continue;
            int max = StrictMath.min(stack.func_77976_d(), maxStackSize);
            if (stack.field_77994_a - max <= 0) {
                return true;
            }
            stack.field_77994_a -= max;
        }
        return false;
    }

    public static ItemStack addStackToInventory(ItemStack is, IInventory inv, boolean checkNBT) {
        return TmrUtils.addStackToInventory(is, inv, checkNBT, inv.func_70297_j_());
    }

    public static ItemStack addStackToInventory(ItemStack is, IInventory inv, boolean checkNBT, int maxStackSize) {
        int invSize = inv.func_70302_i_() - (inv instanceof InventoryPlayer ? 4 : 0);
        for (int i = 0; i < invSize && is != null; ++i) {
            int rest;
            ItemStack invIS = inv.func_70301_a(i);
            if (invIS != null && (checkNBT && TmrUtils.areStacksEqual(is, invIS, NBT_COMPARATOR_FIXD) || !checkNBT && ItemStackUtils.areStacksEqual((ItemStack)is, (ItemStack)invIS, (boolean)false))) {
                rest = is.field_77994_a + invIS.field_77994_a;
                int maxStack = Math.min(invIS.func_77976_d(), maxStackSize);
                if (rest <= maxStack) {
                    invIS.field_77994_a = rest;
                    inv.func_70299_a(i, invIS.func_77946_l());
                    is = null;
                    break;
                }
                int rest1 = rest - maxStack;
                invIS.field_77994_a = maxStack;
                inv.func_70299_a(i, invIS.func_77946_l());
                is.field_77994_a = rest1;
                continue;
            }
            if (invIS != null || !inv.func_94041_b(i, is)) continue;
            if (is.field_77994_a <= maxStackSize) {
                inv.func_70299_a(i, is.func_77946_l());
                is = null;
                break;
            }
            rest = is.field_77994_a - maxStackSize;
            is.field_77994_a = maxStackSize;
            inv.func_70299_a(i, is.func_77946_l());
            is.field_77994_a = rest;
        }
        return is;
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2, boolean consumeAll) {
        return stack1 == null || stack2 == null || stack1.func_77985_e() && stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77960_j() == stack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && (!consumeAll || stack1.field_77994_a + stack2.field_77994_a <= stack1.func_77976_d());
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        return TmrUtils.writeItemStacksToTag(items, maxQuantity, null, null);
    }

    public static NBTTagList writeItemStacksToTag(ItemStack[] items, int maxQuantity, Object caller, String callbackMethod) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("Slot", (short)i);
            items[i].func_77955_b(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.func_74768_a("Quantity", Math.min(items[i].field_77994_a, maxQuantity));
            } else if (maxQuantity > 127) {
                tag.func_74777_a("Quantity", (short)Math.min(items[i].field_77994_a, maxQuantity));
            } else {
                tag.func_74774_a("Quantity", (byte)Math.min(items[i].field_77994_a, maxQuantity));
            }
            if (callbackMethod != null) {
                try {
                    Method callback = ReflectionUtils.getCachedMethod(caller.getClass(), (String)callbackMethod, (String)callbackMethod, (Class[])new Class[]{ItemStack.class, NBTTagCompound.class});
                    NBTTagCompound stackNbt = new NBTTagCompound();
                    callback.invoke(caller, items[i], stackNbt);
                    tag.func_74782_a("StackNBT", (NBTBase)stackNbt);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Cannot call callback method for writeItemStacksToTag()!", e);
                }
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList) {
        TmrUtils.readItemStacksFromTag(items, tagList, null, null);
    }

    public static void readItemStacksFromTag(ItemStack[] items, NBTTagList tagList, Object caller, String callbackMethod) {
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            short b = tag.func_74765_d("Slot");
            items[b] = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (tag.func_74764_b("Quantity")) {
                items[b].field_77994_a = ((NBTBase.NBTPrimitive)tag.func_74781_a("Quantity")).func_150287_d();
            }
            if (callbackMethod == null || !tag.func_74764_b("StackNBT")) continue;
            try {
                Method callback = ReflectionUtils.getCachedMethod(caller.getClass(), (String)callbackMethod, (String)callbackMethod, (Class[])new Class[]{ItemStack.class, NBTTagCompound.class});
                callback.invoke(caller, items[b], tag.func_74781_a("StackNBT"));
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Cannot call callback method for readItemStacksFromTag()!", e);
            }
        }
    }
}

