/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension;

import com.telepathicgrunt.ultraamplifieddimension.modInit.UADBlocks;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADTags;
import com.telepathicgrunt.ultraamplifieddimension.world.features.AmplifiedPortalFrame;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class AmplifiedPortalCreation {
    public static void PortalCreationRightClick(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        Entity entity = event.getEntity();
        if (!world.func_201670_d() && entity instanceof PlayerEntity && !entity.func_213453_ef()) {
            PlayerEntity player = (PlayerEntity)entity;
            if (event.getItemStack().func_77973_b().func_206844_a(UADTags.PORTAL_ACTIVATION_ITEMS) && AmplifiedPortalCreation.trySpawnPortal((IWorld)world, event.getPos())) {
                player.func_226292_a_(player.func_184600_cs(), true);
                event.setResult(Event.Result.DENY);
            }
        }
    }

    public static boolean checkForGeneratedPortal(IWorld worldUA) {
        BlockPos pos = new BlockPos(8, worldUA.func_234938_ad_(), 8);
        worldUA.func_217349_x(pos);
        while (pos.func_177956_o() >= 0) {
            if (worldUA.func_180495_p(pos) == ((Block)UADBlocks.AMPLIFIED_PORTAL.get()).func_176223_P()) {
                return true;
            }
            pos = pos.func_177977_b();
        }
        return false;
    }

    public static void generatePortal(ServerWorld worldUA) {
        AmplifiedPortalFrame amplifiedPortalFrame = new AmplifiedPortalFrame();
        BlockPos pos = new BlockPos(8, worldUA.func_234938_ad_(), 8);
        worldUA.func_217349_x(pos);
        pos = worldUA.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos);
        if (pos.func_177956_o() > 252) {
            pos = pos.func_177979_c(3);
        } else if (pos.func_177956_o() < 6) {
            pos = new BlockPos(pos.func_177958_n(), 6, pos.func_177952_p());
        }
        amplifiedPortalFrame.generate((ISeedReader)worldUA, pos);
    }

    public static boolean isValid(IWorld world, BlockPos pos) {
        int z;
        int x;
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                BlockState currentFloor;
                if (!(Math.abs(x * z) == 1 ? !world.func_180495_p(pos.func_177982_a(x, -1, z)).func_235714_a_(UADTags.PORTAL_CORNER_BLOCKS) : !(currentFloor = world.func_180495_p(pos.func_177982_a(x, -1, z))).func_235714_a_(UADTags.PORTAL_NON_CORNER_BLOCKS) || currentFloor.func_235901_b_((Property)SlabBlock.field_196505_a) && currentFloor.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.BOTTOM)) continue;
                return false;
            }
        }
        if (!world.func_180495_p(pos.func_177982_a(0, 0, 0)).func_235714_a_(UADTags.PORTAL_CENTER_BLOCKS)) {
            return false;
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                BlockState currentCeiling;
                if (!(Math.abs(x * z) == 1 ? !world.func_180495_p(pos.func_177982_a(x, 1, z)).func_235714_a_(UADTags.PORTAL_CORNER_BLOCKS) : !(currentCeiling = world.func_180495_p(pos.func_177982_a(x, 1, z))).func_235714_a_(UADTags.PORTAL_NON_CORNER_BLOCKS) || currentCeiling.func_235901_b_((Property)SlabBlock.field_196505_a) && currentCeiling.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.TOP)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean trySpawnPortal(IWorld world, BlockPos pos) {
        boolean canMakePortal = AmplifiedPortalCreation.isValid(world, pos);
        if (canMakePortal) {
            world.func_180501_a(pos, ((Block)UADBlocks.AMPLIFIED_PORTAL.get()).func_176223_P(), 18);
        }
        return canMakePortal;
    }
}

