/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.ChunkGeneratorAccessor;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.DimensionSettingsInvoker;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.NoiseChunkGeneratorAccessor;
import com.telepathicgrunt.ultraamplifieddimension.utils.WorldSeedHolder;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.OceanMonumentPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;

public class UADChunkGenerator
extends NoiseChunkGenerator {
    private static final float[] BIOME_WEIGHTING_KERNEL = (float[])Util.func_200696_a((Object)new float[25], floats -> {
        for (int xRelative = -2; xRelative <= 2; ++xRelative) {
            for (int zRelative = -2; zRelative <= 2; ++zRelative) {
                float biomeWeighting;
                floats[xRelative + 2 + (zRelative + 2) * 5] = biomeWeighting = 10.0f / MathHelper.func_76129_c((float)((float)(xRelative * xRelative + zRelative * zRelative) + 0.2f));
            }
        }
    });
    private static final float[] TERRAFORMING_NOISE_KERNAL = (float[])Util.func_200696_a((Object)new float[13824], floats -> {
        for (int x = 0; x < 24; ++x) {
            for (int z = 0; z < 24; ++z) {
                for (int y = 0; y < 24; ++y) {
                    floats[x * 24 * 24 + z * 24 + y] = (float)UADChunkGenerator.getTerrainValue(z - 12, y - 12, x - 12);
                }
            }
        }
    });
    private static final float[] GIANT_TERRAFORMING_NOISE_KERNAL = (float[])Util.func_200696_a((Object)new float[13824], floats -> {
        for (int x = 0; x < 24; ++x) {
            for (int z = 0; z < 24; ++z) {
                for (int y = 0; y < 24; ++y) {
                    floats[x * 24 * 24 + z * 24 + y] = (float)UADChunkGenerator.getGiantTerrainValue(z - 12, y - 12, x - 12);
                }
            }
        }
    });
    public static final Codec<ScalingSettings> UAD_SCALING_CODEC = RecordCodecBuilder.create(scalingSettingsInstance -> scalingSettingsInstance.group((App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(ScalingSettings::func_236151_a_), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(ScalingSettings::func_236153_b_), (App)Codec.DOUBLE.fieldOf("xz_factor").forGetter(ScalingSettings::func_236154_c_), (App)Codec.DOUBLE.fieldOf("y_factor").forGetter(ScalingSettings::func_236155_d_)).apply((Applicative)scalingSettingsInstance, ScalingSettings::new));
    public static final Codec<NoiseSettings> UAD_NOISE_SETTINGS_CODEC = RecordCodecBuilder.create(noiseSettingsInstance -> noiseSettingsInstance.group((App)Codec.intRange((int)0, (int)256).fieldOf("height").forGetter(NoiseSettings::func_236169_a_), (App)UAD_SCALING_CODEC.fieldOf("sampling").forGetter(NoiseSettings::func_236171_b_), (App)SlideSettings.field_236182_a_.fieldOf("top_slide").forGetter(NoiseSettings::func_236172_c_), (App)SlideSettings.field_236182_a_.fieldOf("bottom_slide").forGetter(NoiseSettings::func_236173_d_), (App)Codec.INT.fieldOf("size_horizontal").forGetter(NoiseSettings::func_236174_e_), (App)Codec.INT.fieldOf("size_vertical").forGetter(NoiseSettings::func_236175_f_), (App)Codec.DOUBLE.fieldOf("density_factor").forGetter(NoiseSettings::func_236176_g_), (App)Codec.DOUBLE.fieldOf("density_offset").forGetter(NoiseSettings::func_236177_h_), (App)Codec.BOOL.fieldOf("simplex_surface_noise").forGetter(NoiseSettings::func_236178_i_), (App)Codec.BOOL.optionalFieldOf("random_density_offset", (Object)Boolean.FALSE, Lifecycle.experimental()).forGetter(NoiseSettings::func_236179_j_), (App)Codec.BOOL.optionalFieldOf("island_noise_override", (Object)Boolean.FALSE, Lifecycle.experimental()).forGetter(NoiseSettings::func_236180_k_), (App)Codec.BOOL.optionalFieldOf("amplified", (Object)Boolean.FALSE, Lifecycle.experimental()).forGetter(NoiseSettings::func_236181_l_)).apply((Applicative)noiseSettingsInstance, NoiseSettings::new));
    public static final Codec<DimensionSettings> UAD_DIMENSION_SETTINGS_CODEC = RecordCodecBuilder.create(dimensionSettingsInstance -> dimensionSettingsInstance.group((App)DimensionStructuresSettings.field_236190_a_.fieldOf("structures").forGetter(DimensionSettings::func_236108_a_), (App)UAD_NOISE_SETTINGS_CODEC.fieldOf("noise").forGetter(DimensionSettings::func_236113_b_), (App)BlockState.field_235877_b_.fieldOf("default_block").forGetter(DimensionSettings::func_236115_c_), (App)BlockState.field_235877_b_.fieldOf("default_fluid").forGetter(DimensionSettings::func_236116_d_), (App)Codec.INT.fieldOf("bedrock_roof_position").forGetter(DimensionSettings::func_236117_e_), (App)Codec.INT.fieldOf("bedrock_floor_position").forGetter(DimensionSettings::func_236118_f_), (App)Codec.INT.fieldOf("sea_level").forGetter(DimensionSettings::func_236119_g_), (App)Codec.BOOL.fieldOf("disable_mob_generation").forGetter(dimensionSettings -> ((DimensionSettingsInvoker)dimensionSettings).uad_invokefunc_236120_h_())).apply((Applicative)dimensionSettingsInstance, DimensionSettingsInvoker::uad_invokeinit));
    public static final Codec<NoiseChunkGenerator> UAD_CHUNK_GENERATOR_CODEC = RecordCodecBuilder.create(noiseChunkGeneratorInstance -> noiseChunkGeneratorInstance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(noiseChunkGenerator -> ((ChunkGeneratorAccessor)noiseChunkGenerator).uad_getbiomeProvider()), (App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).forGetter(noiseChunkGenerator -> ((NoiseChunkGeneratorAccessor)noiseChunkGenerator).uad_getfield_236084_w_()), (App)UAD_DIMENSION_SETTINGS_CODEC.fieldOf("settings").forGetter(noiseChunkGenerator -> ((NoiseChunkGeneratorAccessor)noiseChunkGenerator).uad_getfield_236080_h_().get())).apply((Applicative)noiseChunkGeneratorInstance, noiseChunkGeneratorInstance.stable(UADChunkGenerator::new)));
    private final int sealevel;
    protected long seed;
    protected List<Structure<?>> landTerraformingStructures;
    private static final Long2ReferenceOpenHashMap<Biome> CACHED_BIOMES = new Long2ReferenceOpenHashMap();

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return UAD_CHUNK_GENERATOR_CODEC;
    }

    public ChunkGenerator func_230349_a_(long seed) {
        return new UADChunkGenerator(this.field_222542_c.func_230320_a_(seed), seed, (DimensionSettings)this.field_236080_h_.get());
    }

    public UADChunkGenerator(BiomeProvider biomeProvider, long seed, DimensionSettings dimensionSettings) {
        super(biomeProvider, seed, () -> dimensionSettings);
        this.sealevel = ((DimensionSettings)this.field_236080_h_.get()).func_236119_g_();
        this.landTerraformingStructures = new ArrayList(Structure.field_236384_t_);
        this.landTerraformingStructures.add(Structure.field_236376_l_);
    }

    private void fillNoiseColumn(double[] noiseColumn, int noiseX, int noiseZ) {
        NoiseSettings noisesettings = ((DimensionSettings)this.field_236080_h_.get()).func_236113_b_();
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        for (int k = -2; k <= 2; ++k) {
            for (int l = -2; l <= 2; ++l) {
                float depthWeight = 0.0f;
                float scaleWeight = 0.0f;
                depthWeight = 1.8f;
                scaleWeight = 4.6000004f;
                float f9 = BIOME_WEIGHTING_KERNEL[k + 2 + (l + 2) * 5] / (depthWeight + 2.0f);
                f += scaleWeight * f9;
                f1 += depthWeight * f9;
                f2 += f9;
            }
        }
        float f10 = f1 / f2;
        float f11 = f / f2;
        double d16 = f10 * 0.5f - 0.125f;
        double d18 = f11 * 0.9f + 0.1f;
        double d0 = d16 * 0.265625;
        double d1 = 96.0 / d18;
        double d12 = 684.412 * noisesettings.func_236171_b_().func_236151_a_();
        double d13 = 684.412 * noisesettings.func_236171_b_().func_236153_b_();
        double d14 = d12 / noisesettings.func_236171_b_().func_236154_c_();
        double d15 = d13 / noisesettings.func_236171_b_().func_236155_d_();
        double d17 = noisesettings.func_236172_c_().func_236186_a_();
        double d19 = noisesettings.func_236172_c_().func_236188_b_();
        double d20 = noisesettings.func_236172_c_().func_236189_c_();
        double d21 = noisesettings.func_236173_d_().func_236186_a_();
        double d2 = noisesettings.func_236173_d_().func_236188_b_();
        double d3 = noisesettings.func_236173_d_().func_236189_c_();
        double d4 = noisesettings.func_236179_j_() ? this.func_236095_c_(noiseX, noiseZ) : 0.0;
        double d5 = noisesettings.func_236176_g_();
        double d6 = noisesettings.func_236177_h_();
        for (int i1 = 0; i1 <= ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY(); ++i1) {
            double d7 = this.func_222552_a(noiseX, i1, noiseZ, d12, d13, d14, d15);
            double d8 = 1.0 - (double)i1 * 2.0 / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() + d4;
            double d9 = d8 * d5 + d6;
            double d10 = (d9 + d0) * d1;
            d7 = d10 > 0.0 ? (d7 += d10 * 4.0) : (d7 += d10);
            if (d19 > 0.0) {
                double d11 = ((double)(((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() - i1) - d20) / d19;
                d7 = MathHelper.func_151238_b((double)d17, (double)d7, (double)d11);
            }
            if (d2 > 0.0) {
                double d22 = ((double)i1 - d3) / d2;
                d7 = MathHelper.func_151238_b((double)d21, (double)d7, (double)d22);
            }
            noiseColumn[i1] = d7;
        }
    }

    private double func_222552_a(int x, int y, int z, double horizontalScale, double verticalScale, double horizontalStretch, double verticalStretch) {
        double frequency = 1.0;
        double interpolationValue = 0.0;
        for (int octave = 0; octave < 8; ++octave) {
            double scaledVerticalScale = verticalStretch * frequency;
            double scaledY = (double)y * scaledVerticalScale;
            interpolationValue += UADChunkGenerator.sampleOctave(((NoiseChunkGeneratorAccessor)((Object)this)).uad_getField_222570_q().func_215463_a(octave), OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalStretch * frequency)), OctavesNoiseGenerator.func_215461_a((double)scaledY), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalStretch * frequency)), scaledVerticalScale, scaledY, frequency);
            frequency /= 2.0;
        }
        double clampedInterpolation = (interpolationValue / 10.0 + 1.0) / 2.0;
        if (clampedInterpolation >= 1.0) {
            frequency = 1.0;
            double noise = 0.0;
            for (int octave = 0; octave < 16; ++octave) {
                double scaledVerticalScale = verticalScale * frequency;
                double scaledY = (double)y * scaledVerticalScale;
                noise += UADChunkGenerator.sampleOctave(((NoiseChunkGeneratorAccessor)((Object)this)).uad_getField_222569_p().func_215463_a(octave), OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * frequency)), OctavesNoiseGenerator.func_215461_a((double)scaledY), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * frequency)), scaledVerticalScale, scaledY, frequency);
                frequency /= 2.0;
            }
            return noise / 512.0;
        }
        if (clampedInterpolation <= 0.0) {
            frequency = 1.0;
            double noise = 0.0;
            for (int octave = 0; octave < 16; ++octave) {
                double scaledVerticalScale = verticalScale * frequency;
                double scaledY = (double)y * scaledVerticalScale;
                noise += UADChunkGenerator.sampleOctave(((NoiseChunkGeneratorAccessor)((Object)this)).uad_getField_222568_o().func_215463_a(octave), OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * frequency)), OctavesNoiseGenerator.func_215461_a((double)scaledY), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * frequency)), scaledVerticalScale, scaledY, frequency);
                frequency /= 2.0;
            }
            return noise / 512.0;
        }
        frequency = 1.0;
        double lowerNoise = 0.0;
        double upperNoise = 0.0;
        for (int octave = 0; octave < 16; ++octave) {
            double scaledVerticalScale = verticalScale * frequency;
            double scaledY = (double)y * scaledVerticalScale;
            double xVal = OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * frequency));
            double yVal = OctavesNoiseGenerator.func_215461_a((double)scaledY);
            double zVal = OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * frequency));
            upperNoise += UADChunkGenerator.sampleOctave(((NoiseChunkGeneratorAccessor)((Object)this)).uad_getField_222569_p().func_215463_a(octave), xVal, yVal, zVal, scaledVerticalScale, scaledY, frequency);
            lowerNoise += UADChunkGenerator.sampleOctave(((NoiseChunkGeneratorAccessor)((Object)this)).uad_getField_222568_o().func_215463_a(octave), xVal, yVal, zVal, scaledVerticalScale, scaledY, frequency);
            frequency /= 2.0;
        }
        return MathHelper.func_219803_d((double)clampedInterpolation, (double)(lowerNoise / 512.0), (double)(upperNoise / 512.0));
    }

    private static double sampleOctave(ImprovedNoiseGenerator sampler, double x, double y, double z, double scaledVerticalScale, double scaledY, double frequency) {
        return sampler.func_215456_a(x, y, z, scaledVerticalScale, scaledY) / frequency;
    }

    private double[] func_222547_b(int p_222547_1_, int p_222547_2_) {
        double[] adouble = new double[((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() + 1];
        this.fillNoiseColumn(adouble, p_222547_1_, p_222547_2_);
        return adouble;
    }

    private double func_236095_c_(int x, int z) {
        double d2;
        double d0 = ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getField_236082_u_().func_215462_a((double)(x * 200), 10.0, (double)(z * 200), 1.0, 0.0, true);
        if (d0 < 0.0) {
            d0 *= 3.0;
        }
        return (d2 = d0 * 24.575625 - 2.0) < 0.0 ? d2 * 0.009486607142857142 : Math.min(d2, 1.0) * 0.006640625;
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return this.func_236087_a_(x, z, null, heightmapType.func_222684_d());
    }

    public IBlockReader func_230348_a_(int x, int z) {
        BlockState[] ablockstate = new BlockState[((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity()];
        this.func_236087_a_(x, z, ablockstate, null);
        return new Blockreader(ablockstate);
    }

    private int func_236087_a_(int x, int z, @Nullable BlockState[] p_236087_3_, @Nullable Predicate<BlockState> p_236087_4_) {
        int i = Math.floorDiv(x, ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity());
        int j = Math.floorDiv(z, ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity());
        int k = Math.floorMod(x, ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity());
        int l = Math.floorMod(z, ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity());
        double d0 = (double)k / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity();
        double d1 = (double)l / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity();
        double[][] adouble = new double[][]{this.func_222547_b(i, j), this.func_222547_b(i, j + 1), this.func_222547_b(i + 1, j), this.func_222547_b(i + 1, j + 1)};
        Biome biome = this.getCachedBiome(null, new BlockPos(x, 0, z));
        for (int ySection = ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() - 1; ySection >= 0; --ySection) {
            double d2 = adouble[0][ySection];
            double d3 = adouble[1][ySection];
            double d4 = adouble[2][ySection];
            double d5 = adouble[3][ySection];
            double d6 = adouble[0][ySection + 1];
            double d7 = adouble[1][ySection + 1];
            double d8 = adouble[2][ySection + 1];
            double d9 = adouble[3][ySection + 1];
            for (int j1 = ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity() - 1; j1 >= 0; --j1) {
                double d10 = (double)j1 / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity();
                double noiseValue = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int y = ySection * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity() + j1;
                BlockState blockstate = this.getTerrainBlock(null, noiseValue, biome, x, y, z);
                if (p_236087_3_ != null) {
                    p_236087_3_[y] = blockstate;
                }
                if (p_236087_4_ == null || !p_236087_4_.test(blockstate)) continue;
                return y + 1;
            }
        }
        return 0;
    }

    public void func_230352_b_(IWorld world, StructureManager structureManager, IChunk chunk) {
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunk.func_76632_l();
        int xChunkPos = chunkpos.field_77276_a;
        int zChunkPos = chunkpos.field_77275_b;
        int xPos = xChunkPos << 4;
        int zPos = zChunkPos << 4;
        for (Structure<?> structure : this.landTerraformingStructures) {
            structureManager.func_235011_a_(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)0), structure).forEach(arg_0 -> UADChunkGenerator.lambda$func_230352_b_$12(chunkpos, (ObjectList)objectlist, xPos, zPos, (ObjectList)objectlist1, arg_0));
        }
        double[][][] adouble = new double[2][((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeZ() + 1][((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() + 1];
        for (int i5 = 0; i5 < ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeZ() + 1; ++i5) {
            adouble[0][i5] = new double[((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() + 1];
            this.fillNoiseColumn(adouble[0][i5], xChunkPos * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeX(), zChunkPos * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeZ() + i5);
            adouble[1][i5] = new double[((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunk;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        for (int xNoiseSize = 0; xNoiseSize < ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeX(); ++xNoiseSize) {
            for (int zNoiseSize = 0; zNoiseSize < ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeZ() + 1; ++zNoiseSize) {
                this.fillNoiseColumn(adouble[1][zNoiseSize], xChunkPos * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeX() + xNoiseSize + 1, zChunkPos * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeZ() + zNoiseSize);
            }
            for (int j5 = 0; j5 < ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeZ(); ++j5) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int k1 = ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getNoiseSizeY() - 1; k1 >= 0; --k1) {
                    double d0 = adouble[0][j5][k1];
                    double d1 = adouble[0][j5 + 1][k1];
                    double d2 = adouble[1][j5][k1];
                    double d3 = adouble[1][j5 + 1][k1];
                    double d4 = adouble[0][j5][k1 + 1];
                    double d5 = adouble[0][j5 + 1][k1 + 1];
                    double d6 = adouble[1][j5][k1 + 1];
                    double d7 = adouble[1][j5 + 1][k1 + 1];
                    for (int xSection = 0; xSection < ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity(); ++xSection) {
                        int x = xPos + xNoiseSize * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity() + xSection;
                        int xInChunk = x & 0xF;
                        double d13 = (double)xSection / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity();
                        for (int zSection = 0; zSection < ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity(); ++zSection) {
                            int z = zPos + j5 * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity() + zSection;
                            int zInChunk = z & 0xF;
                            double d16 = (double)zSection / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getHorizontalNoiseGranularity();
                            Biome biome = this.getCachedBiome(world, new BlockPos(x, 0, z));
                            for (int ySection = ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity() - 1; ySection >= 0; --ySection) {
                                int pieceZ;
                                int pieceY;
                                int pieceX;
                                int y = k1 * ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity() + ySection;
                                int yInChunk = y & 0xF;
                                int yChunk = y >> 4;
                                if (chunksection.func_222632_g() >> 4 != yChunk) {
                                    chunksection.func_222637_b();
                                    chunksection = chunkprimer.func_217332_a(yChunk);
                                    chunksection.func_222635_a();
                                }
                                double d8 = (double)ySection / (double)((NoiseChunkGeneratorAccessor)((Object)this)).uad_getVerticalNoiseGranularity();
                                double d9 = MathHelper.func_219803_d((double)d8, (double)d0, (double)d4);
                                double d10 = MathHelper.func_219803_d((double)d8, (double)d2, (double)d6);
                                double d11 = MathHelper.func_219803_d((double)d8, (double)d1, (double)d5);
                                double d12 = MathHelper.func_219803_d((double)d8, (double)d3, (double)d7);
                                double d14 = MathHelper.func_219803_d((double)d13, (double)d9, (double)d10);
                                double d15 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                                double d17 = MathHelper.func_219803_d((double)d16, (double)d14, (double)d15);
                                double noiseValue = MathHelper.func_151237_a((double)(d17 / 200.0), (double)-1.0, (double)1.0);
                                noiseValue = noiseValue / 2.0 - noiseValue * noiseValue * noiseValue / 24.0;
                                while (objectlistiterator.hasNext()) {
                                    StructurePiece structurepiece = (StructurePiece)objectlistiterator.next();
                                    MutableBoundingBox mutableboundingbox = structurepiece.func_74874_b();
                                    pieceX = Math.max(0, Math.max(mutableboundingbox.field_78897_a - x, x - mutableboundingbox.field_78893_d));
                                    pieceY = y - (mutableboundingbox.field_78895_b + (structurepiece instanceof AbstractVillagePiece ? ((AbstractVillagePiece)structurepiece).func_214830_d() : 0));
                                    pieceZ = Math.max(0, Math.max(mutableboundingbox.field_78896_c - z, z - mutableboundingbox.field_78892_f));
                                    if (structurepiece instanceof OceanMonumentPieces.Piece) {
                                        noiseValue += UADChunkGenerator.giantTerraformNoise(pieceX, pieceY -= 2, pieceZ) * 0.8;
                                        continue;
                                    }
                                    noiseValue += UADChunkGenerator.terraformNoise(pieceX, pieceY, pieceZ) * 0.8;
                                }
                                objectlistiterator.back(objectlist.size());
                                while (objectlistiterator1.hasNext()) {
                                    JigsawJunction jigsawjunction = (JigsawJunction)objectlistiterator1.next();
                                    pieceX = z - jigsawjunction.func_214895_a();
                                    pieceY = y - jigsawjunction.func_214896_b();
                                    pieceZ = z - jigsawjunction.func_214893_c();
                                    noiseValue += UADChunkGenerator.terraformNoise(pieceX, pieceY, pieceZ) * 0.4;
                                }
                                objectlistiterator1.back(objectlist1.size());
                                BlockState blockstate = this.getTerrainBlock(world, noiseValue, biome, x, y, z);
                                if (blockstate == Blocks.field_150350_a.func_176223_P()) continue;
                                blockpos$mutable.func_181079_c(x, y, z);
                                if (blockstate.getLightValue((IBlockReader)chunkprimer, (BlockPos)blockpos$mutable) != 0) {
                                    chunkprimer.func_201637_h((BlockPos)blockpos$mutable);
                                }
                                chunksection.func_177484_a(xInChunk, yInChunk, zInChunk, blockstate, false);
                                heightmap.func_202270_a(xInChunk, y, zInChunk, blockstate);
                                heightmap1.func_202270_a(xInChunk, y, zInChunk, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = adouble[0];
            adouble[0] = adouble[1];
            adouble[1] = adouble1;
        }
    }

    protected BlockState getTerrainBlock(IWorld world, double noiseValue, Biome biome, int x, int y, int z) {
        BlockState blockstate;
        if (noiseValue > 0.0) {
            blockstate = this.field_222559_f;
            if (biome.func_201856_r() == Biome.Category.NETHER) {
                blockstate = Blocks.field_150424_aL.func_176223_P();
            } else if (biome.func_201856_r() == Biome.Category.THEEND) {
                blockstate = Blocks.field_150377_bs.func_176223_P();
            }
        } else {
            BlockPos.Mutable mutable;
            blockstate = y < this.func_230356_f_() ? (biome.func_201856_r() == Biome.Category.NETHER ? (this.isSurroundedByNether(world, mutable = new BlockPos.Mutable(), x, z) ? (y > this.func_230356_f_() - 7 ? this.field_222560_g : (y == this.func_230356_f_() - 7 ? Blocks.field_196814_hQ.func_176223_P() : Blocks.field_150353_l.func_176223_P())) : (y <= this.func_230356_f_() - 6 ? Blocks.field_150343_Z.func_176223_P() : this.field_222560_g)) : this.field_222560_g) : Blocks.field_150350_a.func_176223_P();
        }
        return blockstate;
    }

    private boolean isSurroundedByNether(IWorld world, BlockPos.Mutable mutable, int x, int z) {
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                if (Math.abs(xOffset * zOffset) != 2 || this.getCachedBiome(world, (BlockPos)mutable.func_181079_c(x + xOffset, 0, z + zOffset)).func_201856_r() == Biome.Category.NETHER) continue;
                return false;
            }
        }
        return true;
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int x = chunkpos.field_77276_a;
        int z = chunkpos.field_77275_b;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202422_a(x, z);
        ChunkPos chunkpos1 = chunk.func_76632_l();
        int xStart = chunkpos1.func_180334_c();
        int zStart = chunkpos1.func_180333_d();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
            for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                int xPos = xStart + xInChunk;
                int zPos = zStart + zInChunk;
                int maxY = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, xInChunk, zInChunk) + 1;
                double noise = ((NoiseChunkGeneratorAccessor)((Object)this)).uad_getSurfaceDepthNoise().func_215460_a((double)xPos * 0.0625, (double)zPos * 0.0625, 0.0625, (double)xInChunk * 0.0625) * 15.0;
                Biome biome = this.getCachedBiome((IWorld)worldGenRegion, (BlockPos)blockpos$mutable.func_181079_c(xPos, 0, zPos));
                BlockState defaultBlockForSurface = Blocks.field_150348_b.func_176223_P();
                if (biome.func_201856_r() == Biome.Category.NETHER) {
                    defaultBlockForSurface = Blocks.field_150424_aL.func_176223_P();
                } else if (biome.func_201856_r() == Biome.Category.THEEND) {
                    defaultBlockForSurface = Blocks.field_150377_bs.func_176223_P();
                }
                biome.func_206854_a((Random)sharedseedrandom, chunk, xPos, zPos, maxY, noise, defaultBlockForSurface, this.field_222560_g, this.func_230356_f_(), worldGenRegion.func_72905_C());
            }
        }
        ((NoiseChunkGeneratorAccessor)((Object)this)).uad_callMakeBedrock(chunk, (Random)sharedseedrandom);
    }

    private static double terraformNoise(int x, int y, int z) {
        int xPos = x + 12;
        int yPos = y + 12;
        int zPos = z + 12;
        if (xPos >= 0 && xPos < 24) {
            if (yPos >= 0 && yPos < 24) {
                return zPos >= 0 && zPos < 24 ? (double)TERRAFORMING_NOISE_KERNAL[zPos * 24 * 24 + xPos * 24 + yPos] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double giantTerraformNoise(int x, int y, int z) {
        int xPos = x + 12;
        int zPos = z + 12;
        if (xPos >= 0 && xPos < 24) {
            if (y >= 0 && y < 24) {
                return zPos >= 0 && zPos < 24 ? (double)GIANT_TERRAFORMING_NOISE_KERNAL[zPos * 24 * 24 + xPos * 24 + y] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double getTerrainValue(int x, int y, int z) {
        double horizontalDist = x * x + z * z;
        double offsetY = (double)y + 0.5;
        double squaredOffsetY = offsetY * offsetY;
        double d3 = Math.pow(Math.E, -(squaredOffsetY / 16.0 + horizontalDist / 16.0));
        double d4 = -offsetY * MathHelper.func_181161_i((double)(squaredOffsetY / 2.0 + horizontalDist / 2.0)) / 2.0;
        return d4 * d3;
    }

    private static double getGiantTerrainValue(int x, int y, int z) {
        double horizontalDist = (double)(x * x + z * z) + 1.0E-4;
        double v = (double)(12 - Math.abs(y)) * 0.08;
        return -(MathHelper.func_181161_i((double)horizontalDist) * 1.1 - 1.0 + v);
    }

    public int func_230356_f_() {
        return this.sealevel;
    }

    public Biome getCachedBiome(IWorld world, BlockPos blockpos) {
        long posLong;
        Biome biome;
        if (CACHED_BIOMES.size() > 200) {
            CACHED_BIOMES.clear();
        }
        if ((biome = (Biome)CACHED_BIOMES.get(posLong = blockpos.func_218275_a())) == null) {
            biome = world != null ? world.func_226691_t_(blockpos) : FuzzedBiomeMagnifier.INSTANCE.func_225532_a_(this.seed, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), (BiomeManager.IBiomeReader)this.field_222542_c);
            CACHED_BIOMES.put(posLong, (Object)biome);
        }
        return biome;
    }

    private static /* synthetic */ void lambda$func_230352_b_$12(ChunkPos chunkpos, ObjectList objectlist, int xPos, int zPos, ObjectList objectlist1, StructureStart p_236089_5_) {
        for (StructurePiece structurepiece1 : p_236089_5_.func_186161_c()) {
            if (!structurepiece1.func_214810_a(chunkpos, 12)) continue;
            if (structurepiece1 instanceof AbstractVillagePiece) {
                AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece1;
                JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                    objectlist.add((Object)abstractvillagepiece);
                }
                for (JigsawJunction jigsawjunction1 : abstractvillagepiece.func_214829_e()) {
                    int xSource = jigsawjunction1.func_214895_a();
                    int zSource = jigsawjunction1.func_214893_c();
                    if (xSource <= xPos - 12 || zSource <= zPos - 12 || xSource >= xPos + 15 + 12 || zSource >= zPos + 15 + 12) continue;
                    objectlist1.add((Object)jigsawjunction1);
                }
                continue;
            }
            objectlist.add((Object)structurepiece1);
        }
    }
}

