/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.BiomeGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;
import org.apache.commons.lang3.tuple.MutablePair;

public class RegionManager {
    public static final Codec<RegionManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeGroup.CODEC.listOf().fieldOf("ocean_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.oceanList), (App)BiomeGroup.CODEC.listOf().fieldOf("end_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.endList), (App)BiomeGroup.CODEC.listOf().fieldOf("nether_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.netherList), (App)BiomeGroup.CODEC.listOf().fieldOf("hot_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.hotList), (App)BiomeGroup.CODEC.listOf().fieldOf("warm_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.warmList), (App)BiomeGroup.CODEC.listOf().fieldOf("cool_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.coolList), (App)BiomeGroup.CODEC.listOf().fieldOf("icy_biomes").xmap(biomeGroupList -> new MutablePair(biomeGroupList, (Object)biomeGroupList.stream().mapToInt(BiomeGroup::getWeight).sum()), MutablePair::getLeft).forGetter(regionManager -> regionManager.icyList)).apply((Applicative)instance, RegionManager::new));
    private MutablePair<List<BiomeGroup>, Integer> oceanList;
    private MutablePair<List<BiomeGroup>, Integer> endList;
    private MutablePair<List<BiomeGroup>, Integer> netherList;
    private MutablePair<List<BiomeGroup>, Integer> hotList;
    private MutablePair<List<BiomeGroup>, Integer> warmList;
    private MutablePair<List<BiomeGroup>, Integer> coolList;
    private MutablePair<List<BiomeGroup>, Integer> icyList;
    private final Map<Biome, Biome> subBiomeMap = new HashMap<Biome, Biome>();
    private final Map<Biome, Biome> shoreMap = new HashMap<Biome, Biome>();
    private final Map<Biome, Biome> borderMap = new HashMap<Biome, Biome>();
    private final Map<Biome, Biome> mutatedMap = new HashMap<Biome, Biome>();
    private final Map<Biome, Biome> mutatedSubBiomeMap = new HashMap<Biome, Biome>();
    private final Map<Biome, Biome> mutatedBorderBiomeMap = new HashMap<Biome, Biome>();

    RegionManager(MutablePair<List<BiomeGroup>, Integer> oceanList, MutablePair<List<BiomeGroup>, Integer> endList, MutablePair<List<BiomeGroup>, Integer> netherList, MutablePair<List<BiomeGroup>, Integer> hotList, MutablePair<List<BiomeGroup>, Integer> warmList, MutablePair<List<BiomeGroup>, Integer> coolList, MutablePair<List<BiomeGroup>, Integer> icyList) {
        this.oceanList = this.prepareListAndPopulateBiomeRelationMaps(oceanList);
        this.endList = this.prepareListAndPopulateBiomeRelationMaps(endList);
        this.netherList = this.prepareListAndPopulateBiomeRelationMaps(netherList);
        this.hotList = this.prepareListAndPopulateBiomeRelationMaps(hotList);
        this.warmList = this.prepareListAndPopulateBiomeRelationMaps(warmList);
        this.coolList = this.prepareListAndPopulateBiomeRelationMaps(coolList);
        this.icyList = this.prepareListAndPopulateBiomeRelationMaps(icyList);
    }

    private MutablePair<List<BiomeGroup>, Integer> prepareListAndPopulateBiomeRelationMaps(MutablePair<List<BiomeGroup>, Integer> regionGroup) {
        MutablePair nonImmutableListPair = new MutablePair(new ArrayList((Collection)regionGroup.getLeft()), regionGroup.getRight());
        if (((List)regionGroup.getLeft()).size() == 0) {
            throw new JsonSyntaxException("Empty RegionGroup found in Ultra Amplified Dimension's dimension json. Please make sure every temperature category as at least 1 biome.");
        }
        ((List)nonImmutableListPair.getLeft()).sort(BiomeGroup::compareTo);
        for (BiomeGroup group : (List)nonImmutableListPair.getLeft()) {
            Biome mainBiome = group.getMainBiome().get();
            group.getShoreBiome().ifPresent(shore -> this.checkBeforeAddingBiome(this.shoreMap, mainBiome, (Biome)shore.get()));
            group.getBorderBiome().ifPresent(border -> this.checkBeforeAddingBiome(this.borderMap, mainBiome, (Biome)border.get()));
            group.getSubBiome().ifPresent(sub -> this.checkBeforeAddingBiome(this.subBiomeMap, mainBiome, (Biome)sub.get()));
            group.getMutatedBiome().ifPresent(mutated -> this.checkBeforeAddingBiome(this.mutatedMap, mainBiome, (Biome)mutated.get()));
            group.getMutatedSubBiome().ifPresent(mutatedSub -> this.checkBeforeAddingBiome(this.mutatedSubBiomeMap, mainBiome, (Biome)mutatedSub.get()));
            group.getMutatedBorderBiome().ifPresent(mutatedBorder -> this.checkBeforeAddingBiome(this.mutatedBorderBiomeMap, mainBiome, (Biome)mutatedBorder.get()));
        }
        return nonImmutableListPair;
    }

    private void checkBeforeAddingBiome(Map<Biome, Biome> biomeMap, Biome biomeKey, Biome biomeToAdd) {
        if (biomeMap.containsKey(biomeKey)) {
            if (biomeMap.get(biomeKey) != biomeToAdd) {
                throw new JsonSyntaxException("A single biome was found multiple times in the \"main_biome\" entry with different border/sub/mutated biomes for it in Ultra Amplified Dimension's dimension json. Please make sure every entry with the same \"main_biome\" also have the same alternative biomes (This is due to how biome layers are done and they cannot handle 1 main biome having multiple kinds of sub biomes and stuff.)");
            }
        } else {
            biomeMap.put(biomeKey, biomeToAdd);
        }
    }

    public BiomeGroup getRandomBiomeGroup(MutablePair<List<BiomeGroup>, Integer> regionGroup, INoiseRandom context) {
        int index;
        double randomWeightPicked = context.func_202696_a(((Integer)regionGroup.getRight()).intValue());
        for (index = 0; index < ((List)regionGroup.getLeft()).size() - 1 && !((randomWeightPicked -= (double)((BiomeGroup)((List)regionGroup.getLeft()).get(index)).getWeight()) <= 0.0); ++index) {
        }
        return (BiomeGroup)((List)regionGroup.getLeft()).get(index);
    }

    public BiomeGroup getWeightedBiomeGroupByTemperature(MutablePair<List<BiomeGroup>, Integer> regionGroup, double threshold) {
        int index;
        double clampedThreshold = Math.min(Math.max(threshold, 0.0), 0.999999999);
        double thresholdWeight = clampedThreshold * (double)((Integer)regionGroup.getRight()).intValue();
        for (index = 0; index < ((List)regionGroup.getLeft()).size() - 1 && !((thresholdWeight -= (double)((BiomeGroup)((List)regionGroup.getLeft()).get(index)).getWeight()) <= 0.0); ++index) {
        }
        return (BiomeGroup)((List)regionGroup.getLeft()).get(index);
    }

    public Supplier<Biome> getHottestBiomeOfList(List<BiomeGroup> regionGroup) {
        return regionGroup.get(0).getMainBiome();
    }

    public Supplier<Biome> getColdestBiomeOfList(List<BiomeGroup> regionGroup) {
        return regionGroup.get(regionGroup.size() - 1).getMainBiome();
    }

    public MutablePair<List<BiomeGroup>, Integer> getOceanList() {
        return this.oceanList;
    }

    public MutablePair<List<BiomeGroup>, Integer> getEndList() {
        return this.endList;
    }

    public MutablePair<List<BiomeGroup>, Integer> getNetherList() {
        return this.netherList;
    }

    public MutablePair<List<BiomeGroup>, Integer> getHotList() {
        return this.hotList;
    }

    public MutablePair<List<BiomeGroup>, Integer> getWarmRegion() {
        return this.warmList;
    }

    public MutablePair<List<BiomeGroup>, Integer> getCoolList() {
        return this.coolList;
    }

    public MutablePair<List<BiomeGroup>, Integer> getIcyList() {
        return this.icyList;
    }

    public Biome getSubBiome(Biome biome) {
        return this.subBiomeMap.get(biome);
    }

    public Biome getShore(Biome biome) {
        return this.shoreMap.get(biome);
    }

    public Biome getBorder(Biome biome) {
        return this.borderMap.get(biome);
    }

    public Biome getMutated(Biome biome) {
        return this.mutatedMap.get(biome);
    }

    public Biome getMutatedSubBiome(Biome biome) {
        return this.mutatedSubBiomeMap.get(biome);
    }

    public Biome getMutatedBorderBiome(Biome biome) {
        return this.mutatedBorderBiomeMap.get(biome);
    }

    public List<Biome> importAllModdedBiomes(Registry<Biome> biomeRegistry, HashSet<ResourceLocation> blacklistedModdedBiomes) {
        ArrayList<Biome> addedBiomes = new ArrayList<Biome>();
        for (Map.Entry entry : biomeRegistry.func_239659_c_()) {
            if (((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("minecraft") || ((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("ultra_amplified_dimension") || blacklistedModdedBiomes.contains(((RegistryKey)entry.getKey()).func_240901_a_())) continue;
            int biomeWeight = 6;
            Biome.Category biomeCategory = ((Biome)entry.getValue()).func_201856_r();
            float temperature = ((Biome)entry.getValue()).func_242445_k();
            if (biomeCategory.equals((Object)Biome.Category.NETHER)) {
                this.addBiomeToList(entry, biomeWeight, this.netherList);
            } else if (biomeCategory.equals((Object)Biome.Category.THEEND) || biomeCategory.equals((Object)Biome.Category.NONE)) {
                this.addBiomeToList(entry, biomeWeight, this.endList);
            } else if (biomeCategory.equals((Object)Biome.Category.OCEAN)) {
                this.addBiomeToList(entry, biomeWeight, this.oceanList);
            } else if ((double)temperature > 1.0) {
                this.addBiomeToList(entry, biomeWeight, this.hotList);
            } else if ((double)temperature <= 0.0) {
                this.addBiomeToList(entry, biomeWeight, this.coolList);
            } else if ((double)temperature < 0.4) {
                this.addBiomeToList(entry, biomeWeight, this.coolList);
            } else {
                this.addBiomeToList(entry, biomeWeight, this.warmList);
            }
            addedBiomes.add((Biome)entry.getValue());
        }
        return addedBiomes;
    }

    private void addBiomeToList(Map.Entry<RegistryKey<Biome>, Biome> entry, int biomeWeight, MutablePair<List<BiomeGroup>, Integer> netherList) {
        ((List)netherList.getLeft()).add(new BiomeGroup(entry::getValue, biomeWeight));
        MutablePair<List<BiomeGroup>, Integer> mutablePair = netherList;
        mutablePair.right = (Integer)mutablePair.right + 6;
    }
}

