/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.RegionManager;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.BaseRegionLayer;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.MainBiomeLayer;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.OceanBaseRegionLayer;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.ReduceOceanNoiseAndMagnifyEndNetherLayer;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.ShoreEdgeHillsAndMutatationsBiomeLayer;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.LayerAccessor;
import com.telepathicgrunt.ultraamplifieddimension.utils.WorldSeedHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;

public class UADBiomeProvider
extends BiomeProvider {
    public static final Codec<UADBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).forGetter(biomeSource -> biomeSource.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(biomeSource -> biomeSource.dynamicRegistry), (App)Codec.intRange((int)1, (int)20).fieldOf("biome_size").forGetter(biomeSource -> biomeSource.biomeSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("sub_biome_rate").forGetter(biomeSource -> Float.valueOf(biomeSource.subBiomeRate)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mutated_biome_rate").forGetter(biomeSource -> Float.valueOf(biomeSource.mutatedBiomeRate)), (App)RegionManager.CODEC.fieldOf("regions").forGetter(biomeSource -> biomeSource.regionManager), (App)Codec.BOOL.fieldOf("import_all_modded_biomes").orElse((Object)false).forGetter(biomeSource -> biomeSource.automaticallyImportModdedBiomes), (App)ResourceLocation.field_240908_a_.listOf().xmap(Sets::newHashSet, Lists::newArrayList).fieldOf("imported_biome_blacklist").orElse(new HashSet()).forGetter(biomeSource -> biomeSource.blacklistedModdedBiomes)).apply((Applicative)instance, instance.stable(UADBiomeProvider::new)));
    private final Registry<Biome> dynamicRegistry;
    private final RegionManager regionManager;
    private final Layer biomeSampler;
    private final int biomeSize;
    private final float subBiomeRate;
    private final float mutatedBiomeRate;
    private final long seed;
    private final Set<Integer> printedMissingBiomes = new HashSet<Integer>();
    private final boolean automaticallyImportModdedBiomes;
    private final HashSet<ResourceLocation> blacklistedModdedBiomes;

    public UADBiomeProvider(long seed, Registry<Biome> biomeRegistry, int biomeSize, float subBiomeRate, float mutatedBiomeRate, RegionManager regionManager, boolean automaticallyImportModdedBiomes, HashSet<ResourceLocation> blacklistedModdedBiomes) {
        super(Stream.concat(biomeRegistry.func_239659_c_().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("ultra_amplified_dimension")).map(Map.Entry::getValue), UADBiomeProvider.getAllModdedBiomes(biomeRegistry, regionManager, automaticallyImportModdedBiomes, blacklistedModdedBiomes)).collect(Collectors.toList()));
        this.seed = seed;
        this.biomeSize = biomeSize;
        this.subBiomeRate = subBiomeRate;
        this.mutatedBiomeRate = mutatedBiomeRate;
        this.regionManager = regionManager;
        this.dynamicRegistry = biomeRegistry;
        this.automaticallyImportModdedBiomes = automaticallyImportModdedBiomes;
        this.blacklistedModdedBiomes = blacklistedModdedBiomes;
        if (automaticallyImportModdedBiomes) {
            this.regionManager.importAllModdedBiomes(this.dynamicRegistry, this.blacklistedModdedBiomes);
        }
        this.biomeSampler = new Layer(this.build(salt -> new LazyAreaLayerContext(25, this.seed, salt)));
        this.printedMissingBiomes.clear();
    }

    private static Stream<Biome> getAllModdedBiomes(Registry<Biome> biomeRegistry, RegionManager regionManager, boolean automaticallyImportModdedBiomes, HashSet<ResourceLocation> blacklistedModdedBiomes) {
        if (automaticallyImportModdedBiomes) {
            return regionManager.importAllModdedBiomes(biomeRegistry, blacklistedModdedBiomes).stream();
        }
        return Collections.EMPTY_LIST.stream();
    }

    public <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> build(LongFunction<C> contextFactory) {
        IAreaFactory layer = new BaseRegionLayer().func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        layer = new OceanBaseRegionLayer().func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3459L), layer);
        layer = new ReduceOceanNoiseAndMagnifyEndNetherLayer().func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2324L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2402L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(6203L), layer);
        layer = new MainBiomeLayer(this.dynamicRegistry, this.regionManager).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1567L), layer);
        for (int currentExtraZoom = 0; currentExtraZoom < this.biomeSize; ++currentExtraZoom) {
            layer = currentExtraZoom % 3 != 0 ? ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1503L + (long)currentExtraZoom), layer) : ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1111L + (long)(currentExtraZoom * 31)), layer);
            if (currentExtraZoom != 1 && this.biomeSize != 1) continue;
            layer = new ShoreEdgeHillsAndMutatationsBiomeLayer(this.dynamicRegistry, this.regionManager, this.subBiomeRate, this.mutatedBiomeRate, this.biomeSize).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3235L), layer);
        }
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(8204L), layer);
        return layer;
    }

    @Nonnull
    public Biome func_225526_b_(int x, int y, int z) {
        int biomeID = ((LayerAccessor)this.biomeSampler).uad_getSampler().func_202678_a(x, z);
        Biome biome = (Biome)this.dynamicRegistry.func_148745_a(biomeID);
        if (biome == null) {
            Biome backupBiome;
            if (!this.printedMissingBiomes.contains(biomeID)) {
                this.printedMissingBiomes.add(biomeID);
                UltraAmplifiedDimension.LOGGER.error("Unknown biome id: " + biomeID + "   Now using non-dynamic registry for biomes which might be wrong! Let Ultra Amplified Dev know about your issue.");
            }
            if ((backupBiome = (Biome)this.dynamicRegistry.func_230516_a_(BiomeRegistry.func_244203_a((int)biomeID))) == null) {
                return (Biome)Objects.requireNonNull(WorldGenRegistries.field_243657_i.func_230516_a_(Biomes.field_185440_P));
            }
            return backupBiome;
        }
        return biome;
    }

    @Nonnull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @Nonnull
    public BiomeProvider func_230320_a_(long seed) {
        return new UADBiomeProvider(seed, this.dynamicRegistry, this.biomeSize, this.subBiomeRate, this.mutatedBiomeRate, this.regionManager, this.automaticallyImportModdedBiomes, this.blacklistedModdedBiomes);
    }

    public static enum REGIONS {
        END,
        NETHER,
        OCEAN,
        HOT,
        WARM,
        COOL,
        ICY;

    }
}

