/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer;

import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.BiomeGroup;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.RegionManager;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.UADBiomeProvider;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.transformers.CastleWithPositionTransformer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;

public class MainBiomeLayer
implements CastleWithPositionTransformer {
    private final Registry<Biome> dynamicRegistry;
    private final RegionManager regionManager;

    public MainBiomeLayer(Registry<Biome> dynamicRegistry, RegionManager regionManager) {
        this.dynamicRegistry = dynamicRegistry;
        this.regionManager = regionManager;
    }

    @Override
    public int apply(INoiseRandom context, int north, int west, int south, int east, int regionID, int x, int z) {
        BiomeGroup selectedBiomeGroup;
        if (regionID == UADBiomeProvider.REGIONS.END.ordinal()) {
            selectedBiomeGroup = this.regionManager.getRandomBiomeGroup(this.regionManager.getEndList(), context);
        } else if (regionID == UADBiomeProvider.REGIONS.NETHER.ordinal()) {
            selectedBiomeGroup = this.regionManager.getRandomBiomeGroup(this.regionManager.getNetherList(), context);
        } else if (regionID == UADBiomeProvider.REGIONS.HOT.ordinal()) {
            selectedBiomeGroup = this.regionManager.getRandomBiomeGroup(this.regionManager.getHotList(), context);
        } else if (regionID == UADBiomeProvider.REGIONS.WARM.ordinal()) {
            selectedBiomeGroup = this.regionManager.getRandomBiomeGroup(this.regionManager.getWarmRegion(), context);
        } else if (regionID == UADBiomeProvider.REGIONS.COOL.ordinal()) {
            selectedBiomeGroup = this.regionManager.getRandomBiomeGroup(this.regionManager.getCoolList(), context);
        } else if (regionID == UADBiomeProvider.REGIONS.ICY.ordinal()) {
            selectedBiomeGroup = this.regionManager.getRandomBiomeGroup(this.regionManager.getIcyList(), context);
        } else {
            double baseRegionNoiseCopy = context.func_205589_a().func_215456_a((double)x / 16.0, (double)z / 16.0, 0.0, 0.0, 0.0) * 0.7 + 0.55;
            selectedBiomeGroup = this.regionManager.getWeightedBiomeGroupByTemperature(this.regionManager.getOceanList(), baseRegionNoiseCopy);
        }
        return this.dynamicRegistry.func_148757_b((Object)selectedBiomeGroup.getMainBiome().get());
    }
}

