/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer;

import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.RegionManager;
import com.telepathicgrunt.ultraamplifieddimension.dimension.biomeprovider.layer.transformers.CastleWithPositionTransformer;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;

public class ShoreEdgeHillsAndMutatationsBiomeLayer
implements CastleWithPositionTransformer {
    private final Registry<Biome> dynamicRegistry;
    private final RegionManager regionManager;
    private final float subBiomeThreshold;
    private final float mutatedThreshold;
    private final float biomeSize;

    public ShoreEdgeHillsAndMutatationsBiomeLayer(Registry<Biome> dynamicRegistry, RegionManager regionManager, float subBiomeThreshold, float mutatedThreshold, int biomeSize) {
        this.dynamicRegistry = dynamicRegistry;
        this.regionManager = regionManager;
        this.subBiomeThreshold = subBiomeThreshold;
        this.mutatedThreshold = mutatedThreshold;
        this.biomeSize = biomeSize;
    }

    @Override
    public int apply(INoiseRandom context, int north, int west, int south, int east, int originalBiomeID, int x, int z) {
        Biome currentBiome = (Biome)this.dynamicRegistry.func_148745_a(originalBiomeID);
        Biome nbiome = (Biome)this.dynamicRegistry.func_148745_a(north);
        Biome wbiome = (Biome)this.dynamicRegistry.func_148745_a(west);
        Biome ebiome = (Biome)this.dynamicRegistry.func_148745_a(east);
        Biome sbiome = (Biome)this.dynamicRegistry.func_148745_a(south);
        Biome newBiome = null;
        if (currentBiome == null || nbiome == null || wbiome == null || ebiome == null || sbiome == null) {
            UltraAmplifiedDimension.LOGGER.error("Error: ShoreEdgeHillsAndMutationsBiomeLayer received an unknown biome ID it cannot work with | C:" + originalBiomeID + " N:" + nbiome + " E:" + ebiome + " S:" + sbiome + " W:" + wbiome);
            return originalBiomeID;
        }
        if (currentBiome.func_201856_r() == Biome.Category.OCEAN) {
            if (nbiome.func_201856_r() != Biome.Category.OCEAN || wbiome.func_201856_r() != Biome.Category.OCEAN || ebiome.func_201856_r() != Biome.Category.OCEAN || sbiome.func_201856_r() != Biome.Category.OCEAN) {
                newBiome = this.regionManager.getShore(currentBiome);
            }
        } else if (nbiome.func_201856_r() == Biome.Category.OCEAN || wbiome.func_201856_r() == Biome.Category.OCEAN || ebiome.func_201856_r() == Biome.Category.OCEAN || sbiome.func_201856_r() == Biome.Category.OCEAN) {
            newBiome = this.regionManager.getShore(currentBiome);
        }
        if (newBiome != null) {
            return this.dynamicRegistry.func_148757_b((Object)newBiome);
        }
        double subBiomeNoise = context.func_205589_a().func_215456_a((double)x / (double)this.biomeSize, (double)z / (double)this.biomeSize, 2314.0, 0.0, 0.0) * 0.5 + 0.5;
        double mutatedNoise = context.func_205589_a().func_215456_a((double)x / ((double)this.biomeSize + 3.0), (double)z / ((double)this.biomeSize + 3.0), 9001.0, 0.0, 0.0) * 0.5 + 0.5;
        if (nbiome.func_201856_r() != currentBiome.func_201856_r() || wbiome.func_201856_r() != currentBiome.func_201856_r() || ebiome.func_201856_r() != currentBiome.func_201856_r() || sbiome.func_201856_r() != currentBiome.func_201856_r()) {
            Biome mutatedBorderBiome;
            newBiome = this.regionManager.getBorder(currentBiome);
            if (mutatedNoise < (double)this.mutatedThreshold && (mutatedBorderBiome = this.regionManager.getMutatedBorderBiome(currentBiome)) != null) {
                return this.dynamicRegistry.func_148757_b((Object)mutatedBorderBiome);
            }
        } else if (subBiomeNoise < (double)this.subBiomeThreshold) {
            Biome mutatedSubBiome;
            newBiome = this.regionManager.getSubBiome(currentBiome);
            if (mutatedNoise < (double)this.mutatedThreshold && (mutatedSubBiome = this.regionManager.getMutatedSubBiome(currentBiome)) != null) {
                return this.dynamicRegistry.func_148757_b((Object)mutatedSubBiome);
            }
        } else if (mutatedNoise < (double)this.mutatedThreshold) {
            newBiome = this.regionManager.getMutated(currentBiome);
        }
        if (newBiome != null) {
            return this.dynamicRegistry.func_148757_b((Object)newBiome);
        }
        return originalBiomeID;
    }
}

