/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.decorators;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.world.decorators.LedgeSurfacePlacerConfig;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.WorldDecoratingHelper;
import net.minecraft.world.gen.placement.Placement;

public class LedgeSurfacePlacer
extends Placement<LedgeSurfacePlacerConfig> {
    public LedgeSurfacePlacer(Codec<LedgeSurfacePlacerConfig> codec) {
        super(codec);
    }

    @Nonnull
    public Stream<BlockPos> getPositions(WorldDecoratingHelper context, Random rand, LedgeSurfacePlacerConfig config, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int count = 0; count < config.columnCount; ++count) {
            int bottomYLimit;
            int x = rand.nextInt(16) + pos.func_177958_n();
            int z = rand.nextInt(16) + pos.func_177952_p();
            int heightMapY = context.func_242893_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
            mutable.func_181079_c(x, heightMapY, z);
            BlockState prevBlockState = context.func_242894_a(mutable.func_177984_a());
            int n = bottomYLimit = config.waterPosOnly ? 11 : context.func_242895_b();
            while (mutable.func_177956_o() >= bottomYLimit) {
                BlockState currentBlockState = context.func_242894_a((BlockPos)mutable);
                if (!currentBlockState.func_235714_a_((ITag)BlockTags.field_206952_E) && !currentBlockState.func_235714_a_((ITag)BlockTags.field_200031_h) && !currentBlockState.func_203425_a(Blocks.field_150357_h) && currentBlockState.func_185904_a() != Material.field_151570_A && (!config.undersideOnly && !LedgeSurfacePlacer.notSolidSpace(currentBlockState) && LedgeSurfacePlacer.notSolidSpace(prevBlockState) || config.undersideOnly && LedgeSurfacePlacer.notSolidSpace(currentBlockState) && !LedgeSurfacePlacer.notSolidSpace(prevBlockState))) {
                    boolean isValidWaterPos;
                    boolean skippedTopLedge = !config.undersideOnly && config.skipTopLedge && mutable.func_177956_o() == context.func_242893_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n(), mutable.func_177952_p()) - 1;
                    boolean bl = isValidWaterPos = config.undersideOnly ? currentBlockState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) : prevBlockState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
                    if ((config.waterPosOnly && isValidWaterPos || !config.waterPosOnly && !isValidWaterPos) && !skippedTopLedge) {
                        if (rand.nextFloat() < config.validSpotChance) {
                            list.add(mutable.func_185334_h());
                        }
                        mutable.func_181079_c(rand.nextInt(16) + pos.func_177958_n(), mutable.func_177956_o(), rand.nextInt(16) + pos.func_177952_p());
                    }
                }
                prevBlockState = currentBlockState;
                mutable.func_189536_c(Direction.DOWN);
            }
        }
        return list.stream();
    }

    private static boolean notSolidSpace(BlockState state) {
        return state.func_196958_f() || !state.func_204520_s().func_206888_e() && !state.func_200132_m();
    }
}

