/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.blocks.BigCactusBodyBlock;
import com.telepathicgrunt.ultraamplifieddimension.blocks.BigCactusCornerBlock;
import com.telepathicgrunt.ultraamplifieddimension.blocks.BigCactusMainBlock;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADBlocks;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.HeightConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class BigCactus
extends Feature<HeightConfig> {
    public BigCactus(Codec<HeightConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, HeightConfig betterCactusConfig) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockpos);
        Direction cactusFacing = Direction.func_176731_b((int)rand.nextInt(4));
        int maxHeight = betterCactusConfig.height + rand.nextInt(2);
        int frontSideHeight = 2 + rand.nextInt(maxHeight - 4);
        int backSideHeight = 2 + rand.nextInt(maxHeight - 4);
        while (blockpos.func_177956_o() <= position.func_177956_o() + betterCactusConfig.height + 1) {
            if (!(cachedChunk.func_180495_p((BlockPos)blockpos).func_196958_f() && (blockpos.func_177956_o() < position.func_177956_o() + frontSideHeight || cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(cactusFacing)).func_196958_f() && cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(cactusFacing)).func_196958_f()) && (blockpos.func_177956_o() < position.func_177956_o() + backSideHeight || cachedChunk.func_180495_p((BlockPos)blockpos.func_189534_c(cactusFacing.func_176734_d(), 3)).func_196958_f() && cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(cactusFacing.func_176734_d())).func_196958_f()))) {
                return false;
            }
            blockpos.func_189536_c(Direction.UP).func_189534_c(cactusFacing, 2);
        }
        blockpos.func_189533_g((Vector3i)position);
        if (cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(Direction.DOWN)).func_235714_a_((ITag)BlockTags.field_203436_u)) {
            blockpos.func_189536_c(Direction.UP);
            for (int currentHeight = 0; currentHeight < maxHeight && cachedChunk.func_180495_p((BlockPos)blockpos).func_196958_f(); ++currentHeight) {
                if (blockpos.func_177956_o() <= 254 && (currentHeight == frontSideHeight || currentHeight == backSideHeight)) {
                    if (frontSideHeight == backSideHeight) {
                        cachedChunk.func_177436_a((BlockPos)blockpos, (BlockState)((Block)UADBlocks.BIG_CACTUS_BODY_BLOCK.get()).func_176223_P().func_206870_a((Property)BigCactusBodyBlock.FACING, (Comparable)cactusFacing), false);
                    } else {
                        cachedChunk.func_177436_a((BlockPos)blockpos, (BlockState)((Block)UADBlocks.BIG_CACTUS_CORNER_BLOCK.get()).func_176223_P().func_206870_a((Property)BigCactusCornerBlock.FACING, (Comparable)(currentHeight == frontSideHeight ? cactusFacing.func_176734_d() : cactusFacing)), false);
                    }
                    if (currentHeight == frontSideHeight) {
                        this.createBranch(world, chunkGenerator, (BlockPos)blockpos, cactusFacing, rand.nextInt(maxHeight - frontSideHeight - 2) + 2);
                    }
                    if (currentHeight == backSideHeight) {
                        this.createBranch(world, chunkGenerator, (BlockPos)blockpos, cactusFacing.func_176734_d(), rand.nextInt(maxHeight - backSideHeight - 2) + 2);
                    }
                } else {
                    cachedChunk.func_177436_a((BlockPos)blockpos, (BlockState)((Block)UADBlocks.BIG_CACTUS_MAIN_BLOCK.get()).func_176223_P().func_206870_a((Property)BigCactusMainBlock.FACING, (Comparable)Direction.UP), false);
                }
                blockpos.func_189536_c(Direction.UP);
            }
        }
        return true;
    }

    private void createBranch(ISeedReader world, ChunkGenerator chunkGenerator, BlockPos position, Direction branchDirection, int maxHeightUp) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)position).func_189536_c(branchDirection);
        if (!world.func_175623_d((BlockPos)blockpos)) {
            return;
        }
        world.func_180501_a((BlockPos)blockpos, (BlockState)((Block)UADBlocks.BIG_CACTUS_MAIN_BLOCK.get()).func_176223_P().func_206870_a((Property)BigCactusMainBlock.FACING, (Comparable)branchDirection), 3);
        blockpos.func_189536_c(branchDirection);
        if (!world.func_175623_d((BlockPos)blockpos)) {
            return;
        }
        world.func_180501_a((BlockPos)blockpos, (BlockState)((Block)UADBlocks.BIG_CACTUS_CORNER_BLOCK.get()).func_176223_P().func_206870_a((Property)BigCactusCornerBlock.FACING, (Comparable)branchDirection), 3);
        blockpos.func_189536_c(Direction.UP);
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockpos);
        for (int currentHeight = 1; currentHeight < maxHeightUp && blockpos.func_177956_o() <= chunkGenerator.func_230355_e_(); ++currentHeight) {
            if (!cachedChunk.func_180495_p((BlockPos)blockpos).func_196958_f()) {
                return;
            }
            cachedChunk.func_177436_a((BlockPos)blockpos, (BlockState)((Block)UADBlocks.BIG_CACTUS_MAIN_BLOCK.get()).func_176223_P().func_206870_a((Property)BigCactusMainBlock.FACING, (Comparable)Direction.UP), false);
            blockpos.func_189536_c(Direction.UP);
        }
    }
}

