/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.mixin.dimension.NoiseChunkGeneratorAccessor;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADBlocks;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.ColumnConfig;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class ColumnRamp
extends Feature<ColumnConfig> {
    public final Set<Block> irreplacableBlocks = ImmutableSet.of((Object)Blocks.field_226906_mb_, (Object)Blocks.field_150350_a, (Object)Blocks.field_201941_jj, (Object)Blocks.field_150420_aW, (Object)Blocks.field_150419_aX, (Object)Blocks.field_196706_do, (Object[])new Block[]{Blocks.field_150434_aF, (Block)UADBlocks.BIG_CACTUS_BODY_BLOCK.get(), (Block)UADBlocks.BIG_CACTUS_CORNER_BLOCK.get(), (Block)UADBlocks.BIG_CACTUS_MAIN_BLOCK.get()});

    public ColumnRamp(Codec<ColumnConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, ColumnConfig columnConfig) {
        BlockState aboveBlock;
        int circleBounds;
        int xzDiffSquaredStretched;
        int z;
        int x;
        int zOffset;
        int xOffset;
        int y;
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        int minWidth = 4;
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        while (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, cachedChunk.func_180495_p((BlockPos)blockposMutable))) {
            if (blockposMutable.func_177956_o() > chunkGenerator.func_230355_e_() - 1) {
                return false;
            }
            blockposMutable.func_189534_c(Direction.UP, 2);
        }
        int ceilingHeight = blockposMutable.func_177956_o();
        while (GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, cachedChunk.func_180495_p((BlockPos)blockposMutable))) {
            if (blockposMutable.func_177956_o() > chunkGenerator.func_230355_e_() - 1) {
                return false;
            }
            blockposMutable.func_189536_c(Direction.UP);
        }
        int topFloorHeight = blockposMutable.func_177956_o();
        int ledgeThickness = topFloorHeight - ceilingHeight;
        if (ledgeThickness > 7 || ledgeThickness < 2) {
            return false;
        }
        blockposMutable.func_189533_g((Vector3i)position);
        while (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, cachedChunk.func_180495_p((BlockPos)blockposMutable))) {
            if (blockposMutable.func_177956_o() < 70) {
                return false;
            }
            blockposMutable.func_189534_c(Direction.DOWN, 2);
        }
        int bottomFloorHeight = blockposMutable.func_177956_o();
        int heightDiff = ceilingHeight - bottomFloorHeight;
        if (heightDiff > 27 || heightDiff < 8) {
            return false;
        }
        float randFloat = rand.nextFloat();
        float xTurningValue = (float)Math.sin((double)randFloat * Math.PI * 2.0);
        float zTurningValue = (float)Math.cos((double)randFloat * Math.PI * 2.0);
        int widthAtHeight = this.getWidthAtHeight(0, heightDiff + 5, minWidth);
        int xPosCeiling = position.func_177958_n() + this.getOffsetAtHeight(heightDiff + 1, heightDiff, xTurningValue);
        int zPosCeiling = position.func_177952_p() + this.getOffsetAtHeight(0, heightDiff, zTurningValue);
        int xPosFloor = position.func_177958_n() - this.getOffsetAtHeight(heightDiff - 1, heightDiff, xTurningValue);
        int zPosFloor = position.func_177952_p() + this.getOffsetAtHeight(0, heightDiff, zTurningValue);
        for (int x2 = -widthAtHeight; x2 <= widthAtHeight; ++x2) {
            for (int z2 = -widthAtHeight; z2 <= widthAtHeight; ++z2) {
                if (!((double)(x2 * x2 + z2 * z2) > (double)(widthAtHeight * widthAtHeight) * 0.85) || x2 * x2 + z2 * z2 >= widthAtHeight * widthAtHeight) continue;
                if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                    cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                }
                BlockState block1 = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_181079_c(xPosCeiling + x2, ceilingHeight + 2, zPosCeiling + z2));
                BlockState block2 = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_181079_c(xPosFloor + x2, bottomFloorHeight - 2, zPosFloor + z2));
                if (block1.func_200132_m() && block2.func_200132_m()) continue;
                return false;
            }
        }
        BlockPos.Mutable tempMutable = new BlockPos.Mutable();
        BlockPos.Mutable tempPos2 = new BlockPos.Mutable();
        for (y = -2; y <= heightDiff + 3; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff + 2, minWidth);
            if (heightDiff < 16) {
                xOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) - Math.signum((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) / 2.0f) * 2.0f);
                zOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) - Math.signum((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) / 2.0f) * 2.0f);
            } else if (heightDiff < 21) {
                xOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) - Math.signum((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) / 3.0f) * 4.0f);
                zOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) - Math.signum((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) / 3.0f) * 4.0f);
            } else {
                xOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) - Math.signum((float)this.getOffsetAtHeight(y, heightDiff, xTurningValue) / 3.0f) * 6.0f);
                zOffset = (int)((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) - Math.signum((float)this.getOffsetAtHeight(y, heightDiff, zTurningValue) / 3.0f) * 6.0f);
            }
            for (x = position.func_177958_n() - widthAtHeight - 1; x <= position.func_177958_n() + widthAtHeight + 1; ++x) {
                for (z = position.func_177952_p() - widthAtHeight - 1; z <= position.func_177952_p() + widthAtHeight + 1; ++z) {
                    BlockState block;
                    int xDiff = x - position.func_177958_n();
                    int zDiff = z - position.func_177952_p();
                    blockposMutable.func_181079_c(x + xOffset, y + bottomFloorHeight + 3, z + zOffset);
                    xzDiffSquaredStretched = xDiff * xDiff + zDiff * zDiff;
                    circleBounds = (int)((float)((widthAtHeight - 1) * (widthAtHeight - 1)) - 0.5f);
                    if (y > heightDiff) {
                        circleBounds = (int)((float)circleBounds * (0.6f / (float)(y - heightDiff)));
                    }
                    if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                        cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                    }
                    if ((block = cachedChunk.func_180495_p((BlockPos)blockposMutable)).func_235714_a_((ITag)BlockTags.field_206952_E) || block.func_235714_a_((ITag)BlockTags.field_200031_h) || this.irreplacableBlocks.contains(block.func_177230_c()) || xzDiffSquaredStretched > circleBounds) continue;
                    if (blockposMutable.func_177956_o() < chunkGenerator.func_230356_f_() && chunkGenerator instanceof NoiseChunkGenerator) {
                        cachedChunk.func_177436_a((BlockPos)blockposMutable, ((NoiseChunkGeneratorAccessor)chunkGenerator).uad_getDefaultFluid(), false);
                    } else {
                        tempMutable.func_189533_g((Vector3i)blockposMutable).func_189536_c(Direction.DOWN);
                        if (columnConfig.snowy && Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)world, (BlockPos)blockposMutable)) {
                            cachedChunk.func_177436_a((BlockPos)blockposMutable, Blocks.field_150433_aE.func_176223_P(), false);
                            BlockState belowBlock = cachedChunk.func_180495_p((BlockPos)tempMutable);
                            if (belowBlock.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) {
                                cachedChunk.func_177436_a((BlockPos)tempMutable, (BlockState)belowBlock.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), false);
                            }
                        } else {
                            BlockState aboveBlock2 = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP));
                            blockposMutable.func_189536_c(Direction.DOWN);
                            if (!aboveBlock2.func_235714_a_((ITag)BlockTags.field_200031_h)) {
                                cachedChunk.func_177436_a((BlockPos)blockposMutable, Blocks.field_150350_a.func_176223_P(), false);
                            }
                        }
                    }
                    tempMutable.func_189533_g((Vector3i)blockposMutable).func_189536_c(Direction.UP);
                    block = cachedChunk.func_180495_p((BlockPos)tempMutable);
                    while (tempMutable.func_177956_o() < chunkGenerator.func_230355_e_() && !block.func_196955_c((IWorldReader)world, (BlockPos)tempMutable)) {
                        cachedChunk.func_177436_a((BlockPos)tempMutable, Blocks.field_150350_a.func_176223_P(), false);
                        block = cachedChunk.func_180495_p((BlockPos)tempMutable.func_189536_c(Direction.UP));
                    }
                    BlockState blockBelowAir = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN));
                    BlockState blockBelowBelowAir = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN));
                    blockposMutable.func_189536_c(Direction.UP);
                    if (GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, blockBelowAir)) {
                        if (columnConfig.topBlock.func_177230_c() instanceof FallingBlock && blockBelowBelowAir.func_196958_f() || blockposMutable.func_177956_o() < chunkGenerator.func_230356_f_()) {
                            cachedChunk.func_177436_a((BlockPos)blockposMutable, columnConfig.middleBlock, false);
                        } else {
                            cachedChunk.func_177436_a((BlockPos)blockposMutable, columnConfig.topBlock, false);
                            tempMutable.func_189533_g((Vector3i)blockposMutable).func_189536_c(Direction.UP);
                            aboveBlock = cachedChunk.func_180495_p((BlockPos)tempMutable);
                            if (columnConfig.snowy && aboveBlock.func_196958_f() && Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)world, (BlockPos)tempMutable)) {
                                cachedChunk.func_177436_a((BlockPos)tempMutable, Blocks.field_150433_aE.func_176223_P(), false);
                                if (columnConfig.topBlock.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) {
                                    cachedChunk.func_177436_a((BlockPos)blockposMutable, (BlockState)columnConfig.topBlock.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), false);
                                }
                            }
                        }
                    }
                    blockposMutable.func_189536_c(Direction.UP);
                }
            }
        }
        for (y = -2; y <= heightDiff + 4; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff + 5, minWidth);
            xOffset = this.getOffsetAtHeight(y, heightDiff, xTurningValue);
            zOffset = this.getOffsetAtHeight(y, heightDiff, zTurningValue);
            for (x = position.func_177958_n() - widthAtHeight - 1; x <= position.func_177958_n() + widthAtHeight + 1; ++x) {
                for (z = position.func_177952_p() - widthAtHeight - 1; z <= position.func_177952_p() + widthAtHeight + 1; ++z) {
                    int xDiff = x - position.func_177958_n();
                    int zDiff = z - position.func_177952_p();
                    blockposMutable.func_181079_c(x + xOffset, y + bottomFloorHeight, z + zOffset);
                    xzDiffSquaredStretched = xDiff * xDiff + zDiff * zDiff;
                    circleBounds = (int)((float)((widthAtHeight - 1) * (widthAtHeight - 1)) - 0.5f);
                    if (y > heightDiff - 3) {
                        circleBounds = (int)((float)circleBounds * (0.8f / (float)(y - (heightDiff - 3))));
                    }
                    if (y <= heightDiff && xzDiffSquaredStretched <= circleBounds) {
                        if (GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, world.func_180495_p((BlockPos)blockposMutable))) continue;
                        world.func_180501_a((BlockPos)blockposMutable, columnConfig.insideBlock, 2);
                        continue;
                    }
                    if (y <= heightDiff && xzDiffSquaredStretched > (widthAtHeight + 3) * (widthAtHeight + 3)) continue;
                    for (int downward = 0; downward < 6 && y - downward >= -3; ++downward) {
                        tempMutable.func_189533_g((Vector3i)blockposMutable).func_189534_c(Direction.DOWN, downward);
                        BlockState block = world.func_180495_p((BlockPos)tempMutable);
                        BlockState blockBelow = world.func_180495_p((BlockPos)tempMutable.func_189536_c(Direction.DOWN));
                        tempMutable.func_189536_c(Direction.UP);
                        if (block != columnConfig.insideBlock) continue;
                        if (!(tempMutable.func_177956_o() < chunkGenerator.func_230356_f_() - 1 || downward != 1 || columnConfig.topBlock.func_177230_c() instanceof FallingBlock && blockBelow.func_196958_f())) {
                            world.func_180501_a((BlockPos)tempMutable, columnConfig.topBlock, 2);
                            tempPos2.func_189533_g((Vector3i)tempMutable).func_189536_c(Direction.UP);
                            aboveBlock = world.func_180495_p((BlockPos)tempPos2);
                            if (!columnConfig.snowy || !aboveBlock.func_196958_f() || !Blocks.field_150433_aE.func_176223_P().func_196955_c((IWorldReader)world, (BlockPos)tempPos2)) continue;
                            world.func_180501_a((BlockPos)tempPos2, Blocks.field_150433_aE.func_176223_P(), 2);
                            if (!columnConfig.topBlock.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) continue;
                            world.func_180501_a((BlockPos)tempMutable, (BlockState)columnConfig.topBlock.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)tempMutable, columnConfig.middleBlock, 2);
                    }
                }
            }
        }
        return true;
    }

    private int getWidthAtHeight(int y, int heightDiff, int thinnestWidth) {
        float yFromCenter = (float)y - (float)heightDiff * 0.5f;
        yFromCenter = Math.abs(yFromCenter * 0.4f) + 3.0f;
        return thinnestWidth + (int)(yFromCenter * yFromCenter / 8.0f);
    }

    private int getOffsetAtHeight(int y, int heightDiff, float turningValue) {
        float yFromCenter = (float)y - (float)heightDiff / 2.0f;
        return (int)(turningValue * yFromCenter);
    }
}

