/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.ColumnConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class ColumnVertical
extends Feature<ColumnConfig> {
    protected OpenSimplexNoise noiseGen;
    protected long seed;

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGen == null) {
            this.noiseGen = new OpenSimplexNoise(seed);
            this.seed = seed;
        }
    }

    public ColumnVertical(Codec<ColumnConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, ColumnConfig columnConfig) {
        int zMod;
        int xMod;
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        int minWidth = 3;
        int maxWidth = 10;
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        while (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, cachedChunk.func_180495_p((BlockPos)blockposMutable))) {
            if (blockposMutable.func_177956_o() > chunkGenerator.func_230355_e_() - 1) {
                return false;
            }
            blockposMutable.func_189534_c(Direction.UP, 2);
        }
        int ceilingHeight = blockposMutable.func_177956_o();
        blockposMutable.func_189533_g((Vector3i)position);
        while (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, cachedChunk.func_180495_p((BlockPos)blockposMutable))) {
            if (blockposMutable.func_177956_o() < 3) {
                return false;
            }
            blockposMutable.func_189534_c(Direction.DOWN, 2);
        }
        int floorHeight = blockposMutable.func_177956_o();
        int heightDiff = ceilingHeight - floorHeight;
        if (heightDiff > 100 || heightDiff < 10) {
            return false;
        }
        int thinnestWidth = (int)((float)maxWidth * ((float)heightDiff / 100.0f));
        if (thinnestWidth < minWidth) {
            thinnestWidth = minWidth;
        }
        int widthAtHeight = this.getWidthAtHeight(0, heightDiff, thinnestWidth);
        for (int x = position.func_177958_n() - widthAtHeight; x <= position.func_177958_n() + widthAtHeight; x += 3) {
            for (int z = position.func_177952_p() - widthAtHeight; z <= position.func_177952_p() + widthAtHeight; z += 3) {
                int zDiff;
                int xDiff = x - position.func_177958_n();
                if (xDiff * xDiff + (zDiff = z - position.func_177952_p()) * zDiff > widthAtHeight * widthAtHeight) continue;
                if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                    cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                }
                BlockState block1 = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_181079_c(x, ceilingHeight + 3, z));
                BlockState block2 = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_181079_c(x, floorHeight - 2, z));
                if (GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, block1) && GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, block2)) continue;
                return false;
            }
        }
        boolean flagImperfection1 = rand.nextBoolean();
        boolean flagImperfection2 = rand.nextBoolean();
        if (flagImperfection1 && flagImperfection2) {
            xMod = heightDiff / 20 + 1;
            zMod = heightDiff / 20 + 1;
        } else if (flagImperfection1) {
            xMod = heightDiff / 20 + 1;
            zMod = 0;
        } else if (flagImperfection2) {
            xMod = 0;
            zMod = heightDiff / 20 + 1;
        } else {
            xMod = 0;
            zMod = 0;
        }
        for (int y = -2; y <= heightDiff + 2; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff, thinnestWidth);
            for (int x = position.func_177958_n() - widthAtHeight - xMod - 1; x <= position.func_177958_n() + widthAtHeight + xMod + 1; ++x) {
                for (int z = position.func_177952_p() - widthAtHeight - zMod - 1; z <= position.func_177952_p() + widthAtHeight + zMod + 1; ++z) {
                    int xDiff = x - position.func_177958_n();
                    int zDiff = z - position.func_177952_p();
                    blockposMutable.func_181079_c(x, y + floorHeight, z);
                    boolean flagImperfection3 = this.noiseGen.eval((double)x * 0.06, (double)z * 0.6, (double)y * 0.02) < 0.0;
                    int currentWidth = flagImperfection3 && (widthAtHeight > thinnestWidth || widthAtHeight == thinnestWidth && rand.nextInt(4) == 0) ? widthAtHeight - 1 : widthAtHeight;
                    int xzDiffSquaredStretched = (xMod + 1) * (xDiff * xDiff) + (zMod + 1) * (zDiff * zDiff);
                    int xzDiffSquared = xDiff * xDiff + zDiff * zDiff;
                    if (xzDiffSquaredStretched <= (currentWidth - 1) * (currentWidth - 1)) {
                        if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                            cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                        }
                        if (cachedChunk.func_180495_p((BlockPos)blockposMutable).func_200132_m()) continue;
                        cachedChunk.func_177436_a((BlockPos)blockposMutable, columnConfig.insideBlock, false);
                        continue;
                    }
                    if (y >= heightDiff / 2 || xzDiffSquared > (widthAtHeight + 2) * (widthAtHeight + 2)) continue;
                    for (int downward = 0; downward < 6 && y - downward >= -3; ++downward) {
                        if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                            cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                        }
                        if (cachedChunk.func_180495_p((BlockPos)blockposMutable) == columnConfig.insideBlock) {
                            if (downward == 1 && blockposMutable.func_177956_o() >= chunkGenerator.func_230356_f_() - 1) {
                                if (!columnConfig.snowy) {
                                    cachedChunk.func_177436_a((BlockPos)blockposMutable, columnConfig.topBlock, false);
                                } else {
                                    cachedChunk.func_177436_a((BlockPos)blockposMutable.func_189536_c(Direction.UP), Blocks.field_150433_aE.func_176223_P(), false);
                                    blockposMutable.func_189536_c(Direction.DOWN);
                                    if (columnConfig.topBlock.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) {
                                        cachedChunk.func_177436_a((BlockPos)blockposMutable, (BlockState)columnConfig.topBlock.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), false);
                                    } else {
                                        cachedChunk.func_177436_a((BlockPos)blockposMutable, columnConfig.topBlock, false);
                                    }
                                }
                            } else {
                                cachedChunk.func_177436_a((BlockPos)blockposMutable, columnConfig.middleBlock, false);
                            }
                        }
                        blockposMutable.func_189536_c(Direction.DOWN);
                    }
                }
            }
        }
        return true;
    }

    private int getWidthAtHeight(int y, int heightDiff, int thinnestWidth) {
        if (heightDiff > 80) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) - 2.0f;
            return thinnestWidth + (int)(yFromCenter / 4.0f * (yFromCenter / 4.0f) / 10.0f);
        }
        if (heightDiff > 60) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) - 1.0f;
            return thinnestWidth + (int)(yFromCenter / 3.0f * (yFromCenter / 3.0f) / 9.0f);
        }
        if (heightDiff > 30) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f);
            return thinnestWidth + (int)(yFromCenter / 2.6f * (yFromCenter / 2.6f) / 6.0f);
        }
        if (heightDiff > 18) {
            float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) + 1.0f;
            return thinnestWidth + (int)(yFromCenter / 2.8f * (yFromCenter / 2.8f) / 3.0f);
        }
        float yFromCenter = Math.abs((float)y - (float)heightDiff / 2.0f) + 3.0f;
        return thinnestWidth + (int)(yFromCenter / 2.7f * (yFromCenter / 2.7f) / 3.0f);
    }
}

