/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class ContainLiquidForOceans
extends Feature<NoFeatureConfig> {
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    private static final BlockState[] DEAD_CORAL_ARRAY = new BlockState[]{Blocks.field_204408_jI.func_176223_P(), Blocks.field_204405_jF.func_176223_P(), Blocks.field_204406_jG.func_176223_P(), Blocks.field_204407_jH.func_176223_P(), Blocks.field_204404_jE.func_176223_P()};

    public ContainLiquidForOceans(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig configBlock) {
        Biome oceanBiome = this.getOceanInChunk((IWorld)world, position);
        if (oceanBiome == null) {
            return false;
        }
        int sealevel = world.func_201672_e().func_181545_F();
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable(position.func_177958_n(), 0, position.func_177952_p());
        BlockPos.Mutable blockposMutableAbove = new BlockPos.Mutable().func_189533_g((Vector3i)blockposMutable);
        IChunk chunk = world.func_212866_a_(position.func_177958_n() >> 4, position.func_177952_p() >> 4);
        BlockState oceanTopBlock = oceanBiome.func_242440_e().func_242502_e().func_204108_a();
        BlockState oceanUnderBlock = oceanBiome.func_242440_e().func_242502_e().func_204109_b();
        boolean useCoralTop = oceanTopBlock == DEAD_CORAL_ARRAY[0];
        boolean useCoralBottom = oceanTopBlock == DEAD_CORAL_ARRAY[0];
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                blockposMutable.func_181079_c(position.func_177958_n() + x, 256, position.func_177952_p() + z);
                while (blockposMutable.func_177956_o() >= sealevel) {
                    BlockState blockAbove;
                    BlockState currentblock = chunk.func_180495_p((BlockPos)blockposMutable);
                    while (currentblock.func_204520_s().func_206888_e() && blockposMutable.func_177956_o() >= sealevel) {
                        blockposMutable.func_189536_c(Direction.DOWN);
                        currentblock = chunk.func_180495_p((BlockPos)blockposMutable);
                    }
                    if (blockposMutable.func_177956_o() < sealevel) continue block1;
                    boolean containedFlag = true;
                    for (Direction face : Direction.Plane.HORIZONTAL) {
                        blockposMutable.func_189536_c(face);
                        if (blockposMutable.func_177958_n() >> 4 != chunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != chunk.func_76632_l().field_77275_b) {
                            chunk = world.func_217349_x((BlockPos)blockposMutable);
                        }
                        if (!(currentblock = chunk.func_180495_p((BlockPos)blockposMutable)).func_200132_m() && currentblock.func_204520_s().func_206888_e() && currentblock != ICE || currentblock == SNOW) {
                            containedFlag = false;
                            blockposMutable.func_189536_c(face.func_176734_d());
                            break;
                        }
                        blockposMutable.func_189536_c(face.func_176734_d());
                    }
                    blockposMutableAbove.func_189533_g((Vector3i)blockposMutable).func_189536_c(Direction.UP);
                    if (blockposMutable.func_177958_n() >> 4 != chunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != chunk.func_76632_l().field_77275_b) {
                        chunk = world.func_217349_x((BlockPos)blockposMutable);
                    }
                    if (containedFlag) {
                        blockAbove = chunk.func_180495_p((BlockPos)blockposMutableAbove);
                        if (blockAbove == oceanUnderBlock) {
                            if (useCoralBottom || !(oceanBiome.func_242440_e().func_242502_e() instanceof SurfaceBuilderConfig)) {
                                chunk.func_177436_a((BlockPos)blockposMutableAbove, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], false);
                            } else {
                                chunk.func_177436_a((BlockPos)blockposMutableAbove, ((SurfaceBuilderConfig)oceanBiome.func_242440_e().func_242502_e()).func_204110_c(), false);
                            }
                        }
                    } else if (blockposMutable.func_177956_o() < 256) {
                        blockAbove = chunk.func_180495_p((BlockPos)blockposMutableAbove);
                        if (blockAbove.func_200132_m() || !blockAbove.func_204520_s().func_206888_e()) {
                            chunk.func_177436_a((BlockPos)blockposMutable, oceanUnderBlock, false);
                        } else if (useCoralTop) {
                            chunk.func_177436_a((BlockPos)blockposMutable, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], false);
                        } else {
                            chunk.func_177436_a((BlockPos)blockposMutable, oceanTopBlock, false);
                        }
                    } else if (useCoralTop) {
                        chunk.func_177436_a((BlockPos)blockposMutable, DEAD_CORAL_ARRAY[random.nextInt(DEAD_CORAL_ARRAY.length)], false);
                    } else {
                        chunk.func_177436_a((BlockPos)blockposMutable, oceanTopBlock, false);
                    }
                    blockposMutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }

    private Biome getOceanInChunk(IWorld world, BlockPos originalPosition) {
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x != 0 && x != 15 && z != 0 && z != 15) continue;
                mutableBlockPos.func_181079_c(originalPosition.func_177958_n() + x, 0, originalPosition.func_177952_p() + z);
                Biome biomeAtLocation = world.func_226691_t_((BlockPos)mutableBlockPos);
                if (biomeAtLocation.func_201856_r() != Biome.Category.OCEAN) continue;
                return biomeAtLocation;
            }
        }
        return null;
    }
}

