/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.GiantSpikeConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class GiantSpike
extends Feature<GiantSpikeConfig> {
    public GiantSpike(Codec<GiantSpikeConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos position, GiantSpikeConfig config) {
        BlockState startBlockState = world.func_180495_p(position);
        if (!config.target.func_215181_a(startBlockState, rand) && startBlockState != config.aboveSeaState && startBlockState != config.belowSeaState) {
            return false;
        }
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        mutableBlockPos.func_189534_c(Direction.UP, rand.nextInt(4));
        int headHeightOffset = rand.nextInt(4) + 7;
        int tailWidthOffset = headHeightOffset / 4 + rand.nextInt(2);
        if (rand.nextFloat() < config.giantSpikeChance) {
            int extraHeight = rand.nextInt(config.giantSpikeMaxHeight - config.giantSpikeMinHeight) + config.giantSpikeMinHeight;
            if (mutableBlockPos.func_177956_o() + extraHeight > generator.func_230355_e_() - 10) {
                mutableBlockPos.func_189534_c(Direction.UP, generator.func_230355_e_() - 10 - mutableBlockPos.func_177956_o());
            } else {
                mutableBlockPos.func_189534_c(Direction.UP, extraHeight);
            }
        }
        int finalHeight = mutableBlockPos.func_177956_o();
        for (int y = 0; y < headHeightOffset; ++y) {
            float maxWidth = (1.0f - (float)y / (float)headHeightOffset) * (float)tailWidthOffset;
            int range = MathHelper.func_76123_f((float)maxWidth);
            for (int x = -range; x <= range; ++x) {
                float xWidth = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -range; z <= range; ++z) {
                    float zWidth = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(xWidth * xWidth + zWidth * zWidth <= maxWidth * maxWidth) || (x == -range || x == range || z == -range || z == range) && !(rand.nextFloat() <= 0.75f)) continue;
                    BlockPos topPos = mutableBlockPos.func_177982_a(x, y, z);
                    BlockPos bottomPos = mutableBlockPos.func_177982_a(x, -y, z);
                    BlockState currentBlockState = world.func_180495_p(topPos);
                    if (config.target.func_215181_a(currentBlockState, rand) && topPos.func_177956_o() >= generator.func_230356_f_() - 1) {
                        this.func_230367_a_((IWorldWriter)world, topPos, config.aboveSeaState);
                    } else if (!currentBlockState.func_204520_s().func_206888_e()) {
                        this.func_230367_a_((IWorldWriter)world, topPos, config.belowSeaState);
                    }
                    if (y == 0 || range <= 1) continue;
                    currentBlockState = world.func_180495_p(bottomPos);
                    if (config.target.func_215181_a(currentBlockState, rand) && bottomPos.func_177956_o() >= generator.func_230356_f_() - 1) {
                        this.func_230367_a_((IWorldWriter)world, bottomPos, config.aboveSeaState);
                        continue;
                    }
                    if (currentBlockState.func_204520_s().func_206888_e()) continue;
                    this.func_230367_a_((IWorldWriter)world, bottomPos, config.belowSeaState);
                }
            }
        }
        int maxWidth = 1;
        for (int x = -maxWidth; x <= maxWidth; ++x) {
            block4: for (int z = -maxWidth; z <= maxWidth; ++z) {
                mutableBlockPos.func_181079_c(position.func_177958_n() + x, finalHeight - 1, position.func_177952_p() + z);
                int modeThreshold = Integer.MAX_VALUE;
                boolean placingMode = true;
                if (Math.abs(x) == maxWidth && Math.abs(z) == maxWidth) {
                    modeThreshold = rand.nextInt(5);
                }
                while (mutableBlockPos.func_177956_o() > 5) {
                    BlockState currentBlockState = world.func_180495_p((BlockPos)mutableBlockPos);
                    if (mutableBlockPos.func_177956_o() != finalHeight - 1 && !config.target.func_215181_a(currentBlockState, rand)) continue block4;
                    if (placingMode) {
                        if (mutableBlockPos.func_177956_o() < generator.func_230356_f_() - 1) {
                            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutableBlockPos, config.belowSeaState);
                        } else {
                            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutableBlockPos, config.aboveSeaState);
                        }
                    } else if (mutableBlockPos.func_177956_o() == generator.func_230356_f_() - 1) {
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutableBlockPos, config.aboveSeaState);
                    }
                    mutableBlockPos.func_189536_c(Direction.DOWN);
                    if (modeThreshold <= 0) {
                        ++modeThreshold;
                        if (!placingMode) continue;
                        placingMode = false;
                        modeThreshold = -(rand.nextInt(6) - 1);
                        continue;
                    }
                    --modeThreshold;
                    if (placingMode) continue;
                    placingMode = true;
                    modeThreshold = rand.nextInt(5);
                }
            }
        }
        return true;
    }
}

