/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.UltraAmplifiedDimension;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HangingRuins
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation HANGING_RUINS_RL = new ResourceLocation("ultra_amplified_dimension:hanging_ruins");

    public HangingRuins(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, NoFeatureConfig config) {
        TemplateManager templatemanager;
        Template template;
        if (position.func_177956_o() < chunkGenerator.func_230356_f_() + 5) {
            return false;
        }
        BlockPos.Mutable mutableMain = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        BlockPos.Mutable mutableTemp = new BlockPos.Mutable();
        BlockState currentBlock = world.func_180495_p((BlockPos)mutableMain);
        while ((BlockTags.field_200031_h.func_230235_a_((Object)currentBlock.func_177230_c()) || !currentBlock.func_200132_m()) && mutableMain.func_177956_o() < chunkGenerator.func_230355_e_()) {
            mutableMain.func_189536_c(Direction.UP);
            currentBlock = world.func_180495_p((BlockPos)mutableMain);
        }
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                if (Math.abs(x * z) <= 9 || Math.abs(x * z) >= 20) continue;
                mutableTemp.func_189533_g((Vector3i)mutableMain).func_196234_d(x, 1, z);
                if (world.func_180495_p((BlockPos)mutableTemp).func_200132_m()) continue;
                return false;
            }
        }
        if (this.shouldMoveDownOne((IWorld)world, mutableMain)) {
            mutableMain.func_189536_c(Direction.DOWN);
        }
        if ((template = (templatemanager = world.func_201672_e().func_73046_m().func_240792_aT_()).func_200219_b(HANGING_RUINS_RL)) == null) {
            UltraAmplifiedDimension.LOGGER.warn("hanging ruins NTB does not exist!");
            return false;
        }
        if (mutableMain.func_177956_o() == chunkGenerator.func_230355_e_() || !world.func_180495_p(mutableMain.func_177979_c(template.func_186259_a().func_177956_o())).func_196958_f() || !world.func_180495_p(mutableMain.func_177979_c(template.func_186259_a().func_177956_o() + 5)).func_196958_f()) {
            return false;
        }
        BlockPos halfLengths = new BlockPos(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2);
        PlacementSettings placementsettings = new PlacementSettings().func_207665_a(halfLengths).func_186220_a(Rotation.func_222466_a((Random)rand)).func_186222_a(false);
        template.func_237152_b_((IServerWorld)world, (BlockPos)mutableMain.func_196234_d(-halfLengths.func_177958_n(), -8, -halfLengths.func_177952_p()), placementsettings, rand);
        return true;
    }

    private boolean shouldMoveDownOne(IWorld world, BlockPos.Mutable mutableMain) {
        BlockPos.Mutable mutableTemp = new BlockPos.Mutable();
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                mutableTemp.func_189533_g((Vector3i)mutableMain).func_196234_d(x, 2, z);
                if (Math.abs(x * z) >= 20 || world.func_180495_p((BlockPos)mutableTemp).func_200132_m()) continue;
                return true;
            }
        }
        return false;
    }
}

