/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class IcebergWithoutAir
extends Feature<BlockStateFeatureConfig> {
    public IcebergWithoutAir(Codec<BlockStateFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, BlockStateFeatureConfig icebergConfig) {
        boolean flag2;
        int y;
        int z;
        int x;
        int upperHeight;
        boolean flag = random.nextDouble() > 0.7;
        BlockState iblockstate = icebergConfig.field_227270_a_;
        double d0 = random.nextDouble() * 2.0 * Math.PI;
        int i = 11 - random.nextInt(5);
        int j = 3 + random.nextInt(3);
        boolean flag1 = random.nextDouble() > 0.7;
        int n = upperHeight = flag1 ? random.nextInt(6) + 6 : random.nextInt(15) + 3;
        if (!flag1 && random.nextDouble() > 0.9) {
            upperHeight += random.nextInt(19) + 7;
        }
        int downHeight = Math.min(upperHeight + random.nextInt(11), 18);
        int maxheight = Math.min(upperHeight + random.nextInt(7) - random.nextInt(5), 11);
        int radius = flag1 ? i : 11;
        for (x = -radius; x < radius; ++x) {
            for (z = -radius; z < radius; ++z) {
                for (y = 0; y < upperHeight; ++y) {
                    int k2;
                    int n2 = k2 = flag1 ? this.func_205178_b(y, upperHeight, maxheight) : this.func_205183_a(random, y, upperHeight, maxheight);
                    if (!flag1 && x >= k2) continue;
                    this.func_205181_a((IWorld)world, random, position, upperHeight, x, y, z, k2, radius, flag1, j, d0, flag, iblockstate);
                }
            }
        }
        this.func_205186_a((IWorld)world, position, maxheight, upperHeight, flag1, i);
        for (x = -radius; x < radius; ++x) {
            for (z = -radius; z < radius; ++z) {
                for (y = -1; y > -downHeight; --y) {
                    int l3 = flag1 ? MathHelper.func_76123_f((float)((float)radius * (1.0f - (float)Math.pow(y, 2.0) / ((float)downHeight * 8.0f)))) : radius;
                    int l2 = this.func_205187_b(random, -y, downHeight, maxheight);
                    if (x >= l2) continue;
                    this.func_205181_a((IWorld)world, random, position, downHeight, x, y, z, l2, l3, flag1, j, d0, flag, iblockstate);
                }
            }
        }
        boolean bl = flag1 ? random.nextDouble() > 0.1 : (flag2 = random.nextDouble() > 0.7);
        if (flag2) {
            this.func_205184_a(random, (IWorld)world, maxheight, upperHeight, position, flag1, i, d0, j);
        }
        return true;
    }

    private void func_205184_a(Random random, IWorld world, int maxheight, int height, BlockPos position, boolean flag, int int1, double double1, int int2) {
        int heightThickness;
        int x = random.nextBoolean() ? -1 : 1;
        int z = random.nextBoolean() ? -1 : 1;
        int randomHeightBasedMultiplier = random.nextInt(Math.max(maxheight / 2 - 2, 1));
        if (random.nextBoolean()) {
            randomHeightBasedMultiplier = maxheight / 2 + 1 - random.nextInt(Math.max(maxheight - maxheight / 2 - 1, 1));
        }
        int l = random.nextInt(Math.max(maxheight / 2 - 2, 1));
        if (random.nextBoolean()) {
            l = maxheight / 2 + 1 - random.nextInt(Math.max(maxheight - maxheight / 2 - 1, 1));
        }
        if (flag) {
            randomHeightBasedMultiplier = l = random.nextInt(Math.max(int1 - 5, 1));
        }
        BlockPos blockpos = new BlockPos(x * randomHeightBasedMultiplier, 0, z * l);
        double double2 = flag ? double1 + 1.5707963267948966 : random.nextDouble() * 2.0 * Math.PI;
        for (int currentHeight = 0; currentHeight < height - 3; ++currentHeight) {
            heightThickness = this.func_205183_a(random, currentHeight, height, maxheight);
            this.func_205174_a(heightThickness, currentHeight, position, world, false, double2, blockpos, int1, int2);
        }
        for (int belowCenterY = -1; belowCenterY > -height + random.nextInt(5); --belowCenterY) {
            heightThickness = this.func_205187_b(random, -belowCenterY, height, maxheight);
            this.func_205174_a(heightThickness, belowCenterY, position, world, true, double2, blockpos, int1, int2);
        }
    }

    private void func_205174_a(int heightThickness, int belowCenterY, BlockPos position, IWorld world, boolean placeWater, double double1, BlockPos pos2, int int1, int int2) {
        int radius = heightThickness + 1 + int1 / 3;
        int int3 = Math.min(heightThickness - 3, 3) + int2 / 2 - 1;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                double d0 = this.func_205180_a(x, z, pos2, radius, int3, double1);
                if (!(d0 < 0.0)) continue;
                blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, belowCenterY, z);
                BlockState blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
                if (!blockState.func_235714_a_((ITag)BlockTags.field_205213_E) && !blockState.func_203425_a(Blocks.field_196604_cC)) continue;
                world.func_180501_a((BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, position), 3);
                if (placeWater) continue;
                this.removeSnowLayer(world, blockpos$Mutable);
            }
        }
    }

    private void removeSnowLayer(IWorld world, BlockPos.Mutable mutableBlockPos) {
        if (world.func_180495_p((BlockPos)mutableBlockPos.func_189536_c(Direction.UP)).func_203425_a(Blocks.field_150433_aE)) {
            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutableBlockPos, this.appropriateBlockForNeighbors(world, mutableBlockPos.func_177977_b()));
        }
        mutableBlockPos.func_189536_c(Direction.DOWN);
    }

    private void func_205181_a(IWorld world, Random random, BlockPos position, int maxHeight, int xPos, int yPos, int zPos, int int1, int int2, boolean flag1, int int3, double double1, boolean flag2, BlockState defaultState) {
        double noise;
        double d = noise = flag1 ? this.func_205180_a(xPos, zPos, BlockPos.field_177992_a, int2, this.func_205176_a(yPos, maxHeight, int3), double1) : this.func_205177_a(xPos, zPos, BlockPos.field_177992_a, int1, random);
        if (noise < 0.0) {
            double randomizer;
            BlockPos blockpos1 = position.func_177982_a(xPos, yPos, zPos);
            double d2 = randomizer = flag1 ? -0.5 : (double)(-6 - random.nextInt(3));
            if (noise > randomizer && random.nextDouble() > 0.9) {
                return;
            }
            this.func_205175_a(blockpos1, world, random, maxHeight - yPos, maxHeight, flag1, flag2, defaultState);
        }
    }

    private void func_205175_a(BlockPos position, IWorld world, Random random, int minHeight, int maxHeight, boolean flag1, boolean flag2, BlockState defaultState) {
        BlockState currentBlockState = world.func_180495_p(position);
        if (currentBlockState.func_196958_f() || currentBlockState.func_203425_a(Blocks.field_196604_cC) || currentBlockState.func_235714_a_((ITag)BlockTags.field_205213_E) || !currentBlockState.func_204520_s().func_206888_e()) {
            int i;
            boolean flag = !flag1 || random.nextDouble() > 0.05;
            int n = i = flag1 ? 3 : 2;
            if (flag2 && currentBlockState.func_204520_s().func_206888_e() && (double)minHeight <= (double)random.nextInt(Math.max(1, maxHeight / i)) + (double)maxHeight * 0.6 && flag) {
                this.func_230367_a_((IWorldWriter)world, position, Blocks.field_196604_cC.func_176223_P());
            } else {
                this.func_230367_a_((IWorldWriter)world, position, defaultState);
            }
        }
    }

    private BlockState appropriateBlockForNeighbors(IWorld world, BlockPos position) {
        boolean bordersWater = false;
        boolean bordersAir = false;
        for (Direction face : Direction.values()) {
            BlockState blockState;
            if (face == Direction.UP || (blockState = world.func_180495_p(position.func_177972_a(face))).func_235714_a_((ITag)BlockTags.field_205213_E)) continue;
            if (blockState.func_196958_f()) {
                bordersAir = true;
                continue;
            }
            if (blockState.func_204520_s().func_206888_e()) continue;
            bordersWater = true;
        }
        if (bordersWater && bordersAir) {
            return Blocks.field_150348_b.func_176223_P();
        }
        if (bordersWater) {
            return Blocks.field_150355_j.func_176223_P();
        }
        if (bordersAir) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return Blocks.field_150403_cj.func_176223_P();
    }

    private void func_205186_a(IWorld world, BlockPos position, int smallRadiusIn, int height, boolean flag, int largeRadiusIn) {
        int radius = flag ? largeRadiusIn : smallRadiusIn / 2;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y <= height; ++y) {
                    blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    BlockState blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
                    if (!blockState.func_235714_a_((ITag)BlockTags.field_205213_E) && !blockState.func_203425_a(Blocks.field_150433_aE)) continue;
                    if (this.isAirBelow((IBlockReader)world, (BlockPos)blockpos$Mutable)) {
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, (BlockPos)blockpos$Mutable));
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$Mutable.func_189536_c(Direction.UP), this.appropriateBlockForNeighbors(world, (BlockPos)blockpos$Mutable));
                        continue;
                    }
                    if (!blockState.func_235714_a_((ITag)BlockTags.field_205213_E)) continue;
                    int notIceCounter = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        BlockState neighboringState = world.func_180495_p((BlockPos)blockpos$Mutable.func_189536_c(direction));
                        if (!neighboringState.func_235714_a_((ITag)BlockTags.field_205213_E)) {
                            ++notIceCounter;
                        }
                        blockpos$Mutable.func_189536_c(direction.func_176734_d());
                    }
                    if (notIceCounter < 3) continue;
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$Mutable, this.appropriateBlockForNeighbors(world, (BlockPos)blockpos$Mutable));
                }
            }
        }
    }

    public boolean isAirBelow(IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_196958_f();
    }

    public int func_205178_b(int p_205178_1_, int p_205178_2_, int p_205178_3_) {
        float f1 = (1.0f - (float)Math.pow(p_205178_1_, 2.0) / ((float)p_205178_2_ * 1.0f)) * (float)p_205178_3_;
        return MathHelper.func_76123_f((float)(f1 / 2.0f));
    }

    public int func_205183_a(Random rand, int int1, int int2, int int3) {
        float f = 3.5f - rand.nextFloat() * 0.1f;
        float f1 = (1.0f - (float)Math.pow(int1, 2.0) / ((float)int2 * f)) * (float)int3;
        if (int2 > 15) {
            int i = int1 < 3 ? int1 / 2 : int1;
            f1 = (1.0f - (float)i / ((float)int2 * f * 0.4f)) * (float)int3;
        }
        return MathHelper.func_76123_f((float)(f1 / 2.0f));
    }

    public int func_205187_b(Random rand, int p_205187_2_, int p_205187_3_, int p_205187_4_) {
        float f = 1.0f + rand.nextFloat() / 2.0f;
        float f1 = (1.0f - (float)p_205187_2_ / ((float)p_205187_3_ * f)) * (float)p_205187_4_;
        return MathHelper.func_76123_f((float)(f1 / 2.0f));
    }

    public double func_205180_a(int xIn, int zIn, BlockPos pos, int p_205180_4_, int p_205180_5_, double p_205180_6_) {
        return Math.pow(((double)(xIn - pos.func_177958_n()) * Math.cos(p_205180_6_) - (double)(zIn - pos.func_177952_p()) * Math.sin(p_205180_6_)) / (double)p_205180_4_, 2.0) + Math.pow(((double)(xIn - pos.func_177958_n()) * Math.sin(p_205180_6_) + (double)(zIn - pos.func_177952_p()) * Math.cos(p_205180_6_)) / (double)p_205180_5_, 2.0) - 1.0;
    }

    public int func_205176_a(int p_205176_1_, int p_205176_2_, int p_205176_3_) {
        int i = p_205176_3_;
        if (p_205176_1_ > 0 && p_205176_2_ - p_205176_1_ <= 3) {
            i = p_205176_3_ - (4 - (p_205176_2_ - p_205176_1_));
        }
        return i;
    }

    public double func_205177_a(int p_205177_1_, int p_205177_2_, BlockPos pos, int p_205177_4_, Random rand) {
        float f = 10.0f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.2f, (float)0.8f) / (float)p_205177_4_;
        return (double)f + Math.pow(p_205177_1_ - pos.func_177958_n(), 2.0) + Math.pow(p_205177_2_ - pos.func_177952_p(), 2.0) - Math.pow(p_205177_4_, 2.0);
    }
}

