/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class LakeWideShallow
extends Feature<BlockStateFeatureConfig> {
    protected static final Set<Material> unacceptableSolidMaterials = ImmutableSet.of((Object)Material.field_215713_z, (Object)Material.field_215712_y, (Object)Material.field_151584_j, (Object)Material.field_151569_G, (Object)Material.field_151570_A, (Object)Material.field_151574_g, (Object[])new Material[]{Material.field_151572_C, Material.field_151568_F, Material.field_151566_D, Material.field_175972_I, Material.field_151568_F});

    public LakeWideShallow(Codec<BlockStateFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, BlockStateFeatureConfig configBlock) {
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double normZ;
                double normX;
                double lakeVal;
                int y;
                blockposMutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                BlockState blockState = world.func_180495_p((BlockPos)blockposMutable);
                Material material = blockState.func_185904_a();
                for (y = 5; (!material.func_76220_a() || unacceptableSolidMaterials.contains(material) || BlockTags.field_199898_b.func_230235_a_((Object)blockState.func_177230_c())) && y > 0; --y) {
                    material = world.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.DOWN)).func_185904_a();
                }
                boolean containedFlag = this.checkIfValidSpot(world, (BlockPos)blockposMutable);
                if (!containedFlag || !((lakeVal = (normX = (double)(x - 8) / 8.0) * normX + (normZ = (double)(z - 8) / 8.0) * normZ) < 0.8)) continue;
                blockState = world.func_180495_p(blockposMutable.func_177977_b());
                if (LakeWideShallow.func_227250_b_((Block)blockState.func_177230_c()) && random.nextInt(5) == 0) {
                    world.func_180501_a((BlockPos)blockposMutable, Blocks.field_203198_aQ.func_176223_P(), 3);
                } else {
                    world.func_180501_a((BlockPos)blockposMutable, configBlock.field_227270_a_, 3);
                }
                blockState = world.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP));
                while (blockposMutable.func_177956_o() < chunkGenerator.func_230355_e_() && !blockState.func_196955_c((IWorldReader)world, (BlockPos)blockposMutable)) {
                    world.func_180501_a((BlockPos)blockposMutable, Blocks.field_150350_a.func_176223_P(), 3);
                    blockState = world.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP));
                }
            }
        }
        return true;
    }

    private boolean checkIfValidSpot(ISeedReader world, BlockPos blockposMutable) {
        Material material;
        BlockState blockState;
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)blockposMutable);
        for (int x2 = -1; x2 <= 1; ++x2) {
            for (int z2 = -1; z2 <= 1; ++z2) {
                if (x2 == 0 && z2 == 0) continue;
                mutable.func_189533_g((Vector3i)blockposMutable).func_196234_d(x2, 0, z2);
                blockState = world.func_180495_p((BlockPos)mutable);
                material = blockState.func_185904_a();
                if (material.func_76220_a() && !(blockState.func_177230_c() instanceof HugeMushroomBlock) && !unacceptableSolidMaterials.contains(material) && !BlockTags.field_199898_b.func_230235_a_((Object)blockState.func_177230_c()) || !blockState.func_204520_s().func_206888_e() || blockState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                return false;
            }
        }
        blockState = world.func_180495_p((BlockPos)mutable.func_189533_g((Vector3i)blockposMutable).func_189536_c(Direction.DOWN));
        material = blockState.func_185904_a();
        if ((!material.func_76220_a() || unacceptableSolidMaterials.contains(material) || BlockTags.field_199898_b.func_230235_a_((Object)blockState.func_177230_c())) && blockState.func_204520_s().func_206888_e() && !blockState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) {
            return false;
        }
        blockState = world.func_180495_p((BlockPos)mutable.func_189534_c(Direction.UP, 2));
        material = blockState.func_185904_a();
        return !material.func_76220_a() && blockState.func_204520_s().func_206888_e() && blockState.func_177230_c() != Blocks.field_150448_aq;
    }
}

