/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.TwoBlockStateConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class NonLiquidWaterfall
extends Feature<TwoBlockStateConfig> {
    public NonLiquidWaterfall(Codec<TwoBlockStateConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, TwoBlockStateConfig config) {
        IChunk cachedChunk;
        BlockState blockState;
        BlockPos.Mutable blockposMutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        if (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, blockState = (cachedChunk = world.func_217349_x((BlockPos)blockposMutable)).func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP))) || !blockState.func_204520_s().func_206888_e()) {
            return false;
        }
        int numberOfSolidSides = 0;
        blockState = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189533_g((Vector3i)position).func_189536_c(Direction.DOWN));
        if (!blockState.func_204520_s().func_206888_e()) {
            return false;
        }
        int neededNumberOfSides = !GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, blockState) ? 4 : 3;
        Direction emptySpot = null;
        for (Direction face : Direction.Plane.HORIZONTAL) {
            blockposMutable.func_189533_g((Vector3i)position).func_189536_c(face);
            if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
            }
            if (!(blockState = cachedChunk.func_180495_p((BlockPos)blockposMutable)).func_204520_s().func_206888_e()) {
                return false;
            }
            if (GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, blockState)) {
                ++numberOfSolidSides;
                continue;
            }
            emptySpot = face;
        }
        if (numberOfSolidSides != neededNumberOfSides) {
            return false;
        }
        blockposMutable.func_189533_g((Vector3i)position);
        if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
            cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
        }
        cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state1, false);
        if (emptySpot != null) {
            blockposMutable.func_189536_c(emptySpot);
            if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
            }
            cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state1, false);
        }
        int ledgeOffsets = 0;
        while (blockposMutable.func_177956_o() > 1 && ledgeOffsets <= 3) {
            blockposMutable.func_189536_c(Direction.DOWN);
            BlockState belowBlockState = cachedChunk.func_180495_p((BlockPos)blockposMutable);
            if (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, belowBlockState) && belowBlockState.func_204520_s().func_206888_e()) {
                cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state1, false);
                continue;
            }
            blockposMutable.func_189536_c(Direction.UP);
            boolean deadEnd = true;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState sideBlockState;
                blockposMutable.func_189536_c(face);
                if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                    cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                }
                if (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, sideBlockState = cachedChunk.func_180495_p((BlockPos)blockposMutable)) && sideBlockState.func_204520_s().func_206888_e()) {
                    blockposMutable.func_189536_c(Direction.DOWN);
                    BlockState belowSideBlockState = cachedChunk.func_180495_p((BlockPos)blockposMutable);
                    if (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, belowSideBlockState) && belowSideBlockState.func_204520_s().func_206888_e()) {
                        blockposMutable.func_189536_c(Direction.UP);
                        cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state1, false);
                        cachedChunk.func_177436_a((BlockPos)blockposMutable.func_189536_c(Direction.DOWN), config.state1, false);
                        ++ledgeOffsets;
                        deadEnd = false;
                        if (blockposMutable.func_177956_o() > 1) break;
                        return false;
                    }
                    blockposMutable.func_189536_c(Direction.UP);
                }
                blockposMutable.func_189536_c(face.func_176734_d());
            }
            if (!deadEnd) continue;
            break;
        }
        position = blockposMutable.func_185334_h();
        int width = rand.nextInt(2) + 2;
        for (int y = -2; y < 0; ++y) {
            block4: for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    BlockState blockStateAtPuddlePos;
                    if (x * x + z * z > width * width) continue;
                    if (position.func_177956_o() + y <= 1 || position.func_177956_o() + y >= chunkGenerator.func_230355_e_()) continue block4;
                    blockposMutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    if (blockposMutable.func_177958_n() >> 4 != cachedChunk.func_76632_l().field_77276_a || blockposMutable.func_177952_p() >> 4 != cachedChunk.func_76632_l().field_77275_b) {
                        cachedChunk = world.func_217349_x((BlockPos)blockposMutable);
                    }
                    if (!GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, blockStateAtPuddlePos = cachedChunk.func_180495_p((BlockPos)blockposMutable)) && blockStateAtPuddlePos.func_204520_s().func_206888_e()) continue;
                    BlockState biomeTopBlock = world.func_226691_t_((BlockPos)blockposMutable).func_242440_e().func_242502_e().func_204108_a();
                    BlockState aboveBlockState = cachedChunk.func_180495_p((BlockPos)blockposMutable.func_189536_c(Direction.UP));
                    boolean isAboveFullCube = GeneralUtils.isFullCube(world, (BlockPos)blockposMutable, aboveBlockState);
                    blockposMutable.func_189536_c(Direction.DOWN);
                    if (blockStateAtPuddlePos == biomeTopBlock && !isAboveFullCube) {
                        cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state2, false);
                        if (!aboveBlockState.func_203425_a(Blocks.field_150433_aE)) continue;
                        cachedChunk.func_177436_a((BlockPos)blockposMutable, Blocks.field_150350_a.func_176223_P(), false);
                        continue;
                    }
                    if (config.state1.func_235714_a_((ITag)BlockTags.field_205213_E) && blockStateAtPuddlePos.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
                        cachedChunk.func_177436_a((BlockPos)blockposMutable, Blocks.field_150343_Z.func_176223_P(), false);
                        continue;
                    }
                    cachedChunk.func_177436_a((BlockPos)blockposMutable, config.state1, false);
                }
            }
            ++width;
        }
        return true;
    }
}

