/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.GeneralUtils;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import com.telepathicgrunt.ultraamplifieddimension.world.features.configs.PondConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class Pond
extends Feature<PondConfig> {
    protected OpenSimplexNoise noiseGen;
    protected long seed;

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGen == null) {
            this.noiseGen = new OpenSimplexNoise(seed);
            this.seed = seed;
        }
    }

    public Pond(Codec<PondConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos position, PondConfig pondConfig) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_181079_c(position.func_177958_n() >> 4 << 4, position.func_177956_o(), position.func_177952_p() >> 4 << 4);
        blockpos.func_196234_d(8, 0, 8);
        BlockPos centerPos = blockpos.func_185334_h();
        IChunk cachedChunk = world.func_217349_x((BlockPos)blockpos);
        for (int x = -7; x < 7; ++x) {
            for (int z = -7; z < 7; ++z) {
                for (int y = -3; y < 4; ++y) {
                    double normX = (double)x / 7.0;
                    double normY = (double)y / 4.0;
                    double normZ = (double)z / 7.0;
                    if (!(normX * normX + normY * normY + normZ * normZ <= 0.6)) continue;
                    blockpos.func_189533_g((Vector3i)centerPos).func_196234_d(x, y, z);
                    BlockState blockState = cachedChunk.func_180495_p((BlockPos)blockpos);
                    if (y >= 0 && !blockState.func_204520_s().func_206888_e()) {
                        return false;
                    }
                    if (GeneralUtils.isFullCube(world, (BlockPos)blockpos, blockState) || blockState == pondConfig.insideState) continue;
                    return false;
                }
            }
        }
        this.setSeed(world.func_72905_C());
        BlockState aboveState = null;
        for (int x = -8; x < 8; ++x) {
            for (int z = -8; z < 8; ++z) {
                for (int y = 4; y >= -4; --y) {
                    blockpos.func_189533_g((Vector3i)centerPos).func_196234_d(x, y, z);
                    double noiseVal = this.noiseGen.eval((double)blockpos.func_177958_n() * 0.21, (double)blockpos.func_177956_o() * 0.06, (double)blockpos.func_177952_p() * 0.21);
                    double normX = (double)x / 8.0;
                    double normY = (double)y / 4.0;
                    double normZ = (double)z / 8.0;
                    double lakeVal = normX * normX + normY * normY + normZ * normZ - (noiseVal + 1.0) * 0.9;
                    if (lakeVal < -0.065) {
                        BlockState blockState1 = cachedChunk.func_180495_p((BlockPos)blockpos);
                        if (y == 4) {
                            if (pondConfig.placeOutsideStateOften && GeneralUtils.isFullCube(world, (BlockPos)blockpos, blockState1) && rand.nextFloat() < 0.7f) {
                                aboveState = cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(Direction.UP));
                                blockpos.func_189536_c(Direction.DOWN);
                                if (aboveState.func_196958_f()) {
                                    cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.topState, false);
                                } else {
                                    cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.outsideState, false);
                                }
                            }
                            aboveState = cachedChunk.func_180495_p((BlockPos)blockpos);
                        }
                        if (!GeneralUtils.isFullCube(world, (BlockPos)blockpos, blockState1) && !blockState1.func_235714_a_((ITag)BlockTags.field_205213_E)) continue;
                        if (x == -8 || z == -8 || x == 7 || z == 7 || lakeVal > -0.48 || y == -4) {
                            if (pondConfig.placeOutsideStateOften) {
                                if (aboveState.func_196958_f() || aboveState.func_203425_a(Blocks.field_150433_aE)) {
                                    cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.topState, false);
                                } else {
                                    cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.outsideState, false);
                                }
                            }
                        } else if (y <= 0) {
                            cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.insideState, false);
                            for (Direction direction : Direction.values()) {
                                BlockState blockState;
                                if (direction != Direction.UP) {
                                    blockState = cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(direction));
                                    if (!GeneralUtils.isFullCube(world, (BlockPos)blockpos, blockState) && blockState != pondConfig.insideState) {
                                        cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.outsideState, false);
                                    }
                                    blockpos.func_189536_c(direction.func_176734_d());
                                    continue;
                                }
                                if (pondConfig.insideState.func_204520_s().func_206888_e()) continue;
                                blockState = cachedChunk.func_180495_p((BlockPos)blockpos.func_189536_c(direction));
                                if (!blockState.func_204520_s().func_206888_e() && blockState != pondConfig.insideState) {
                                    cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.outsideState, false);
                                }
                                blockpos.func_189536_c(direction.func_176734_d());
                            }
                        } else if (!aboveState.func_204520_s().func_206888_e()) {
                            cachedChunk.func_177436_a((BlockPos)blockpos, pondConfig.outsideState, false);
                        } else {
                            cachedChunk.func_177436_a((BlockPos)blockpos, Blocks.field_201941_jj.func_176223_P(), false);
                        }
                        BlockState plantCheckState = aboveState;
                        while (blockpos.func_177956_o() <= chunkGenerator.func_230355_e_() && !plantCheckState.func_200132_m() && !plantCheckState.func_196955_c((IWorldReader)world, (BlockPos)blockpos)) {
                            cachedChunk.func_177436_a((BlockPos)blockpos, Blocks.field_150350_a.func_176223_P(), false);
                            blockpos.func_189536_c(Direction.UP);
                            plantCheckState = cachedChunk.func_180495_p((BlockPos)blockpos);
                        }
                        continue;
                    }
                    aboveState = cachedChunk.func_180495_p((BlockPos)blockpos);
                }
                aboveState = null;
            }
        }
        return true;
    }
}

