/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features.configs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class NbtDungeonConfig
implements IFeatureConfig {
    public static final Codec<NbtDungeonConfig> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)Codec.BOOL.fieldOf("replace_air").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.replaceAir), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.minAirSpace), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxAirSpace), (App)Codec.intRange((int)0, (int)100).fieldOf("max_num_of_chests").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxNumOfChests), (App)Codec.BOOL.fieldOf("air_requirement_is_now_water").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.airRequirementIsNowWater), (App)Codec.INT.fieldOf("structure_y_offset").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.structureYOffset), (App)BlockState.field_235877_b_.fieldOf("loot_block").orElse((Object)Blocks.field_150486_ae.func_176223_P()).forGetter(nbtDungeonConfig -> nbtDungeonConfig.lootBlock), (App)ResourceLocation.field_240908_a_.fieldOf("chest_loottable_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.chestIdentifier), (App)Codec.mapPair((MapCodec)Registry.field_212629_r.fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("spawner_mob_entries").orElse(new ArrayList()).forGetter(nbtFeatureConfig -> nbtFeatureConfig.spawnerResourcelocationsAndWeights), (App)ResourceLocation.field_240908_a_.fieldOf("processors").forGetter(nbtDungeonConfig -> nbtDungeonConfig.processor), (App)ResourceLocation.field_240908_a_.fieldOf("post_processors").orElse((Object)new ResourceLocation("minecraft:empty")).forGetter(nbtDungeonConfig -> nbtDungeonConfig.postProcessor), (App)Codec.mapPair((MapCodec)ResourceLocation.field_240908_a_.fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("dungeon_nbt_entries").forGetter(nbtFeatureConfig -> nbtFeatureConfig.nbtResourcelocationsAndWeights)).apply((Applicative)configInstance, NbtDungeonConfig::new)).comapFlatMap(nbtDungeonConfig -> nbtDungeonConfig.maxAirSpace <= nbtDungeonConfig.minAirSpace ? DataResult.error((String)"min_air_space has to be smaller than max_air_space") : DataResult.success((Object)nbtDungeonConfig), Function.identity());
    public final boolean replaceAir;
    public final int minAirSpace;
    public final int maxAirSpace;
    public final int maxNumOfChests;
    public final ResourceLocation chestIdentifier;
    public final List<Pair<ResourceLocation, Integer>> nbtResourcelocationsAndWeights;
    public final List<Pair<EntityType<?>, Integer>> spawnerResourcelocationsAndWeights;
    public final ResourceLocation processor;
    public final ResourceLocation postProcessor;
    public final boolean airRequirementIsNowWater;
    public final int structureYOffset;
    public final BlockState lootBlock;

    public NbtDungeonConfig(boolean replaceAir, int minAirSpace, int maxAirSpace, int maxNumOfChests, boolean airRequirementIsNowWater, int structureYOffset, BlockState lootBlock, ResourceLocation chestIdentifier, List<Pair<EntityType<?>, Integer>> spawnerResourcelocationsAndWeights, ResourceLocation processor, ResourceLocation postProcessor, List<Pair<ResourceLocation, Integer>> nbtResourceLocationsAndWeights) {
        this.replaceAir = replaceAir;
        this.minAirSpace = minAirSpace;
        this.maxAirSpace = maxAirSpace;
        this.maxNumOfChests = maxNumOfChests;
        this.nbtResourcelocationsAndWeights = nbtResourceLocationsAndWeights;
        this.chestIdentifier = chestIdentifier;
        this.spawnerResourcelocationsAndWeights = spawnerResourcelocationsAndWeights;
        this.processor = processor;
        this.postProcessor = postProcessor;
        this.airRequirementIsNowWater = airRequirementIsNowWater;
        this.structureYOffset = structureYOffset;
        this.lootBlock = lootBlock;
    }
}

