/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.features.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADTreeDecoratorTypes;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;

public class DiskGroundDecorator
extends TreeDecorator {
    public static final Codec<DiskGroundDecorator> CODEC = RecordCodecBuilder.create(diskGroundDecorator -> diskGroundDecorator.group((App)BlockStateProvider.field_236796_a_.fieldOf("provider").forGetter(config -> config.blockStateProvider), (App)Codec.intRange((int)0, (int)36).fieldOf("radius").forGetter(config -> config.radius)).apply((Applicative)diskGroundDecorator, DiskGroundDecorator::new));
    private final BlockStateProvider blockStateProvider;
    private final int radius;

    public DiskGroundDecorator(BlockStateProvider blockStateProvider, int radius) {
        this.blockStateProvider = blockStateProvider;
        this.radius = radius;
    }

    protected TreeDecoratorType<?> func_230380_a_() {
        return (TreeDecoratorType)UADTreeDecoratorTypes.DISK_GROUND_DECORATOR.get();
    }

    public void func_225576_a_(ISeedReader world, Random random, List<BlockPos> trunkBlockPos, List<BlockPos> leavesBlockPos, Set<BlockPos> blockPosSet, MutableBoundingBox boundingBox) {
        int minY = trunkBlockPos.get(0).func_177956_o();
        trunkBlockPos.stream().filter(pos -> pos.func_177956_o() == minY).forEach(pos -> this.genBlob((IWorldGenerationReader)world, random, (BlockPos)pos));
    }

    private void genBlob(IWorldGenerationReader world, Random random, BlockPos centerBlockPos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                if (x * x + z * z > this.radius * this.radius) continue;
                this.setBlobBlock(world, random, (BlockPos)mutable.func_189533_g((Vector3i)centerBlockPos).func_196234_d(x, 0, z));
            }
        }
    }

    private void setBlobBlock(IWorldGenerationReader world, Random random, BlockPos startBlockPos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)startBlockPos).func_189534_c(Direction.UP, 2);
        for (int y = 2; y >= -3; --y) {
            if (Feature.func_236293_a_((IWorldGenerationBaseReader)world, (BlockPos)mutable)) {
                world.func_180501_a((BlockPos)mutable, this.blockStateProvider.func_225574_a_(random, startBlockPos), 19);
                break;
            }
            if (!Feature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)mutable) && y < 0) break;
            mutable.func_189536_c(Direction.DOWN);
        }
    }
}

