/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.structures;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADStructures;
import com.telepathicgrunt.ultraamplifieddimension.world.structures.AbstractBaseStructure;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class GenericJigsawStructure
extends AbstractBaseStructure {
    protected final ResourceLocation START_POOL;
    protected final int STRUCTURE_SIZE;
    protected final int PIECE_Y_OFFSET;
    protected final int BOUNDS_Y_OFFSET;
    protected final int FIXED_HEIGHT;
    protected final boolean SPAWN_AT_TOP_LAND;
    protected final int BIOME_RANGE;
    protected Pair<ChunkGenerator, List<Map.Entry<Structure<?>, StructureSeparationSettings>>> STRUCTURE_SPACING_CACHE = null;

    public GenericJigsawStructure(Codec<NoFeatureConfig> config, ResourceLocation poolRL, int structureSize, int pieceYOffset, int boundsYOffset, int fixedHeight, int biomeRange) {
        super(config);
        this.START_POOL = poolRL;
        this.STRUCTURE_SIZE = structureSize;
        this.PIECE_Y_OFFSET = pieceYOffset;
        this.BOUNDS_Y_OFFSET = boundsYOffset;
        this.FIXED_HEIGHT = fixedHeight;
        this.SPAWN_AT_TOP_LAND = false;
        this.BIOME_RANGE = biomeRange;
    }

    public GenericJigsawStructure(Codec<NoFeatureConfig> config, ResourceLocation poolRL, int structureSize, int pieceYOffset, int boundsYOffset, int biomeRange) {
        super(config);
        this.START_POOL = poolRL;
        this.STRUCTURE_SIZE = structureSize;
        this.PIECE_Y_OFFSET = pieceYOffset;
        this.BOUNDS_Y_OFFSET = boundsYOffset;
        this.FIXED_HEIGHT = -1;
        this.SPAWN_AT_TOP_LAND = true;
        this.BIOME_RANGE = biomeRange;
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig NoFeatureConfig2) {
        for (int curChunkX = chunkX - this.BIOME_RANGE; curChunkX <= chunkX + this.BIOME_RANGE; ++curChunkX) {
            for (int curChunkZ = chunkZ - this.BIOME_RANGE; curChunkZ <= chunkZ + this.BIOME_RANGE; ++curChunkZ) {
                if (curChunkX == chunkX || curChunkZ == chunkZ || biomeSource.func_225526_b_(curChunkX << 2, 60, curChunkZ << 2).func_242440_e().func_242493_a((Structure)this)) continue;
                return false;
            }
        }
        if (this.STRUCTURE_SPACING_CACHE == null || this.STRUCTURE_SPACING_CACHE.getFirst() != chunkGenerator) {
            this.STRUCTURE_SPACING_CACHE = new Pair((Object)chunkGenerator, chunkGenerator.func_235957_b_().func_236195_a_().entrySet().stream().filter(entry -> entry.getKey() != this && ((StructureSeparationSettings)entry.getValue()).func_236668_a_() > 6 && UADStructures.REGISTERED_UAD_STRUCTURES.contains(entry.getKey())).collect(Collectors.toList()));
        }
        int structureRange = 1;
        for (int curChunkX = chunkX - structureRange; curChunkX <= chunkX + structureRange; ++curChunkX) {
            for (int curChunkZ = chunkZ - structureRange; curChunkZ <= chunkZ + structureRange; ++curChunkZ) {
                for (Map.Entry spacingSettings : (List)this.STRUCTURE_SPACING_CACHE.getSecond()) {
                    ChunkPos structurePos = ((Structure)spacingSettings.getKey()).func_236392_a_((StructureSeparationSettings)spacingSettings.getValue(), seed, chunkRandom, chunkX, chunkZ);
                    if (structurePos.field_77276_a != curChunkX || structurePos.field_77275_b != curChunkZ) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            BlockPos blockpos = new BlockPos(chunkX * 16, GenericJigsawStructure.this.FIXED_HEIGHT, chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(GenericJigsawStructure.this.START_POOL), GenericJigsawStructure.this.STRUCTURE_SIZE), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)GenericJigsawStructure.this.SPAWN_AT_TOP_LAND);
            this.func_202500_a();
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, GenericJigsawStructure.this.PIECE_Y_OFFSET, 0));
            this.field_75075_a.forEach(piece -> piece.func_74874_b().field_78895_b += GenericJigsawStructure.this.BOUNDS_Y_OFFSET);
        }
    }
}

