/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.surfacebuilder;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.modInit.UADTags;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BadlandsSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected BlockState[] field_215432_a;
    protected long field_215433_b;
    protected PerlinNoiseGenerator field_215435_c;
    protected PerlinNoiseGenerator field_215437_d;
    protected PerlinNoiseGenerator field_215439_e;

    public BadlandsSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int xInChunk = x & 0xF;
        int zInChunk = z & 0xF;
        BlockState blockstate = Blocks.field_196777_fo.func_176223_P();
        BlockState blockstate1 = config.func_204109_b();
        int k = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        boolean flag = Math.cos(noise / 3.0 * Math.PI) > 0.0;
        int depth = -1;
        boolean flag1 = false;
        int i1 = 0;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        for (int y = startHeight; y >= 0; --y) {
            if (i1 >= 15) continue;
            blockpos$Mutable.func_181079_c(xInChunk, y, zInChunk);
            BlockState blockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (blockstate2.func_185904_a() == Material.field_151579_a) {
                depth = -1;
                continue;
            }
            if (blockstate2.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (depth == -1) {
                flag1 = false;
                if (k <= 0) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    blockstate1 = defaultBlock;
                } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                    blockstate = config.func_204110_c();
                    blockstate1 = config.func_204109_b();
                }
                if (y < seaLevel && blockstate.func_185904_a() == Material.field_151579_a) {
                    blockstate = defaultFluid;
                }
                depth = k + Math.max(0, y - seaLevel);
                if (y >= seaLevel - 1) {
                    if (y > seaLevel + 3 + k && chunkIn.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, config.func_204108_a(), false);
                        flag1 = true;
                    } else {
                        BlockState blockstate3 = y >= 64 && y <= 127 ? (flag ? Blocks.field_150405_ch.func_176223_P() : this.func_215431_a(x, y, z)) : Blocks.field_196778_fp.func_176223_P();
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, blockstate3, false);
                    }
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, blockstate1, false);
                    Block block = blockstate1.func_177230_c();
                    if (UADTags.TERRACOTTA_BLOCKS.func_230235_a_((Object)block)) {
                        chunkIn.func_177436_a((BlockPos)blockpos$Mutable, Blocks.field_196778_fp.func_176223_P(), false);
                    }
                }
            } else if (depth > 0) {
                --depth;
                if (flag1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, Blocks.field_196778_fp.func_176223_P(), false);
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, this.func_215431_a(x, y, z), false);
                }
            }
            ++i1;
        }
    }

    public void func_205548_a(long seed) {
        if (this.field_215433_b != seed || this.field_215432_a == null) {
            this.func_215430_b(seed);
        }
        if (this.field_215433_b != seed || this.field_215435_c == null || this.field_215437_d == null) {
            SharedSeedRandom random = new SharedSeedRandom(seed);
            this.field_215435_c = new PerlinNoiseGenerator(random, IntStream.rangeClosed(-3, 0));
            this.field_215437_d = new PerlinNoiseGenerator(random, (List)ImmutableList.of((Object)0));
        }
        this.field_215433_b = seed;
    }

    protected void func_215430_b(long p_215430_1_) {
        this.field_215432_a = new BlockState[64];
        Arrays.fill(this.field_215432_a, Blocks.field_150405_ch.func_176223_P());
        SharedSeedRandom random = new SharedSeedRandom(p_215430_1_);
        this.field_215439_e = new PerlinNoiseGenerator(random, (List)ImmutableList.of((Object)0));
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += random.nextInt(5) + 1) >= 64) continue;
            this.field_215432_a[l1] = Blocks.field_196778_fp.func_176223_P();
        }
        int i2 = random.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = random.nextInt(3) + 1;
            int k = random.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.field_215432_a[k + l] = Blocks.field_196783_fs.func_176223_P();
            }
        }
        int j2 = random.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = random.nextInt(3) + 2;
            int l3 = random.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.field_215432_a[l3 + i1] = Blocks.field_196719_fA.func_176223_P();
            }
        }
        int l2 = random.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = random.nextInt(3) + 1;
            int k4 = random.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.field_215432_a[k4 + j1] = Blocks.field_196721_fC.func_176223_P();
            }
        }
        int k3 = random.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            j4 += random.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.field_215432_a[j4 + k1] = Blocks.field_196777_fo.func_176223_P();
                if (j4 + k1 > 1 && random.nextBoolean()) {
                    this.field_215432_a[j4 + k1 - 1] = Blocks.field_196791_fw.func_176223_P();
                }
                if (j4 + k1 >= 63 || !random.nextBoolean()) continue;
                this.field_215432_a[j4 + k1 + 1] = Blocks.field_196791_fw.func_176223_P();
            }
        }
    }

    protected BlockState func_215431_a(int p_215431_1_, int p_215431_2_, int p_215431_3_) {
        int i = (int)Math.round(this.field_215439_e.func_215464_a((double)p_215431_1_ / 512.0, (double)p_215431_3_ / 512.0, false) * 2.0);
        return this.field_215432_a[(p_215431_2_ + i + 64) % 64];
    }
}

