/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.ultraamplifieddimension.world.surfacebuilder;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.ultraamplifieddimension.utils.OpenSimplexNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class NetherwastesSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long noiseSeed;
    protected OpenSimplexNoise noiseGen;

    public NetherwastesSurfaceBuilder(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void func_205548_a(long seed) {
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new OpenSimplexNoise(seed);
        }
        this.noiseSeed = seed;
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int sealevel = seaLevel + 1;
        int xInChunk = x & 0xF;
        int zInChunk = z & 0xF;
        int noiseDepth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        BlockPos.Mutable blockpos$MutableUnder = new BlockPos.Mutable();
        int depth = -1;
        BlockState topBlockstate = config.func_204108_a();
        BlockState bottomBlockstates = config.func_204108_a();
        for (int ypos = startHeight; ypos >= 0; --ypos) {
            blockpos$Mutable.func_181079_c(xInChunk, ypos, zInChunk);
            blockpos$MutableUnder.func_189533_g((Vector3i)blockpos$Mutable).func_189536_c(Direction.DOWN);
            BlockState currentBlockToReplace = chunkIn.func_180495_p((BlockPos)blockpos$Mutable);
            if (currentBlockToReplace.func_196958_f() || !currentBlockToReplace.func_204520_s().func_206888_e()) {
                depth = -1;
                continue;
            }
            if (currentBlockToReplace == Blocks.field_196814_hQ.func_176223_P()) continue;
            if (depth == -1) {
                boolean bottomBlockFlag;
                boolean bl = bottomBlockFlag = this.noiseGen.eval((double)x * 0.02 + 100.0, (float)ypos / 8.0f, (double)z * 0.02 - 100.0) > 0.45;
                if (noiseDepth <= 0) {
                    topBlockstate = Blocks.field_201941_jj.func_176223_P();
                    bottomBlockstates = config.func_204108_a();
                } else if (ypos >= sealevel - 4) {
                    boolean middleBlockFlag = this.noiseGen.eval((double)x * 0.015, (float)ypos / 7.0f, (double)z * 0.015) > 0.5;
                    topBlockstate = config.func_204108_a();
                    bottomBlockstates = config.func_204108_a();
                    if (middleBlockFlag) {
                        topBlockstate = config.func_204109_b();
                        bottomBlockstates = config.func_204109_b();
                    } else if (bottomBlockFlag) {
                        topBlockstate = config.func_204110_c();
                    } else if (noise > -3.85 && noise < -3.7 || noise > -0.1 && noise < 0.05 || noise > 3.7 && noise < 3.85) {
                        topBlockstate = Blocks.field_196814_hQ.func_176223_P();
                    }
                }
                depth = noiseDepth;
                if (ypos >= sealevel - 1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, topBlockstate, false);
                    if (!bottomBlockFlag || !chunkIn.func_180495_p((BlockPos)blockpos$MutableUnder).func_196958_f()) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$MutableUnder, config.func_204108_a(), false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlockstates, false);
                continue;
            }
            if (depth > 0) {
                --depth;
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlockstates, false);
                continue;
            }
            chunkIn.func_177436_a((BlockPos)blockpos$Mutable, config.func_204108_a(), false);
        }
    }
}

