/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.waterlogged_redstone.common.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class WaterloggedAbstractButtonBlock
extends HorizontalFaceBlock
implements IWaterLoggable {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape CEILING_AABB_X = Block.func_208617_a((double)6.0, (double)14.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape CEILING_AABB_Z = Block.func_208617_a((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape FLOOR_AABB_X = Block.func_208617_a((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0);
    protected static final VoxelShape FLOOR_AABB_Z = Block.func_208617_a((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)5.0, (double)6.0, (double)14.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)14.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)11.0);
    protected static final VoxelShape PRESSED_CEILING_AABB_X = Block.func_208617_a((double)6.0, (double)15.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape PRESSED_CEILING_AABB_Z = Block.func_208617_a((double)5.0, (double)15.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape PRESSED_FLOOR_AABB_X = Block.func_208617_a((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)1.0, (double)11.0);
    protected static final VoxelShape PRESSED_FLOOR_AABB_Z = Block.func_208617_a((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)1.0, (double)10.0);
    protected static final VoxelShape PRESSED_NORTH_AABB = Block.func_208617_a((double)5.0, (double)6.0, (double)15.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape PRESSED_SOUTH_AABB = Block.func_208617_a((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)1.0);
    protected static final VoxelShape PRESSED_WEST_AABB = Block.func_208617_a((double)15.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape PRESSED_EAST_AABB = Block.func_208617_a((double)0.0, (double)6.0, (double)5.0, (double)1.0, (double)10.0, (double)11.0);
    private final boolean sensitive;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    protected WaterloggedAbstractButtonBlock(boolean p_i48436_1_, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.sensitive = p_i48436_1_;
    }

    private int getPressDuration() {
        return this.sensitive ? 30 : 20;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction direction = (Direction)p_220053_1_.func_177229_b((Property)field_185512_D);
        boolean flag = (Boolean)p_220053_1_.func_177229_b((Property)POWERED);
        switch ((AttachFace)p_220053_1_.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                if (direction.func_176740_k() == Direction.Axis.X) {
                    return flag ? PRESSED_FLOOR_AABB_X : FLOOR_AABB_X;
                }
                return flag ? PRESSED_FLOOR_AABB_Z : FLOOR_AABB_Z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return flag ? PRESSED_EAST_AABB : EAST_AABB;
                    }
                    case WEST: {
                        return flag ? PRESSED_WEST_AABB : WEST_AABB;
                    }
                    case SOUTH: {
                        return flag ? PRESSED_SOUTH_AABB : SOUTH_AABB;
                    }
                }
                return flag ? PRESSED_NORTH_AABB : NORTH_AABB;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            return flag ? PRESSED_CEILING_AABB_X : CEILING_AABB_X;
        }
        return flag ? PRESSED_CEILING_AABB_Z : CEILING_AABB_Z;
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        FluidState fluidstate = p_196258_1_.func_195991_k().func_204610_c(p_196258_1_.func_195995_a());
        for (Direction direction : p_196258_1_.func_196009_e()) {
            BlockState blockstate = direction.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((Property)field_185512_D, (Comparable)p_196258_1_.func_195992_f()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)field_185512_D, (Comparable)direction.func_176734_d());
            if (!blockstate.func_196955_c((IWorldReader)p_196258_1_.func_195991_k(), p_196258_1_.func_195995_a())) continue;
            return blockstate;
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (((Boolean)p_225533_1_.func_177229_b((Property)POWERED)).booleanValue()) {
            return ActionResultType.CONSUME;
        }
        this.press(p_225533_1_, p_225533_2_, p_225533_3_);
        this.playSound(p_225533_4_, (IWorld)p_225533_2_, p_225533_3_, true);
        return ActionResultType.func_233537_a_((boolean)p_225533_2_.field_72995_K);
    }

    public void press(BlockState p_226910_1_, World p_226910_2_, BlockPos p_226910_3_) {
        p_226910_2_.func_180501_a(p_226910_3_, (BlockState)p_226910_1_.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbours(p_226910_1_, p_226910_2_, p_226910_3_);
        p_226910_2_.func_205220_G_().func_205360_a(p_226910_3_, (Object)this, this.getPressDuration());
    }

    protected void playSound(@Nullable PlayerEntity p_196367_1_, IWorld p_196367_2_, BlockPos p_196367_3_, boolean p_196367_4_) {
        p_196367_2_.func_184133_a((PlayerEntity)(p_196367_4_ ? p_196367_1_ : null), p_196367_3_, this.getSound(p_196367_4_), SoundCategory.BLOCKS, 0.3f, p_196367_4_ ? 0.6f : 0.5f);
    }

    protected abstract SoundEvent getSound(boolean var1);

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_5_ && !p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            if (((Boolean)p_196243_1_.func_177229_b((Property)POWERED)).booleanValue()) {
                this.updateNeighbours(p_196243_1_, p_196243_2_, p_196243_3_);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return (Boolean)p_180656_1_.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return (Boolean)p_176211_1_.func_177229_b((Property)POWERED) != false && WaterloggedAbstractButtonBlock.func_196365_i((BlockState)p_176211_1_) == p_176211_4_ ? 15 : 0;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (((Boolean)p_225534_1_.func_177229_b((Property)POWERED)).booleanValue()) {
            if (this.sensitive) {
                this.checkPressed(p_225534_1_, (World)p_225534_2_, p_225534_3_);
            } else {
                p_225534_2_.func_180501_a(p_225534_3_, (BlockState)p_225534_1_.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                this.updateNeighbours(p_225534_1_, (World)p_225534_2_, p_225534_3_);
                this.playSound(null, (IWorld)p_225534_2_, p_225534_3_, false);
            }
        }
    }

    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
        if (!p_196262_2_.field_72995_K && this.sensitive && !((Boolean)p_196262_1_.func_177229_b((Property)POWERED)).booleanValue()) {
            this.checkPressed(p_196262_1_, p_196262_2_, p_196262_3_);
        }
    }

    private void checkPressed(BlockState p_185616_1_, World p_185616_2_, BlockPos p_185616_3_) {
        boolean flag1;
        List list = p_185616_2_.func_217357_a(AbstractArrowEntity.class, p_185616_1_.func_196954_c((IBlockReader)p_185616_2_, p_185616_3_).func_197752_a().func_186670_a(p_185616_3_));
        boolean flag = !list.isEmpty();
        if (flag != (flag1 = ((Boolean)p_185616_1_.func_177229_b((Property)POWERED)).booleanValue())) {
            p_185616_2_.func_180501_a(p_185616_3_, (BlockState)p_185616_1_.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
            this.updateNeighbours(p_185616_1_, p_185616_2_, p_185616_3_);
            this.playSound(null, (IWorld)p_185616_2_, p_185616_3_, flag);
        }
        if (flag) {
            p_185616_2_.func_205220_G_().func_205360_a(new BlockPos((Vector3i)p_185616_3_), (Object)this, this.getPressDuration());
        }
    }

    private void updateNeighbours(BlockState p_196368_1_, World p_196368_2_, BlockPos p_196368_3_) {
        p_196368_2_.func_195593_d(p_196368_3_, (Block)this);
        p_196368_2_.func_195593_d(p_196368_3_.func_177972_a(WaterloggedAbstractButtonBlock.func_196365_i((BlockState)p_196368_1_).func_176734_d()), (Block)this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_185512_D, POWERED, field_196366_M, WATERLOGGED});
    }
}

