/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.waterlogged_redstone.common.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.the_millman.waterlogged_redstone.common.blocks.WaterloggedRepeater;
import com.the_millman.waterlogged_redstone.core.init.BlockInit;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.ObserverBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WaterloggedRedstoneWire
extends Block
implements IWaterLoggable {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape SHAPE_DOT = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.NORTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.SOUTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.EAST), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.WEST), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vector3f[] COLORS = new Vector3f[16];
    private final BlockState crossState;
    private boolean shouldSignal = true;

    public WaterloggedRedstoneWire(AbstractBlock.Properties p_i48344_1_) {
        super(p_i48344_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(EAST, (Comparable)RedstoneSide.SIDE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockstate : this.func_176194_O().func_177619_a()) {
            if ((Integer)blockstate.func_177229_b((Property)POWER) != 0) continue;
            this.SHAPES_CACHE.put(blockstate, this.calculateShape(blockstate));
        }
    }

    private VoxelShape calculateShape(BlockState p_235554_1_) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)p_235554_1_.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return this.SHAPES_CACHE.get(state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        FluidState fluidstate = p_196258_1_.func_195991_k().func_204610_c(p_196258_1_.func_195995_a());
        return (BlockState)this.getConnectionState((IBlockReader)p_196258_1_.func_195991_k(), this.crossState, p_196258_1_.func_195995_a()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }

    private BlockState getConnectionState(IBlockReader p_235544_1_, BlockState state, BlockPos p_235544_3_) {
        boolean flag6;
        boolean flag = WaterloggedRedstoneWire.isDot(state);
        state = this.getMissingConnections(p_235544_1_, (BlockState)this.func_176223_P().func_206870_a((Property)POWER, state.func_177229_b((Property)POWER)), p_235544_3_);
        if (flag && WaterloggedRedstoneWire.isDot(state)) {
            return state;
        }
        boolean flag1 = ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_();
        boolean flag2 = ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_();
        boolean flag3 = ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_();
        boolean flag4 = ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
        boolean flag5 = !flag1 && !flag2;
        boolean bl = flag6 = !flag3 && !flag4;
        if (!flag4 && flag5) {
            state = (BlockState)state.func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag3 && flag5) {
            state = (BlockState)state.func_206870_a(EAST, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag1 && flag6) {
            state = (BlockState)state.func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE);
        }
        if (!flag2 && flag6) {
            state = (BlockState)state.func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE);
        }
        return state;
    }

    private BlockState getMissingConnections(IBlockReader p_235551_1_, BlockState state, BlockPos p_235551_3_) {
        boolean flag = !p_235551_1_.func_180495_p(p_235551_3_.func_177984_a()).func_215686_e(p_235551_1_, p_235551_3_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(p_235551_1_, p_235551_3_, direction, flag);
            state = (BlockState)state.func_206870_a((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    public boolean func_204510_a(IBlockReader p_204510_1_, BlockPos p_204510_2_, BlockState p_204510_3_, Fluid p_204510_4_) {
        return false;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState p_204509_3_, FluidState p_204509_4_) {
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (p_196271_2_ == Direction.DOWN) {
            return state;
        }
        if (p_196271_2_ == Direction.UP) {
            return this.getConnectionState((IBlockReader)p_196271_4_, state, p_196271_5_);
        }
        RedstoneSide redstoneside = this.getConnectingSide((IBlockReader)p_196271_4_, p_196271_5_, p_196271_2_);
        return redstoneside.func_235921_b_() == ((RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(p_196271_2_))).func_235921_b_() && !WaterloggedRedstoneWire.isCross(state) ? (BlockState)state.func_206870_a((Property)PROPERTY_BY_DIRECTION.get(p_196271_2_), (Comparable)redstoneside) : this.getConnectionState((IBlockReader)p_196271_4_, (BlockState)((BlockState)this.crossState.func_206870_a((Property)POWER, state.func_177229_b((Property)POWER))).func_206870_a((Property)PROPERTY_BY_DIRECTION.get(p_196271_2_), (Comparable)redstoneside), p_196271_5_);
    }

    private static boolean isCross(BlockState state) {
        return ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    private static boolean isDot(BlockState state) {
        return !((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    public void func_196248_b(BlockState state, IWorld p_196248_2_, BlockPos p_196248_3_, int p_196248_4_, int p_196248_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || p_196248_2_.func_180495_p((BlockPos)blockpos$mutable.func_239622_a_((Vector3i)p_196248_3_, direction)).func_203425_a((Block)this)) continue;
            blockpos$mutable.func_189536_c(Direction.DOWN);
            BlockState blockstate = p_196248_2_.func_180495_p((BlockPos)blockpos$mutable);
            if (!blockstate.func_203425_a(Blocks.field_190976_dk)) {
                BlockPos blockpos = blockpos$mutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), p_196248_2_.func_180495_p(blockpos), p_196248_2_, (BlockPos)blockpos$mutable, blockpos);
                WaterloggedRedstoneWire.func_241468_a_((BlockState)blockstate, (BlockState)blockstate1, (IWorld)p_196248_2_, (BlockPos)blockpos$mutable, (int)p_196248_4_, (int)p_196248_5_);
            }
            blockpos$mutable.func_239622_a_((Vector3i)p_196248_3_, direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = p_196248_2_.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate3.func_203425_a(Blocks.field_190976_dk)) continue;
            BlockPos blockpos1 = blockpos$mutable.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), p_196248_2_.func_180495_p(blockpos1), p_196248_2_, (BlockPos)blockpos$mutable, blockpos1);
            WaterloggedRedstoneWire.func_241468_a_((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)p_196248_2_, (BlockPos)blockpos$mutable, (int)p_196248_4_, (int)p_196248_5_);
        }
    }

    private RedstoneSide getConnectingSide(IBlockReader p_208074_1_, BlockPos p_208074_2_, Direction p_208074_3_) {
        return this.getConnectingSide(p_208074_1_, p_208074_2_, p_208074_3_, !p_208074_1_.func_180495_p(p_208074_2_.func_177984_a()).func_215686_e(p_208074_1_, p_208074_2_));
    }

    private RedstoneSide getConnectingSide(IBlockReader p_235545_1_, BlockPos p_235545_2_, Direction p_235545_3_, boolean p_235545_4_) {
        boolean flag;
        BlockPos blockpos = p_235545_2_.func_177972_a(p_235545_3_);
        BlockState blockstate = p_235545_1_.func_180495_p(blockpos);
        if (p_235545_4_ && (flag = this.canSurviveOn(p_235545_1_, blockpos, blockstate)) && WaterloggedRedstoneWire.canConnectTo(p_235545_1_.func_180495_p(blockpos.func_177984_a()), p_235545_1_, blockpos.func_177984_a(), null)) {
            if (blockstate.func_224755_d(p_235545_1_, blockpos, p_235545_3_.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !WaterloggedRedstoneWire.canConnectTo(blockstate, p_235545_1_, blockpos, p_235545_3_) && (blockstate.func_215686_e(p_235545_1_, blockpos) || !WaterloggedRedstoneWire.canConnectTo(p_235545_1_.func_180495_p(blockpos.func_177977_b()), p_235545_1_, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.func_177977_b();
        BlockState blockstate = p_196260_2_.func_180495_p(blockpos);
        return this.canSurviveOn((IBlockReader)p_196260_2_, blockpos, blockstate);
    }

    private boolean canSurviveOn(IBlockReader p_235552_1_, BlockPos p_235552_2_, BlockState state) {
        return state.func_224755_d(p_235552_1_, p_235552_2_, Direction.UP) || state.func_203425_a(Blocks.field_150438_bZ);
    }

    private void updatePowerStrength(World p_235547_1_, BlockPos p_235547_2_, BlockState state) {
        int i = this.calculateTargetStrength(p_235547_1_, p_235547_2_);
        if ((Integer)state.func_177229_b((Property)POWER) != i) {
            if (p_235547_1_.func_180495_p(p_235547_2_) == state) {
                p_235547_1_.func_180501_a(p_235547_2_, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(p_235547_2_);
            for (Direction direction : Direction.values()) {
                set.add(p_235547_2_.func_177972_a(direction));
            }
            for (BlockPos blockpos : set) {
                p_235547_1_.func_195593_d(blockpos, (Block)this);
            }
        }
    }

    private int calculateTargetStrength(World p_235546_1_, BlockPos p_235546_2_) {
        this.shouldSignal = false;
        int i = p_235546_1_.func_175687_A(p_235546_2_);
        this.shouldSignal = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = p_235546_2_.func_177972_a(direction);
                BlockState blockstate = p_235546_1_.func_180495_p(blockpos);
                j = Math.max(j, this.getWireSignal(blockstate));
                BlockPos blockpos1 = p_235546_2_.func_177984_a();
                if (blockstate.func_215686_e((IBlockReader)p_235546_1_, blockpos) && !p_235546_1_.func_180495_p(blockpos1).func_215686_e((IBlockReader)p_235546_1_, blockpos1)) {
                    j = Math.max(j, this.getWireSignal(p_235546_1_.func_180495_p(blockpos.func_177984_a())));
                    continue;
                }
                if (blockstate.func_215686_e((IBlockReader)p_235546_1_, blockpos)) continue;
                j = Math.max(j, this.getWireSignal(p_235546_1_.func_180495_p(blockpos.func_177977_b())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int getWireSignal(BlockState state) {
        return state.func_203425_a((Block)this) ? (Integer)state.func_177229_b((Property)POWER) : 0;
    }

    private void checkCornerChangeAt(World p_176344_1_, BlockPos p_176344_2_) {
        if (p_176344_1_.func_180495_p(p_176344_2_).func_203425_a((Block)this)) {
            p_176344_1_.func_195593_d(p_176344_2_, (Block)this);
            for (Direction direction : Direction.values()) {
                p_176344_1_.func_195593_d(p_176344_2_.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState blockState, boolean bool) {
        if (!blockState.func_203425_a(state.func_177230_c()) && !world.field_72995_K) {
            this.updatePowerStrength(world, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                world.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    public void func_196243_a(BlockState state, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_5_ && !state.func_203425_a(p_196243_4_.func_177230_c())) {
            super.func_196243_a(state, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
            if (!p_196243_2_.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    p_196243_2_.func_195593_d(p_196243_3_.func_177972_a(direction), (Block)this);
                }
                this.updatePowerStrength(p_196243_2_, p_196243_3_, state);
                this.updateNeighborsOfNeighboringWires(p_196243_2_, p_196243_3_);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(World p_235553_1_, BlockPos p_235553_2_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(p_235553_1_, p_235553_2_.func_177972_a(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_235553_2_.func_177972_a(direction1);
            if (p_235553_1_.func_180495_p(blockpos).func_215686_e((IBlockReader)p_235553_1_, blockpos)) {
                this.checkCornerChangeAt(p_235553_1_, blockpos.func_177984_a());
                continue;
            }
            this.checkCornerChangeAt(p_235553_1_, blockpos.func_177977_b());
        }
    }

    public void func_220069_a(BlockState state, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.field_72995_K) {
            if (state.func_196955_c((IWorldReader)p_220069_2_, p_220069_3_)) {
                this.updatePowerStrength(p_220069_2_, p_220069_3_, state);
            } else {
                WaterloggedRedstoneWire.func_220075_c((BlockState)state, (World)p_220069_2_, (BlockPos)p_220069_3_);
                p_220069_2_.func_217377_a(p_220069_3_, false);
            }
        }
    }

    public int func_176211_b(BlockState state, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return !this.shouldSignal ? 0 : state.func_185911_a(p_176211_2_, p_176211_3_, p_176211_4_);
    }

    public int func_180656_a(BlockState state, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        if (this.shouldSignal && p_180656_4_ != Direction.DOWN) {
            int i = (Integer)state.func_177229_b((Property)POWER);
            if (i == 0) {
                return 0;
            }
            return p_180656_4_ != Direction.UP && !((RedstoneSide)this.getConnectionState(p_180656_2_, state, p_180656_3_).func_177229_b((Property)PROPERTY_BY_DIRECTION.get(p_180656_4_.func_176734_d()))).func_235921_b_() ? 0 : i;
        }
        return 0;
    }

    protected static boolean canConnectTo(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction directionIn) {
        if (state.func_203425_a((Block)BlockInit.WATERLOGGED_REDSTONE_WIRE.get())) {
            return true;
        }
        if (state.func_203425_a((Block)BlockInit.WATERLOGGED_REPEATER.get())) {
            Direction direction = (Direction)state.func_177229_b((Property)WaterloggedRepeater.field_185512_D);
            return direction == directionIn || direction.func_176734_d() == directionIn;
        }
        if (state.func_203425_a(Blocks.field_190976_dk)) {
            return directionIn == state.func_177229_b((Property)ObserverBlock.field_176387_N);
        }
        if (state.func_203425_a(Blocks.field_150488_af)) {
            return true;
        }
        return state.canConnectRedstone(world, pos, directionIn) && directionIn != null;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return this.shouldSignal;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColorForPower(int p_235550_0_) {
        Vector3f vector3f = COLORS[p_235550_0_];
        return MathHelper.func_180183_b((float)vector3f.func_195899_a(), (float)vector3f.func_195900_b(), (float)vector3f.func_195902_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticlesAlongLine(World p_235549_1_, Random p_235549_2_, BlockPos p_235549_3_, Vector3f p_235549_4_, Direction p_235549_5_, Direction p_235549_6_, float p_235549_7_, float p_235549_8_) {
        float f = p_235549_8_ - p_235549_7_;
        if (!(p_235549_2_.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = p_235549_7_ + f * p_235549_2_.nextFloat();
            double d0 = 0.5 + (double)(0.4375f * (float)p_235549_5_.func_82601_c()) + (double)(f2 * (float)p_235549_6_.func_82601_c());
            double d1 = 0.5 + (double)(0.4375f * (float)p_235549_5_.func_96559_d()) + (double)(f2 * (float)p_235549_6_.func_96559_d());
            double d2 = 0.5 + (double)(0.4375f * (float)p_235549_5_.func_82599_e()) + (double)(f2 * (float)p_235549_6_.func_82599_e());
            p_235549_1_.func_195594_a((IParticleData)new RedstoneParticleData(p_235549_4_.func_195899_a(), p_235549_4_.func_195900_b(), p_235549_4_.func_195902_c(), 1.0f), (double)p_235549_3_.func_177958_n() + d0, (double)p_235549_3_.func_177956_o() + d1, (double)p_235549_3_.func_177952_p() + d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        int i = (Integer)p_180655_1_.func_177229_b((Property)POWER);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)p_180655_1_.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(p_180655_2_, p_180655_4_, p_180655_3_, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(p_180655_2_, p_180655_4_, p_180655_3_, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(p_180655_2_, p_180655_4_, p_180655_3_, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        switch (p_185499_2_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(NORTH, p_185499_1_.func_177229_b(SOUTH))).func_206870_a(EAST, p_185499_1_.func_177229_b(WEST))).func_206870_a(SOUTH, p_185499_1_.func_177229_b(NORTH))).func_206870_a(WEST, p_185499_1_.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(NORTH, p_185499_1_.func_177229_b(EAST))).func_206870_a(EAST, p_185499_1_.func_177229_b(SOUTH))).func_206870_a(SOUTH, p_185499_1_.func_177229_b(WEST))).func_206870_a(WEST, p_185499_1_.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.func_206870_a(NORTH, p_185499_1_.func_177229_b(WEST))).func_206870_a(EAST, p_185499_1_.func_177229_b(NORTH))).func_206870_a(SOUTH, p_185499_1_.func_177229_b(EAST))).func_206870_a(WEST, p_185499_1_.func_177229_b(SOUTH));
            }
        }
        return p_185499_1_;
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        switch (p_185471_2_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_185471_1_.func_206870_a(NORTH, p_185471_1_.func_177229_b(SOUTH))).func_206870_a(SOUTH, p_185471_1_.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_185471_1_.func_206870_a(EAST, p_185471_1_.func_177229_b(WEST))).func_206870_a(WEST, p_185471_1_.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(p_185471_1_, p_185471_2_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, POWER, WATERLOGGED});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        if (WaterloggedRedstoneWire.isCross(state) || WaterloggedRedstoneWire.isDot(state)) {
            BlockState blockstate = WaterloggedRedstoneWire.isCross(state) ? this.func_176223_P() : this.crossState;
            blockstate = (BlockState)blockstate.func_206870_a((Property)POWER, state.func_177229_b((Property)POWER));
            if ((blockstate = this.getConnectionState((IBlockReader)world, blockstate, blockPos)) != state) {
                world.func_180501_a(blockPos, blockstate, 3);
                this.updatesOnShapeChange(world, blockPos, state, blockstate);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void updatesOnShapeChange(World p_235548_1_, BlockPos p_235548_2_, BlockState p_235548_3_, BlockState p_235548_4_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_235548_2_.func_177972_a(direction);
            if (((RedstoneSide)p_235548_3_.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_() == ((RedstoneSide)p_235548_4_.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_() || !p_235548_1_.func_180495_p(blockpos).func_215686_e((IBlockReader)p_235548_1_, blockpos)) continue;
            p_235548_1_.func_175695_a(blockpos, p_235548_4_.func_177230_c(), direction.func_176734_d());
        }
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f = (float)i / 15.0f;
            float f1 = MathHelper.func_76131_a((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f2 = f * 0.6f + (f > 0.0f ? 0.4f : 0.3f);
            float f3 = MathHelper.func_76131_a((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            WaterloggedRedstoneWire.COLORS[i] = new Vector3f(f1, f2, f3);
        }
    }
}

