/*
 * Decompiled with CFR 0.152.
 */
package com.ladestitute.zarrowsandstuff.blocks.natural.plants.hydromelon;

import com.ladestitute.zarrowsandstuff.registries.BlockInit;
import com.ladestitute.zarrowsandstuff.registries.ItemInit;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class HydromelonStemBlock
extends StemBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)};
    private final StemGrownBlock crop;

    public HydromelonStemBlock(StemGrownBlock crop, AbstractBlock.Properties properties) {
        super(crop, properties);
        this.crop = crop;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)AGE)];
    }

    protected boolean isValidFarmGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150458_ak);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150349_c);
    }

    protected boolean isValidSandGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150354_m);
    }

    public float getHydroGrowthChance(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (blockstate.canSustainPlant(worldIn, blockpos.func_177982_a(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(worldIn, pos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        float f;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = this.getHydroGrowthChance((Block)this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)state.func_177229_b((Property)AGE);
            if (i < 7) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177977_b());
                Block block = blockstate.func_177230_c();
                if (worldIn.func_175623_d(blockpos) && (blockstate.canSustainPlant((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP, (IPlantable)this) || block == Blocks.field_150458_ak || block == Blocks.field_150354_m || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_196658_i)) {
                    worldIn.func_175656_a(blockpos, this.crop.func_176223_P());
                    worldIn.func_175656_a(pos, (BlockState)this.crop.func_196523_e().func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction));
                }
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    protected Item func_176481_j() {
        return this.crop == BlockInit.HYDROMELON.get() ? (Item)ItemInit.HYDROMELON_SEED.get() : null;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        Item item = this.func_176481_j();
        return item == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) != 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = Math.min(7, (Integer)state.func_177229_b((Property)AGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5));
        BlockState blockstate = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i));
        worldIn.func_180501_a(pos, blockstate, 2);
        if (i == 7) {
            blockstate.func_227034_b_(worldIn, pos, worldIn.field_73012_v);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public StemGrownBlock func_208486_d() {
        return this.crop;
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.CROP;
    }
}

