/*
 * Decompiled with CFR 0.152.
 */
package com.ladestitute.zarrowsandstuff.util.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ZConfigManager {
    private static final ZConfigManager INSTANCE;
    private static final ForgeConfigSpec SPEC;
    private static final Path CONFIG_PATH;
    private final ForgeConfigSpec.BooleanValue alwaysShowStamina;
    private final ForgeConfigSpec.BooleanValue alwaysShowTemp;
    private final ForgeConfigSpec.BooleanValue selfShockArrowImmunity;
    private final ForgeConfigSpec.BooleanValue experimentalFeatures;
    private final ForgeConfigSpec.IntValue ArmorSetCount;
    public final ForgeConfigSpec.IntValue modFoodStackSize;
    private final ForgeConfigSpec.BooleanValue addoptionaltrades;
    private final ForgeConfigSpec.BooleanValue generatemodplants;
    private final ForgeConfigSpec.BooleanValue icearrowsfrostedice;
    private final ForgeConfigSpec.BooleanValue usecryostone;
    private final ForgeConfigSpec.BooleanValue allowfirearrowdot;
    public final ForgeConfigSpec.IntValue damagescaling;
    private final ForgeConfigSpec.IntValue foodCooldown;
    private final ForgeConfigSpec.BooleanValue oneshotblazes;
    private final ForgeConfigSpec.BooleanValue enableTemperatureSystem;
    private final ForgeConfigSpec.BooleanValue allowTierOneBiomes;
    private final ForgeConfigSpec.BooleanValue resistpotioncooldown;
    public final ForgeConfigSpec.IntValue tempDamage;
    private final ForgeConfigSpec.IntValue campfireDuration;
    private final ForgeConfigSpec.BooleanValue allowFoodHealing;
    private final ForgeConfigSpec.BooleanValue gradualCampfireEffect;
    public final ForgeConfigSpec.IntValue mountainYLevel;
    private final ForgeConfigSpec.IntValue defaultTempTimerThreshold;
    private final ForgeConfigSpec.BooleanValue undergroundOreDeposits;
    private final ForgeConfigSpec.BooleanValue renewableOreDeposits;

    private ZConfigManager(ForgeConfigSpec.Builder configSpecBuilder) {
        this.alwaysShowStamina = configSpecBuilder.translation("zarrowsandstuff.configGui.alwaysshowstamina.title").define("alwaysshowstamina", false);
        this.alwaysShowTemp = configSpecBuilder.translation("zarrowsandstuff.configGui.alwaysshowstemp.title").define("alwaysshowtemp", true);
        this.selfShockArrowImmunity = configSpecBuilder.translation("zarrowsandstuff.configGui.selfshock.title").define("selfshock", false);
        this.experimentalFeatures = configSpecBuilder.translation("zarrowsandstuff.configGui.experimental.title").define("experimental", false);
        this.ArmorSetCount = configSpecBuilder.translation("zarrowsandstuff.configGui.armorsetcount.title").defineInRange("armorsetcount", 3, 3, 4);
        this.modFoodStackSize = configSpecBuilder.translation("zarrowsandstuff.configGui.modfoodstacksize.title").defineInRange("modfoodstacksize", 1, 1, 16);
        this.resistpotioncooldown = configSpecBuilder.translation("zarrowsandstuff.configGui.resistpotioncooldown.title").define("resistpotioncooldown", true);
        this.addoptionaltrades = configSpecBuilder.translation("zarrowsandstuff.configGui.addoptionaltrades.title").define("addoptionaltrades", true);
        this.generatemodplants = configSpecBuilder.translation("zarrowsandstuff.configGui.generatemodplants.title").define("generatemodplants", true);
        this.icearrowsfrostedice = configSpecBuilder.translation("zarrowsandstuff.configGui.icearrowsfrostedice.title").define("icearrowsfrostedice", false);
        this.usecryostone = configSpecBuilder.translation("zarrowsandstuff.configGui.usecryostone.title").define("usecryostone", true);
        this.allowfirearrowdot = configSpecBuilder.translation("zarrowsandstuff.configGui.allowfirearrowdot.title").define("allowfirearrowdot", false);
        this.damagescaling = configSpecBuilder.translation("zarrowsandstuff.configGui.damagescaling.title").defineInRange("damagescaling", 1, 0, 2);
        this.foodCooldown = configSpecBuilder.translation("zarrowsandstuff.configGui.foodcooldown.title").defineInRange("foodcooldown", 600, 0, 1200);
        this.oneshotblazes = configSpecBuilder.translation("zarrowsandstuff.configGui.oneshotblazes.title").define("oneshotblazes", false);
        this.enableTemperatureSystem = configSpecBuilder.translation("zarrowsandstuff.configGui.enabletemperaturesystem.title").define("enabletemperaturesystem", true);
        this.allowTierOneBiomes = configSpecBuilder.translation("zarrowsandstuff.configGui.allowtieronebiomes.title").define("allowtieronebiomes", true);
        this.campfireDuration = configSpecBuilder.translation("zarrowsandstuff.configGui.campfireduration.title").defineInRange("campfireduration", 1200, 600, 3000);
        this.tempDamage = configSpecBuilder.translation("zarrowsandstuff.configGui.tempdamage.title").defineInRange("tempdamage", 2, 1, 10);
        this.allowFoodHealing = configSpecBuilder.translation("zarrowsandstuff.configGui.allowfoodhealing.title").define("allowfoodhealing", true);
        this.gradualCampfireEffect = configSpecBuilder.translation("zarrowsandstuff.configGui.gradualcampfireeffect.title").define("gradualcampfireeffect", true);
        this.mountainYLevel = configSpecBuilder.translation("zarrowsandstuff.configGui.mountainylevel.title").defineInRange("mountainylevel", 100, 87, 123);
        this.defaultTempTimerThreshold = configSpecBuilder.translation("zarrowsandstuff.configGui.defaulttemptimerthreshold.title").defineInRange("defaulttemptimerthreshold", 200, 100, 400);
        this.undergroundOreDeposits = configSpecBuilder.translation("zarrowsandstuff.configGui.undergroundore.title").define("undergroundore", true);
        this.renewableOreDeposits = configSpecBuilder.translation("zarrowsandstuff.configGui.renewableore.title").define("renewableore", true);
    }

    public static ZConfigManager getInstance() {
        return INSTANCE;
    }

    public boolean selfShockArrowImmunity() {
        return (Boolean)this.selfShockArrowImmunity.get();
    }

    public boolean experimentalFeatures() {
        return (Boolean)this.experimentalFeatures.get();
    }

    public int armorSetCount() {
        return (Integer)this.ArmorSetCount.get();
    }

    public boolean alwaysshowStamina() {
        return (Boolean)this.alwaysShowStamina.get();
    }

    public boolean alwaysshowTemp() {
        return (Boolean)this.alwaysShowTemp.get();
    }

    public int modfoodstacksize() {
        return (Integer)this.modFoodStackSize.get();
    }

    public boolean resistPotioncooldown() {
        return (Boolean)this.resistpotioncooldown.get();
    }

    public boolean addoptionaltrades() {
        return (Boolean)this.addoptionaltrades.get();
    }

    public boolean generatemodplants() {
        return (Boolean)this.generatemodplants.get();
    }

    public boolean icearrowsfrostedice() {
        return (Boolean)this.icearrowsfrostedice.get();
    }

    public boolean useCryostone() {
        return (Boolean)this.usecryostone.get();
    }

    public int damageScaling() {
        return (Integer)this.damagescaling.get();
    }

    public boolean allowFireArrowDOT() {
        return (Boolean)this.allowfirearrowdot.get();
    }

    public int foodCooldown() {
        return (Integer)this.foodCooldown.get();
    }

    public boolean oneshotblazes() {
        return (Boolean)this.oneshotblazes.get();
    }

    public boolean allowfoodhealing() {
        return (Boolean)this.allowFoodHealing.get();
    }

    public int campfireDuration() {
        return (Integer)this.campfireDuration.get();
    }

    public int tempDamage() {
        return (Integer)this.tempDamage.get();
    }

    public boolean enableTemperatureSystem() {
        return (Boolean)this.enableTemperatureSystem.get();
    }

    public boolean allowTierOneBiomes() {
        return (Boolean)this.allowTierOneBiomes.get();
    }

    public int mountainYLevel() {
        return (Integer)this.mountainYLevel.get();
    }

    public int defaultTempTimerThreshold() {
        return (Integer)this.defaultTempTimerThreshold.get();
    }

    public boolean undergroundOreDeposits() {
        return (Boolean)this.undergroundOreDeposits.get();
    }

    public boolean renewableOreDeposits() {
        return (Boolean)this.renewableOreDeposits.get();
    }

    public void changeSelfShockArrowImmunity(boolean newValue) {
        this.selfShockArrowImmunity.set((Object)newValue);
    }

    public void changeExperimentalFeatures(boolean newValue) {
        this.experimentalFeatures.set((Object)newValue);
    }

    public void changeArmorSetCount(int newValue) {
        this.ArmorSetCount.set((Object)newValue);
    }

    public void changeModFoodStackSize(int newValue) {
        this.modFoodStackSize.set((Object)newValue);
    }

    public void changeAddOptionalTrades(boolean newValue) {
        this.addoptionaltrades.set((Object)newValue);
    }

    public void changeresistpotioncooldown(boolean newValue) {
        this.resistpotioncooldown.set((Object)newValue);
    }

    public void changeGeneratemodplants(boolean newValue) {
        this.generatemodplants.set((Object)newValue);
    }

    public void changeIceArrowsFrostedIce(boolean newValue) {
        this.icearrowsfrostedice.set((Object)newValue);
    }

    public void changeUsecryostone(boolean newValue) {
        this.usecryostone.set((Object)newValue);
    }

    public void changeAllowFireArrowDOT(boolean newValue) {
        this.allowfirearrowdot.set((Object)newValue);
    }

    public void changeDamagescaling(int newValue) {
        this.damagescaling.set((Object)newValue);
    }

    public void changeFoodCooldown(int newValue) {
        this.foodCooldown.set((Object)newValue);
    }

    public void changeOneshotblazes(boolean newValue) {
        this.oneshotblazes.set((Object)newValue);
    }

    public void enableTemperatureSystem(boolean newValue) {
        this.enableTemperatureSystem.set((Object)newValue);
    }

    public void changeAllowTierOneBiomes(boolean newValue) {
        this.allowTierOneBiomes.set((Object)newValue);
    }

    public void showStamina(boolean newValue) {
        this.alwaysShowStamina.set((Object)newValue);
    }

    public void changeshowTemp(boolean newValue) {
        this.alwaysShowTemp.set((Object)newValue);
    }

    public void changeCampfireDuration(int newValue) {
        this.campfireDuration.set((Object)newValue);
    }

    public void setTempDamage(int newValue) {
        this.tempDamage.set((Object)newValue);
    }

    public void changeallowFoodHealing(boolean newValue) {
        this.allowFoodHealing.set((Object)newValue);
    }

    public void changeGradualCampfireEffect(boolean newValue) {
        this.gradualCampfireEffect.set((Object)newValue);
    }

    public void changeMountainYLevel(int newValue) {
        this.mountainYLevel.set((Object)newValue);
    }

    public void changeDefaultTempTimerThreshold(int newValue) {
        this.defaultTempTimerThreshold.set((Object)newValue);
    }

    public void changeUndergroundOreDeposits(boolean newValue) {
        this.undergroundOreDeposits.set((Object)newValue);
    }

    public void changeRenewableOreDeposits(boolean newValue) {
        this.renewableOreDeposits.set((Object)newValue);
    }

    public void save() {
        SPEC.save();
    }

    static {
        CONFIG_PATH = Paths.get("config", "zarrowsandstuff.toml");
        Pair specPair = new ForgeConfigSpec.Builder().configure(ZConfigManager::new);
        INSTANCE = (ZConfigManager)specPair.getLeft();
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        config.load();
        config.save();
        SPEC.setConfig((CommentedConfig)config);
    }
}

