/*
 * Decompiled with CFR 0.152.
 */
package com.ladestitute.zarrowsandstuff.util.zarrowscap;

import com.ladestitute.zarrowsandstuff.util.zarrowscap.PlayerDataCapabilityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="zarrowsandstuff", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerDataCapabilityHandler {
    public static final ResourceLocation ZPLAYERDATA_CAP = new ResourceLocation("zarrowsandstuff", "zarrowscap");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        if (event.getObject() instanceof PlayerEntity) {
            PlayerDataCapabilityProvider provider = new PlayerDataCapabilityProvider();
            event.addCapability(ZPLAYERDATA_CAP, (ICapabilityProvider)new PlayerDataCapabilityProvider());
            event.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onDeathEvent(LivingDeathEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            LivingEntity player = event.getEntityLiving();
            player.getCapability(PlayerDataCapabilityProvider.ZPLAYERDATA).ifPresent(h -> {
                h.setColdResistCooldown(0);
                h.setHeatResistCooldown(0);
                h.setFoodCooldown(0);
                h.setStamina(h.getMaxStamina());
            });
        }
    }
}

