/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import fr.atesab.act.AdvancedCreativeTab;
import fr.atesab.act.StringModifier;
import fr.atesab.act.command.ModdedCommand;
import fr.atesab.act.command.ModdedCommandACT;
import fr.atesab.act.command.ModdedCommandGamemode;
import fr.atesab.act.command.ModdedCommandGamemodeQuick;
import fr.atesab.act.config.Configuration;
import fr.atesab.act.gui.GuiACT;
import fr.atesab.act.gui.GuiGiver;
import fr.atesab.act.gui.GuiMenu;
import fr.atesab.act.gui.modifier.GuiItemStackModifier;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.CommandUtils;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.client.gui.widget.ModListWidget;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="act")
public class ACTMod {
    public static final ACTState MOD_STATE = ACTState.RELEASE;
    public static final String MOD_ID = "act";
    public static final String MOD_NAME = "Advanced Creative 2";
    public static final String MOD_VERSION = "2.3";
    public static final String MOD_LITTLE_NAME = "ACT-Mod";
    public static final String MOD_AUTHORS = "ATE47";
    public static final String MOD_LICENCE = "GNU GPL 3";
    public static final String MOD_LICENCE_LINK = "https://www.gnu.org/licenses/gpl-3.0.en.html";
    public static final String MOD_LINK = "https://www.curseforge.com/minecraft/mc-mods/advanced-extended-creative-mode";
    public static final String MOD_FACTORY = "fr.atesab.act.gui.ModGuiFactory";
    public static final ModdedCommandACT ACT_COMMAND = new ModdedCommandACT();
    public static final AdvancedCreativeTab ADVANCED_CREATIVE_TAB = new AdvancedCreativeTab();
    public static final String TEMPLATE_TAG_NAME = "TemplateData";
    public static final Random RANDOM = new Random();
    private static final MatrixStack STACK = new MatrixStack();
    public static final String[] DEFAULT_CUSTOM_ITEMS = new String[]{ItemUtils.getGiveCode(ItemUtils.buildStack(Blocks.field_196562_aR, 42, TextFormatting.LIGHT_PURPLE + "Pink verity", new String[]{"" + TextFormatting.GOLD + TextFormatting.BOLD + "42 is life", "" + TextFormatting.GOLD + TextFormatting.BOLD + "wait what ?"}, new Tuple[0]))};
    public static final Logger LOGGER = LogManager.getLogger((String)"act".toUpperCase());
    private static KeyBinding giver;
    private static KeyBinding menu;
    private static KeyBinding edit;
    private static List<ItemStack> templates;
    private static HashSet<Attribute> attributes;
    private static Map<String, Map<String, Consumer<StringModifier>>> stringModifier;
    private static Configuration config;
    private static CommandDispatcher<CommandSource> dispatcher;
    private static Set<String> commandSet;
    private static CommandDispatcher<ISuggestionProvider> suggestionProvider;

    public static boolean doesDisableToolTip() {
        return config.doesDisableToolTip();
    }

    public static HashSet<Attribute> getAttributes() {
        return attributes;
    }

    public static List<String> getCustomItems() {
        return config.getCustomitems();
    }

    public static CommandDispatcher<CommandSource> getDispatcher() {
        return dispatcher;
    }

    public static Map<String, Map<String, Consumer<StringModifier>>> getStringModifier() {
        return stringModifier;
    }

    public static String getTemplateData(ItemStack template) {
        return ItemUtils.getCustomTag(template, TEMPLATE_TAG_NAME, null);
    }

    public static Stream<ItemStack> getTemplates() {
        return templates.stream().map(is -> {
            String lang = ItemUtils.getCustomTag(is, "TemplateDataLang", null);
            TranslationTextComponent display = lang != null ? new TranslationTextComponent(lang) : is.func_151000_E();
            display.func_230532_e_().func_240699_a_(TextFormatting.AQUA);
            return is.func_77946_l().func_200302_a((ITextComponent)display);
        });
    }

    public static boolean isKeyDown(int key) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key);
    }

    public static void openGiver() {
        Minecraft mc = Minecraft.func_71410_x();
        int slot = mc.field_71439_g.field_71071_by.field_70461_c;
        GuiUtils.displayScreen(new GuiItemStackModifier(null, mc.field_71439_g.func_184614_ca().func_77946_l(), is -> ItemUtils.give(is, 36 + slot)));
    }

    public static void registerCommand(ModdedCommand command) {
        commandSet.addAll(command.getAliases());
        command.register(dispatcher);
    }

    public static void registerStringModifier(String name, Consumer<StringModifier> modifier) {
        ACTMod.registerStringModifier(name, "", modifier);
    }

    public static void registerStringModifier(String name, String category, Consumer<StringModifier> modifier) {
        Map<String, Consumer<StringModifier>> map = stringModifier.get(category);
        if (map == null) {
            map = new HashMap<String, Consumer<StringModifier>>();
            stringModifier.put(category, map);
        }
        map.put(name, modifier);
    }

    public static void registerTemplate(String lang, ItemStack icon, String data) {
        templates.add(ItemUtils.setCustomTag(ItemUtils.setCustomTag(icon.func_77946_l(), TEMPLATE_TAG_NAME, data), "TemplateDataLang", lang));
    }

    public static void saveConfigs() {
        config.save();
    }

    public static void saveItem(String code) {
        LOGGER.info("Adding : " + code);
        config.getCustomitems().add(0, code);
    }

    public static void setDoesDisableToolTip(boolean doesDisableToolTip) {
        config.setDoesDisableToolTip(doesDisableToolTip);
    }

    public static void drawString(FontRenderer renderer, String str, int x, int y, int color) {
        renderer.func_238421_b_(STACK, str, (float)x, (float)y, color);
    }

    public ACTMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        config = new Configuration();
        config.sync(FMLPaths.CONFIGDIR.get().resolve("act.toml").toFile());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void checkModList(Screen screen) {
        Optional op;
        ModInfo info;
        ModListWidget.ModEntry entry;
        if (screen != null && screen instanceof ModListScreen && (entry = this.getFirstFieldOfTypeInto(ModListWidget.ModEntry.class, screen)) != null && (info = this.getFirstFieldOfTypeInto(ModInfo.class, entry)) != null && (op = ModList.get().getModContainerById(info.getModId())).isPresent()) {
            boolean value = ((ModContainer)op.get()).getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent();
            String config = I18n.func_135052_a((String)"fml.menu.mods.config", (Object[])new Object[0]);
            for (IGuiEventListener b : screen.func_231039_at__()) {
                if (!(b instanceof Button) || !((Button)b).func_230458_i_().getString().equals(config)) continue;
                ((Button)b).field_230693_o_ = value;
            }
        }
    }

    private void commandSetup() {
        ACTMod.registerCommand(new ModdedCommandACT());
        ACTMod.registerCommand(new ModdedCommandGamemode("gm"));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gmc", GameType.CREATIVE));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gma", GameType.ADVENTURE));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gms", GameType.SURVIVAL));
        ACTMod.registerCommand(new ModdedCommandGamemodeQuick("gmsp", GameType.SPECTATOR));
        LOGGER.info("Commands registered.");
    }

    private void commonSetup(FMLCommonSetupEvent ev) {
        ModList.get().getModContainerById(MOD_ID).ifPresent(con -> con.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> new GuiMenu((Screen)parent)));
        this.commandSetup();
        giver = new KeyBinding("key.act.giver", 89, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)giver);
        menu = new KeyBinding("key.act.menu", 78, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)menu);
        edit = new KeyBinding("key.act.edit", 72, MOD_NAME);
        ClientRegistry.registerKeyBinding((KeyBinding)edit);
        for (Field field : Attributes.class.getDeclaredFields()) {
            if (field.getType() != Attribute.class) continue;
            try {
                field.setAccessible(true);
                attributes.add((Attribute)field.get(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ACTMod.registerTemplate("gui.act.menu.template.empty", new ItemStack((IItemProvider)Items.field_151121_aF), "");
        ACTMod.registerTemplate("gui.act.menu.template.stone", new ItemStack((IItemProvider)Blocks.field_150348_b), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Blocks.field_150348_b)));
        ACTMod.registerTemplate("gui.act.menu.template.potion", new ItemStack((IItemProvider)Items.field_151068_bn), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_151068_bn)));
        ACTMod.registerTemplate("gui.act.menu.template.fireworks", new ItemStack((IItemProvider)Items.field_196152_dE), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_196152_dE)));
        ACTMod.registerTemplate(Items.field_196184_dx.func_77658_a(), new ItemStack((IItemProvider)Items.field_196184_dx), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_196184_dx)));
        ACTMod.registerTemplate("gui.act.menu.template.command", new ItemStack((IItemProvider)Blocks.field_150483_bI), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Blocks.field_150483_bI)));
        ACTMod.registerTemplate(Items.field_151110_aK.func_77658_a(), new ItemStack((IItemProvider)Items.field_151110_aK), ItemUtils.getGiveCode(new ItemStack((IItemProvider)Items.field_151110_aK)));
        Registry.field_212630_s.forEach(i -> {
            ACTMod.registerStringModifier(i.func_77658_a() + ".name", "registry.items", sm -> sm.setString(i.getRegistryName().toString()));
            if (i.getCreativeTabs() == null || i.getCreativeTabs().isEmpty() || i.func_77640_w() == null) {
                ADVANCED_CREATIVE_TAB.addSubitem((Item)i);
            } else {
                NonNullList sub = NonNullList.func_191196_a();
                i.func_150895_a(ItemGroup.field_78027_g, sub);
                if (sub.stream().noneMatch(is -> is.func_77973_b().equals(i) && (is.func_77978_p() == null || is.func_77978_p().isEmpty() || is.func_77978_p().func_186856_d() != 1 || !is.func_77978_p().func_74764_b("damage")))) {
                    ADVANCED_CREATIVE_TAB.addSubitem((Item)i);
                }
            }
        });
        Registry.field_212618_g.forEach(b -> ACTMod.registerStringModifier(b.func_235333_g_().getString(), "registry.blocks", sm -> sm.setString(b.getRegistryName().toString())));
        Registry.field_212621_j.forEach(p -> ACTMod.registerStringModifier(p.func_185174_b(""), "registry.potions", sm -> sm.setString(p.getRegistryName().toString())));
        ForgeRegistries.BIOMES.forEach(b -> ACTMod.registerStringModifier(b.func_201856_r().func_222352_a(), "registry.biomes", sm -> sm.setString(b.getRegistryName().toString())));
        Registry.field_212633_v.forEach(s -> ACTMod.registerStringModifier(s.getRegistryName().toString(), "registry.sounds", sm -> sm.setString(s.getRegistryName().toString())));
        Registry.field_218370_L.forEach(vp -> ACTMod.registerStringModifier(vp.getRegistryName().toString(), "registry.villagerProfessions", sm -> sm.setString(vp.getRegistryName().toString())));
        Registry.field_212629_r.forEach(ee -> ACTMod.registerStringModifier(ee.func_210760_d(), "registry.entities", sm -> sm.setString(ee.getRegistryName().toString())));
        attributes.forEach(at -> ACTMod.registerStringModifier(at.func_233754_c_(), "attributes", sm -> sm.setString(at.getRegistryName().toString())));
        for (Field field : EquipmentSlotType.values()) {
            ACTMod.registerStringModifier("item.modifiers." + field.func_188450_d(), "attributes.slot", arg_0 -> ACTMod.lambda$commonSetup$22((EquipmentSlotType)field, arg_0));
        }
        ACTMod.registerStringModifier("gui.act.modifier.string.giver", "", sm -> sm.setNextScreen(new GuiGiver(sm.getNextScreen(), sm.getString(), sm::setString, false)));
        ACTMod.registerStringModifier("gui.act.modifier.string.nbt", "", sm -> {
            try {
                sm.setNextScreen(new GuiNBTModifier(sm.getNextScreen(), nbt -> sm.setString(nbt.toString()), JsonToNBT.func_180713_a((String)sm.getString())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.players", "", sm -> {
            List<String> plr;
            try {
                plr = CommandUtils.getPlayerList();
            }
            catch (Exception e) {
                plr = new ArrayList<String>();
                plr.add(Minecraft.func_71410_x().func_110432_I().func_111285_a());
            }
            ArrayList btn = new ArrayList();
            plr.forEach(pn -> btn.add(new Tuple<String, String>((String)pn, (String)pn)));
            sm.setNextScreen(new GuiButtonListSelector<String>(sm.getNextScreen(), (ITextComponent)new TranslationTextComponent("gui.act.modifier.string.players"), btn, s -> {
                sm.setString((String)s);
                return null;
            }));
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.encode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getEncoder().encode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ACTMod.registerStringModifier("gui.act.modifier.string.b64.decode", "b64", sm -> {
            try {
                sm.setString(new String(Base64.getDecoder().decode(sm.getString().getBytes())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void createSuggestion(CommandNode<CommandSource> dispatcher, CommandNode<ISuggestionProvider> rootCommandNode, CommandSource player, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> suggestions) {
        for (CommandNode child : dispatcher.getChildren()) {
            RequiredArgumentBuilder requiredargumentbuilder;
            ArgumentBuilder argumentbuilder = child.createBuilder();
            argumentbuilder.requires(ctx -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes(ctx -> 0);
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder && (requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder).getSuggestionsProvider() != null) {
                requiredargumentbuilder.suggests(SuggestionProviders.func_197496_b((SuggestionProvider)requiredargumentbuilder.getSuggestionsProvider()));
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(suggestions.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode1 = argumentbuilder.build();
            suggestions.put((CommandNode<CommandSource>)child, (CommandNode<ISuggestionProvider>)commandnode1);
            rootCommandNode.addChild(commandnode1);
            if (child.getChildren().isEmpty()) continue;
            this.createSuggestion((CommandNode<CommandSource>)child, (CommandNode<ISuggestionProvider>)commandnode1, player, suggestions);
        }
    }

    private <T> T getFirstFieldOfTypeInto(Class<T> cls, Object obj) {
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getType() != cls) continue;
            try {
                return (T)f.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private void injectSuggestions() {
        CommandDispatcher current;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71174_a != null && (current = mc.field_71439_g.field_71174_a.func_195515_i()) != suggestionProvider) {
            suggestionProvider = current;
            if (current != null) {
                HashMap map = Maps.newHashMap();
                RootCommandNode root = suggestionProvider.getRoot();
                map.put(dispatcher.getRoot(), root);
                this.createSuggestion((CommandNode<CommandSource>)dispatcher.getRoot(), (CommandNode<ISuggestionProvider>)root, mc.field_71439_g.func_195051_bN(), map);
            }
        }
    }

    @SubscribeEvent
    public void onChatMessage(ClientChatEvent ev) {
        String msg = ev.getMessage();
        if (!msg.startsWith("/")) {
            return;
        }
        String command = msg.substring(1);
        if (!commandSet.contains(command.split(" ", 2)[0])) {
            return;
        }
        ev.setCanceled(true);
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(msg);
        StringReader reader = new StringReader(msg);
        if (reader.canRead()) {
            reader.skip();
        }
        CommandSource source = Minecraft.func_71410_x().field_71439_g.func_195051_bN();
        try {
            ParseResults parse = dispatcher.parse(reader, (Object)source);
            dispatcher.execute(parse);
        }
        catch (CommandException e) {
            source.func_197021_a(e.func_197003_a());
        }
        catch (CommandSyntaxException e) {
            source.func_197021_a(TextComponentUtils.func_202465_a((Message)e.getRawMessage()));
            if (e.getInput() != null && e.getCursor() >= 0) {
                int messageSize = Math.min(e.getInput().length(), e.getCursor());
                IFormattableTextComponent error = new StringTextComponent("").func_240699_a_(TextFormatting.GRAY).func_240700_a_(s -> s.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, msg)));
                if (messageSize > 10) {
                    error.func_240702_b_("...");
                }
                error.func_240702_b_(e.getInput().substring(Math.max(0, messageSize - 10), messageSize));
                if (messageSize < e.getInput().length()) {
                    IFormattableTextComponent itextcomponent2 = new StringTextComponent(e.getInput().substring(messageSize)).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                    error.func_230529_a_((ITextComponent)itextcomponent2);
                }
                error.func_230529_a_((ITextComponent)new TranslationTextComponent("command.context.here").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                source.func_197021_a((ITextComponent)error);
            }
        }
        catch (Exception e) {
            StringTextComponent error = new StringTextComponent(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                StackTraceElement[] trace = e.getStackTrace();
                for (int j = 0; j < Math.min(trace.length, 3); ++j) {
                    error.func_240702_b_("\n\n").func_240702_b_(trace[j].getMethodName()).func_240702_b_("\n ").func_240702_b_(trace[j].getFileName()).func_240702_b_(":").func_240702_b_(String.valueOf(trace[j].getLineNumber()));
                }
            }
            source.func_197021_a((ITextComponent)new TranslationTextComponent("command.failed").func_240700_a_(arg_0 -> ACTMod.lambda$onChatMessage$34((IFormattableTextComponent)error, arg_0)));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            this.checkModList(Minecraft.func_71410_x().field_71462_r);
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post ev) {
        if (ev.getGui() instanceof GuiACT && MOD_STATE.isShow()) {
            ACTMod.drawString(Minecraft.func_71410_x().field_71466_p, "Warning! Currently in " + MOD_STATE.getColor() + MOD_STATE.name(), 5, 5, -1);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post ev) {
        this.injectSuggestions();
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent ev) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (giver.func_151468_f()) {
            GuiUtils.displayScreen(new GuiGiver(null));
        } else if (menu.func_151468_f()) {
            GuiUtils.displayScreen(new GuiMenu(null));
        } else if (edit.func_151468_f()) {
            ACTMod.openGiver();
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((mc.field_71462_r instanceof GuiGiver || mc.field_71462_r instanceof GuiModifier || giver.getKey().func_197937_c() == 0 || !ACTMod.isKeyDown(340)) && mc.field_71462_r instanceof GuiMenu) {
            ev.getToolTip().add(ModdedCommand.createPrefix(I18n.func_135052_a((String)"gui.act.leftClick", (Object[])new Object[0]), TextFormatting.YELLOW, TextFormatting.GOLD).func_230529_a_((ITextComponent)ModdedCommand.createText(I18n.func_135052_a((String)(ACTMod.isKeyDown(340) ? "gui.act.give.copy" : "gui.act.give.editor"), (Object[])new Object[0]), TextFormatting.YELLOW)));
            if (ACTMod.isKeyDown(340)) {
                ev.getToolTip().add(ModdedCommand.createPrefix(I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]), TextFormatting.YELLOW, TextFormatting.GOLD).func_230529_a_((ITextComponent)ModdedCommand.createText(I18n.func_135052_a((String)"gui.act.delete", (Object[])new Object[0]), TextFormatting.YELLOW)));
            } else if (mc.field_71439_g != null && mc.field_71439_g.func_184812_l_()) {
                ev.getToolTip().add(ModdedCommand.createPrefix(I18n.func_135052_a((String)"gui.act.rightClick", (Object[])new Object[0]), TextFormatting.YELLOW, TextFormatting.GOLD).func_230529_a_((ITextComponent)ModdedCommand.createText(I18n.func_135052_a((String)"gui.act.give.give", (Object[])new Object[0]), TextFormatting.YELLOW)));
            }
        }
        if (config.doesDisableToolTip() && !ev.getFlags().func_194127_a()) {
            return;
        }
        if (ACTMod.isKeyDown(340)) {
            double maxdmg;
            int dmg;
            String s;
            CompoundNBT compound = ev.getItemStack().func_77978_p();
            String string = s = !ev.getFlags().func_194127_a() ? ev.getItemStack().func_77973_b().getRegistryName().toString() : "";
            if (!(mc.field_71462_r != null && mc.field_71462_r instanceof CreativeScreen && ((CreativeScreen)mc.field_71462_r).func_147056_g() == ItemGroup.field_78027_g.func_78021_a() || ev.getItemStack().func_77973_b().getCreativeTabs() == null)) {
                s = s + TextFormatting.WHITE + (s.isEmpty() ? "" : " ") + ev.getItemStack().func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(i -> i.func_242392_c().getString()).collect(Collectors.joining(", "));
            }
            if (!s.isEmpty()) {
                ev.getToolTip().add(new StringTextComponent(s));
            }
            if (compound != null && compound.func_150297_b("CustomPotionColor", 99)) {
                ev.getToolTip().add(ModdedCommand.createText(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{TextFormatting.YELLOW + String.format("#%06X", compound.func_74762_e("CustomPotionColor"))}), TextFormatting.GOLD));
            }
            if (!ev.getFlags().func_194127_a()) {
                if (ev.getToolTip().size() != 0) {
                    ev.getToolTip().set(0, new StringTextComponent("").func_230529_a_((ITextComponent)ev.getToolTip().get(0)).func_240702_b_(" (#" + Item.func_150891_b((Item)ev.getItemStack().func_77973_b()) + (ev.getItemStack().func_77952_i() != 0 && !ev.getItemStack().func_77951_h() ? "/" + ev.getItemStack().func_77952_i() : "") + ")").func_240699_a_(TextFormatting.WHITE));
                }
                if (compound != null && compound.func_150297_b("display", 10) && compound.func_74775_l("display").func_150297_b("color", 99)) {
                    ev.getToolTip().add(ModdedCommand.createText(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{TextFormatting.YELLOW + String.format("#%06X", compound.func_74775_l("display").func_74762_e("color"))}), TextFormatting.GOLD));
                }
                if (ev.getItemStack().func_77951_h()) {
                    dmg = Math.abs(ev.getItemStack().func_77952_i() - ev.getItemStack().func_77958_k()) + 1;
                    maxdmg = ev.getItemStack().func_77958_k() + 1;
                    ev.getToolTip().add(ModdedCommand.createText("RepairCost: ", TextFormatting.YELLOW).func_230529_a_((ITextComponent)ModdedCommand.createText(String.valueOf(dmg), dmg < (int)(0.1 * maxdmg) ? TextFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? TextFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? TextFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? TextFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN)))))));
                    ev.getToolTip().add(ModdedCommand.createText(I18n.func_135052_a((String)"item.durability", (Object[])new Object[]{(dmg < (int)(0.1 * maxdmg) ? TextFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? TextFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? TextFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? TextFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN))))).toString() + dmg, ev.getItemStack().func_77958_k() + 1}), TextFormatting.YELLOW));
                }
            }
            if (compound != null && compound.func_186856_d() != 0) {
                if (ev.getItemStack().func_77978_p().func_74764_b("RepairCost")) {
                    dmg = ev.getItemStack().func_77978_p().func_74762_e("RepairCost");
                    maxdmg = 31.0;
                    ev.getToolTip().add(ModdedCommand.createText("RepairCost: ", TextFormatting.YELLOW).func_230529_a_((ITextComponent)ModdedCommand.createText(String.valueOf(dmg), dmg < (int)(0.1 * maxdmg) ? TextFormatting.DARK_GREEN : (dmg < (int)(0.25 * maxdmg) ? TextFormatting.GREEN : (dmg < (int)(0.5 * maxdmg) ? TextFormatting.GOLD : (dmg < (int)(0.75 * maxdmg) ? TextFormatting.RED : (dmg < (int)(1.0 * maxdmg) ? TextFormatting.DARK_RED : TextFormatting.DARK_GREEN)))))));
                }
                IFormattableTextComponent tags = ModdedCommand.createText(I18n.func_135052_a((String)"gui.act.tags", (Object[])new Object[0]) + "(" + compound.func_186856_d() + "): ", TextFormatting.GOLD);
                int count = 0;
                for (String tag : compound.func_150296_c()) {
                    if (count != 0) {
                        tags.func_230529_a_((ITextComponent)ModdedCommand.createText(", ", TextFormatting.GOLD));
                    }
                    tags.func_230529_a_((ITextComponent)ModdedCommand.createText("" + tag, TextFormatting.YELLOW));
                    ++count;
                }
                ev.getToolTip().add(tags);
            }
            if (!(mc.field_71462_r instanceof GuiGiver) && !(mc.field_71462_r instanceof GuiModifier)) {
                if (giver.getKey().func_197937_c() != 0 && ACTMod.isKeyDown(340)) {
                    if (ACTMod.isKeyDown(giver.getKey().func_197937_c())) {
                        mc.func_147108_a((Screen)new GuiGiver(mc.field_71462_r, ev.getItemStack()));
                    }
                    ev.getToolTip().add(ModdedCommand.createPrefix(giver.getKey().func_237520_d_().getString(), TextFormatting.YELLOW, TextFormatting.GOLD).func_230529_a_((ITextComponent)ModdedCommand.createTranslatedText("cmd.act.opengiver", TextFormatting.YELLOW, new Object[0])));
                }
                if (menu.getKey().func_197937_c() != 0) {
                    if (ACTMod.isKeyDown(menu.getKey().func_197937_c())) {
                        String code = ItemUtils.getGiveCode(ev.getItemStack()).replace('\u00a7', '&');
                        ACTMod.saveItem(code);
                        mc.func_147108_a((Screen)new GuiMenu(mc.field_71462_r));
                    }
                    ev.getToolTip().add(ModdedCommand.createPrefix(menu.getKey().func_237520_d_().getString(), TextFormatting.YELLOW, TextFormatting.GOLD).func_230529_a_((ITextComponent)ModdedCommand.createTranslatedText("gui.act.save", TextFormatting.YELLOW, new Object[0])));
                }
            }
        }
        if (!ACTMod.isKeyDown(340)) {
            ev.getToolTip().add(new StringTextComponent("SHIFT ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new TranslationTextComponent("gui.act.shift")).func_240699_a_(TextFormatting.GOLD));
        }
    }

    private static /* synthetic */ Style lambda$onChatMessage$34(IFormattableTextComponent error, Style style) {
        style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)error));
        return style;
    }

    private static /* synthetic */ void lambda$commonSetup$22(EquipmentSlotType slot, StringModifier sm) {
        sm.setString(slot.func_188450_d());
    }

    static {
        templates = new ArrayList<ItemStack>();
        attributes = new HashSet();
        stringModifier = new HashMap<String, Map<String, Consumer<StringModifier>>>();
        dispatcher = new CommandDispatcher();
        commandSet = new HashSet<String>();
    }

    public static enum ACTState {
        RELEASE(null),
        BETA(TextFormatting.GOLD),
        ALPHA(TextFormatting.DARK_RED);

        private TextFormatting color;

        private ACTState(TextFormatting color) {
            this.color = color;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public boolean isShow() {
            return this.color != null;
        }
    }
}

