/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import fr.atesab.act.command.ModdedCommandHelp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ModdedCommand {
    public static final int MAX_EXAMPLE = 6;
    private final Map<String, ModdedCommand> NAME_TO_COMMAND = new TreeMap<String, ModdedCommand>();
    private final List<ModdedCommand> SUB_COMMANDS = new ArrayList<ModdedCommand>();
    private List<String> subCommandTitleExample = new ArrayList<String>(6);
    private ModdedCommand parent;
    public ModdedCommand defaultCommand;
    private String name;
    private String description;
    private ModdedCommandHelp.CommandClickOption clickOption;
    private boolean displayInHelp;
    private List<String> aliases;
    protected LiteralCommandNode<CommandSource> node;
    private CommandDispatcher<CommandSource> dispatcher;
    private boolean registered = false;

    public static IFormattableTextComponent createPrefix(String text, TextFormatting color, TextFormatting border) {
        return ModdedCommand.createText("[", border).func_230529_a_((ITextComponent)ModdedCommand.createText(text, color)).func_230529_a_((ITextComponent)ModdedCommand.createText("] ", border));
    }

    public static IFormattableTextComponent createText(String text, TextFormatting color) {
        return new StringTextComponent(Objects.requireNonNull(text)).func_240699_a_(color);
    }

    public static IFormattableTextComponent createTranslatedPrefix(String text, TextFormatting color, TextFormatting border, Object ... args) {
        return ModdedCommand.createText("[", border).func_230529_a_((ITextComponent)ModdedCommand.createTranslatedText(text, color, args)).func_230529_a_((ITextComponent)ModdedCommand.createText("] ", border));
    }

    public static IFormattableTextComponent createTranslatedText(String lang, TextFormatting color, Object ... args) {
        return new TranslationTextComponent(Objects.requireNonNull(lang), args).func_240699_a_(color);
    }

    public ModdedCommand(String name) {
        this(name, "", ModdedCommandHelp.CommandClickOption.doCommand);
    }

    public ModdedCommand(String name, String description, ModdedCommandHelp.CommandClickOption clickOption) {
        this(name, description, clickOption, true);
    }

    public ModdedCommand(String name, String description, ModdedCommandHelp.CommandClickOption clickOption, boolean displayInHelp) {
        this.description = description;
        this.clickOption = clickOption;
        this.displayInHelp = displayInHelp;
        this.name = name.toLowerCase();
        this.aliases = new ArrayList<String>(1);
        this.addAlias(this.getName());
    }

    public ModdedCommand addAlias(String alias) {
        this.aliases.add(alias.toLowerCase());
        return this;
    }

    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    public ModdedCommandHelp.CommandClickOption getClickOption() {
        return this.clickOption;
    }

    public String getDescription() {
        return I18n.func_135052_a((String)this.getDescriptionTranslationKey(), (Object[])new Object[0]);
    }

    public String getDescriptionTranslationKey() {
        return this.description;
    }

    public CommandDispatcher<CommandSource> getDispatcher() {
        return this.dispatcher;
    }

    public String getGlobalName() {
        return this.parent != null ? this.parent.getGlobalName() + " " + this.getName() : this.getName();
    }

    public String getName() {
        return this.name;
    }

    public LiteralCommandNode<CommandSource> getNode() {
        return this.node;
    }

    public ModdedCommand getParent() {
        return this.parent;
    }

    public List<ModdedCommand> getSubCommands() {
        return Collections.unmodifiableList(this.SUB_COMMANDS);
    }

    public Map<String, ModdedCommand> getSubCommandsMap() {
        return Collections.unmodifiableMap(this.NAME_TO_COMMAND);
    }

    public boolean isDisplayInHelp() {
        return this.displayInHelp;
    }

    protected LiteralArgumentBuilder<CommandSource> onArgument(LiteralArgumentBuilder<CommandSource> command) {
        return command;
    }

    protected Command<CommandSource> onNoArgument() {
        return this.defaultCommand != null ? this.defaultCommand.onNoArgument() : c -> {
            ((CommandSource)c.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("cmd.act.error.noargument").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
            return 1;
        };
    }

    private void register() {
        if (this.registered) {
            throw new IllegalStateException("A command can't be registered more than once");
        }
        this.registered = true;
    }

    public void register(CommandDispatcher<CommandSource> dispatcher) {
        this.register();
        this.dispatcher = dispatcher;
        this.register((CommandNode<CommandSource>)dispatcher.getRoot());
    }

    private void register(CommandNode<CommandSource> node) {
        for (String alias : this.aliases) {
            Command<CommandSource> noArgument = this.onNoArgument();
            LiteralArgumentBuilder<CommandSource> bld = this.onArgument((LiteralArgumentBuilder<CommandSource>)Commands.func_197057_a((String)alias));
            if (noArgument != null) {
                bld.executes(noArgument);
            }
            this.node = bld.build();
            this.NAME_TO_COMMAND.forEach((salias, cmd) -> {
                cmd.dispatcher = this.dispatcher;
                cmd.register((CommandNode<CommandSource>)this.node);
            });
            node.addChild(this.node);
        }
    }

    public ModdedCommand registerDefaultSubCommand(ModdedCommand subCommand) {
        subCommand.register();
        for (String alias : subCommand.getAliases()) {
            this.NAME_TO_COMMAND.put(alias, subCommand);
        }
        if (this.subCommandTitleExample.size() < 6) {
            this.subCommandTitleExample.add(0, subCommand.getName());
        } else {
            this.subCommandTitleExample.remove(5);
            this.subCommandTitleExample.add(0, subCommand.getName());
        }
        this.SUB_COMMANDS.add(subCommand);
        this.defaultCommand = subCommand;
        return this;
    }

    public ModdedCommand registerSubCommand(ModdedCommand subCommand) {
        subCommand.register();
        subCommand.parent = this;
        for (String alias : subCommand.getAliases()) {
            this.NAME_TO_COMMAND.put(alias, subCommand);
        }
        if (this.subCommandTitleExample.size() < 6) {
            this.subCommandTitleExample.add(subCommand.getName());
        }
        this.SUB_COMMANDS.add(subCommand);
        return this;
    }
}

