/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fr.atesab.act.command.ModdedCommand;
import fr.atesab.act.command.arguments.StringListArgumentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ModdedCommandHelp
extends ModdedCommand {
    private final TextFormatting titleColor;
    private final TextFormatting commandColor;
    private final TextFormatting textColor;
    private final String title;
    private final ModdedCommand mainCommand;

    public ModdedCommandHelp(ModdedCommand mainCommand, String title, TextFormatting titleColor, TextFormatting commandColor, TextFormatting textColor) {
        super("help", "cmd.act.help.cmd", CommandClickOption.suggestCommand);
        this.title = title;
        this.mainCommand = mainCommand;
        this.titleColor = titleColor;
        this.commandColor = commandColor;
        this.textColor = textColor;
        this.addAlias("?");
    }

    public List<ModdedCommand> getVisibleSubCommand(ModdedCommand mainCommand) {
        ArrayList<ModdedCommand> sc = new ArrayList<ModdedCommand>();
        for (ModdedCommand c : mainCommand.getSubCommands()) {
            if (!c.isDisplayInHelp()) continue;
            sc.add(c);
        }
        return sc;
    }

    @Override
    protected LiteralArgumentBuilder<CommandSource> onArgument(LiteralArgumentBuilder<CommandSource> command) {
        return (LiteralArgumentBuilder)command.then(Commands.func_197056_a((String)"commandforhelp", (ArgumentType)StringListArgumentType.stringList(this.mainCommand.getSubCommandsMap().keySet(), Arrays.asList(this.getName()), true)).executes(c -> {
            int count = 0;
            for (String commandName : StringListArgumentType.getStringList(c, "commandforhelp")) {
                ModdedCommand cmd = this.mainCommand.getSubCommandsMap().get(commandName);
                CommandSource src = (CommandSource)c.getSource();
                String parentName = this.mainCommand.getGlobalName();
                if (cmd != null) {
                    count += 3;
                    src.func_197030_a((ITextComponent)ModdedCommandHelp.createText("-- " + I18n.func_135052_a((String)"cmd.act.help", (Object[])new Object[]{cmd.getName()}) + " --", this.titleColor), false);
                    src.func_197030_a((ITextComponent)ModdedCommandHelp.createTranslatedText(cmd.getDescriptionTranslationKey(), this.textColor, new Object[0]), false);
                    src.func_197030_a((ITextComponent)ModdedCommandHelp.createTranslatedText("cmd.act.aliases", this.titleColor, new Object[0]).func_230529_a_((ITextComponent)ModdedCommandHelp.createText(": ", TextFormatting.DARK_GRAY)).func_230529_a_((ITextComponent)ModdedCommandHelp.createText(cmd.getAliases().stream().filter(s -> !s.equals(cmd.getName())).collect(Collectors.joining(", ")), this.textColor)), false);
                    Map usages = this.getDispatcher().getSmartUsage(cmd.getNode(), (Object)src);
                    if (usages.isEmpty()) {
                        this.showCommand(cmd, src, "/" + parentName + " " + cmd.getName(), "", false);
                        ++count;
                        continue;
                    }
                    for (String usage : usages.values()) {
                        this.showCommand(cmd, src, "/" + parentName + " " + cmd.getName(), usage, false);
                        ++count;
                    }
                    continue;
                }
                src.func_197021_a((ITextComponent)ModdedCommandHelp.createText(I18n.func_135052_a((String)"cmd.act.mc.invalid", (Object[])new Object[]{"/" + parentName + " " + this.getName()}), TextFormatting.RED));
                return count + 1;
            }
            return count;
        }));
    }

    @Override
    protected Command<CommandSource> onNoArgument() {
        return c -> {
            CommandSource src = (CommandSource)c.getSource();
            int count = 1;
            src.func_197030_a((ITextComponent)ModdedCommandHelp.createText("-- " + I18n.func_135052_a((String)"cmd.act.help", (Object[])new Object[]{this.title}) + " --", this.titleColor), false);
            String parentName = this.mainCommand.getGlobalName();
            for (ModdedCommand command : this.mainCommand.getSubCommands()) {
                if (!command.isDisplayInHelp()) continue;
                Map usages = this.getDispatcher().getSmartUsage(command.getNode(), (Object)src);
                if (usages.isEmpty()) {
                    this.showCommand(command, src, "/" + parentName + " " + command.getName(), "", true);
                    ++count;
                    continue;
                }
                for (String usage : usages.values()) {
                    this.showCommand(command, src, "/" + parentName + " " + command.getName(), usage, true);
                    ++count;
                }
            }
            return count;
        };
    }

    private void showCommand(ModdedCommand command, CommandSource src, String name, String usage, boolean showDescription) {
        IFormattableTextComponent component = usage.isEmpty() ? ModdedCommandHelp.createText(name, this.commandColor) : ModdedCommandHelp.createText(name + " " + usage, this.commandColor);
        component = command.getClickOption() == CommandClickOption.doCommand ? component.func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)ModdedCommandHelp.createTranslatedText("cmd.act.help.do", this.titleColor, new Object[0]))).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, name))) : component.func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)ModdedCommandHelp.createTranslatedText("cmd.act.help.click", this.titleColor, new Object[0]))).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, name + " ")));
        if (showDescription) {
            src.func_197030_a((ITextComponent)component.func_230529_a_((ITextComponent)ModdedCommandHelp.createText(": ", TextFormatting.DARK_GRAY)).func_230529_a_((ITextComponent)ModdedCommandHelp.createTranslatedText(command.getDescriptionTranslationKey(), this.textColor, new Object[0])), false);
        } else {
            src.func_197030_a((ITextComponent)component, false);
        }
    }

    public static enum CommandClickOption {
        doCommand,
        suggestCommand;

    }
}

