/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.atesab.act.command.ModdedCommand;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.command.CommandException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class StringListArgumentType
implements ArgumentType<String[]> {
    private Collection<String> suggestion;
    private Collection<String> example;
    private boolean wordOnly;

    public static <E extends Enum<E>> StringListArgumentType enumList(Class<E> cls) {
        return StringListArgumentType.enumList(cls, e -> e.name().toLowerCase());
    }

    public static <E extends Enum<E>> StringListArgumentType enumList(Class<E> cls, Function<E, String> formatter) {
        Enum[] values = (Enum[])cls.getEnumConstants();
        String[] array = new String[values.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = formatter.apply(values[i]);
        }
        String[] example = new String[3];
        System.arraycopy(array, 0, example, 0, example.length);
        return new StringListArgumentType(Arrays.asList(array), Arrays.asList(example), true);
    }

    public static <E extends Enum<E>> E[] getEnumList(Class<E> cls, CommandContext<?> context, String name) {
        Enum[] values = (Enum[])cls.getEnumConstants();
        return StringListArgumentType.getEnumList(cls, context, (String)name, (T s) -> {
            for (Enum e : values) {
                if (!e.name().equalsIgnoreCase((String)s)) continue;
                return e;
            }
            throw new CommandException((ITextComponent)ModdedCommand.createTranslatedText("cmd.act.enumlistargument.invalid", TextFormatting.RED, s));
        });
    }

    public static <E extends Enum<E>> E[] getEnumList(Class<E> cls, CommandContext<?> context, String name, Function<String, E> unformatter) {
        String[] out = StringListArgumentType.getStringList(context, name);
        Enum[] array = (Enum[])Array.newInstance(cls, out.length);
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Enum)unformatter.apply(out[i]);
        }
        return array;
    }

    public static String[] getStringList(CommandContext<?> context, String name) {
        return (String[])context.getArgument(name, String[].class);
    }

    public static StringListArgumentType stringList(Collection<String> suggestion, Collection<String> example, boolean wordOnly) {
        return new StringListArgumentType(suggestion, example, wordOnly);
    }

    public static StringListArgumentType stringList(String[] suggestion, String[] example, boolean wordOnly) {
        return new StringListArgumentType(Arrays.asList(suggestion), Arrays.asList(example), wordOnly);
    }

    public StringListArgumentType(Collection<String> suggestion, Collection<String> example, boolean wordOnly) {
        this.suggestion = suggestion;
        this.example = example;
        this.wordOnly = wordOnly;
    }

    public Collection<String> getExamples() {
        return this.example;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        int diff = this.wordOnly && !this.quoteStarted(remaining) ? remaining.lastIndexOf(" ") + 1 : remaining.lastIndexOf("\"") + 1;
        String lastElement = remaining.substring(diff).toLowerCase(Locale.ROOT);
        String current = remaining.substring(0, diff);
        for (String sugg : this.suggestion) {
            if (!sugg.toLowerCase(Locale.ROOT).startsWith(lastElement)) continue;
            builder.suggest(current + sugg);
        }
        return builder.buildFuture();
    }

    public String[] parse(StringReader reader) throws CommandSyntaxException {
        ArrayList<String> element = new ArrayList<String>();
        if (this.wordOnly) {
            String end = reader.getRemaining();
            reader.setCursor(reader.getTotalLength());
            return end.split(" ");
        }
        while (reader.canRead()) {
            element.add(reader.readString());
            reader.skipWhitespace();
        }
        return (String[])element.stream().toArray(String[]::new);
    }

    private boolean quoteStarted(String s) {
        int number = 0;
        boolean escaped = false;
        for (char c : s.toCharArray()) {
            if (escaped) continue;
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != '\"') continue;
            ++number;
        }
        return number % 2 == 1;
    }
}

