/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.matrix.MatrixStack;
import fr.atesab.act.ACTMod;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiAttributeModifier
extends GuiListModifier<List<ItemUtils.AttributeData>> {
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new AttributeListElement(this, ItemUtils.AttributeModifierBuilder.ARMOR.buildData(EquipmentSlotType.MAINHAND, 0.0, AttributeModifier.Operation.ADDITION));

    public GuiAttributeModifier(Screen parent, List<ItemUtils.AttributeData> attributes, Consumer<List<ItemUtils.AttributeData>> setter) {
        super(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.attr"), new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        attributes.forEach(attribute -> this.addListElement(new AttributeListElement(this, (ItemUtils.AttributeData)attribute)));
        this.addListElement(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected List<ItemUtils.AttributeData> get() {
        ArrayList<ItemUtils.AttributeData> result = new ArrayList<ItemUtils.AttributeData>();
        this.getElements().stream().filter(le -> le instanceof AttributeListElement).map(le -> (AttributeListElement)le).forEach(ale -> result.add(ale.getData()));
        return result;
    }

    static class AttributeListElement
    extends GuiListModifier.ListElement {
        private TextFieldWidget amount;
        private boolean errAmount = false;
        private double amountValue;
        private ItemUtils.AttributeData data;
        private int operationValue;
        private Button slotButton;
        private Button typeButton;
        private Button operationButton;

        public AttributeListElement(GuiAttributeModifier parent, ItemUtils.AttributeData data) {
            super(400, 50);
            this.data = data;
            int l = 5 + this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.attr.amount", (Object[])new Object[0]) + " : ");
            this.amount = new TextFieldWidget(this.font, 202 + l, 1, 154 - l, 18, (ITextComponent)new StringTextComponent(""));
            this.amount.func_146203_f(8);
            this.amountValue = data.getModifier().func_111164_d();
            this.amount.func_146180_a(String.valueOf(this.amountValue));
            this.operationValue = data.getModifier().func_220375_c().func_220371_a();
            this.slotButton = new Button(2, 0, 198, 20, (ITextComponent)new StringTextComponent(""), b -> {
                ArrayList slots = new ArrayList();
                slots.add(new Tuple<String, Object>(I18n.func_135052_a((String)"gui.act.none", (Object[])new Object[0]), null));
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    String s2 = I18n.func_135052_a((String)("item.modifiers." + slot.func_188450_d()), (Object[])new Object[0]);
                    slots.add(new Tuple<String, EquipmentSlotType>(s2.endsWith(":") ? s2.substring(0, s2.length() - 1) : s2, slot));
                }
                this.mc.func_147108_a(new GuiButtonListSelector<EquipmentSlotType>(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.slot"), slots, s -> {
                    data.setSlot((EquipmentSlotType)s);
                    this.defineButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.slotButton);
            this.typeButton = new Button(2, 21, 198, 20, (ITextComponent)new StringTextComponent(""), b -> {
                ArrayList attributes = new ArrayList();
                ACTMod.getAttributes().forEach(atr -> attributes.add(new Tuple<String, Attribute>(I18n.func_135052_a((String)atr.func_233754_c_(), (Object[])new Object[0]), (Attribute)atr)));
                this.mc.func_147108_a(new GuiButtonListSelector<Attribute>(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.type"), attributes, atr -> {
                    data.setAttribute((Attribute)atr);
                    this.defineButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.typeButton);
            this.operationButton = new Button(202, 21, 157, 20, (ITextComponent)new StringTextComponent(""), b -> {
                ArrayList operations = new ArrayList();
                operations.add(new Tuple<String, Integer>(I18n.func_135052_a((String)"gui.act.modifier.attr.operation.0", (Object[])new Object[0]) + " (0)", 0));
                operations.add(new Tuple<String, Integer>(I18n.func_135052_a((String)"gui.act.modifier.attr.operation.1", (Object[])new Object[0]) + " (1)", 1));
                operations.add(new Tuple<String, Integer>(I18n.func_135052_a((String)"gui.act.modifier.attr.operation.2", (Object[])new Object[0]) + " (2)", 2));
                this.mc.func_147108_a(new GuiButtonListSelector<Integer>(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.operation"), operations, i -> {
                    this.operationValue = i;
                    this.defineButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.operationButton);
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 359, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 381, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 359, 21, 43, 20, (ITextComponent)new TranslationTextComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, () -> new AttributeListElement(parent, this.getData())));
            this.defineButtonText();
        }

        private void defineButtonText() {
            String s = this.data.getSlot() == null ? I18n.func_135052_a((String)"gui.act.none", (Object[])new Object[0]) : I18n.func_135052_a((String)("item.modifiers." + this.data.getSlot().func_188450_d()), (Object[])new Object[0]);
            this.slotButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.slot").func_240702_b_(" - ").func_240702_b_(s.endsWith(":") ? s.substring(0, s.length() - 1) : s));
            this.typeButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.type").func_240702_b_(" - ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.data.getModifier().func_111166_b())));
            this.operationButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.operation").func_240702_b_(" - ").func_230529_a_((ITextComponent)new TranslationTextComponent("gui.act.modifier.attr.operation." + this.operationValue)).func_240702_b_(" (").func_240702_b_(String.valueOf(this.operationValue)).func_240702_b_(")"));
        }

        @Override
        public void draw(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(matrixStack, (Widget)this.amount, offsetX, offsetY, mouseX, mouseY, partialTicks);
            GuiUtils.drawRightString(this.font, I18n.func_135052_a((String)"gui.act.modifier.attr.amount", (Object[])new Object[0]) + " : ", (Widget)this.amount, (this.errAmount ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        @Override
        public void init() {
            this.amount.func_146195_b(false);
        }

        @Override
        public boolean isFocused() {
            return this.amount.func_230999_j_();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.amount.func_231042_a_(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            this.amount.func_231046_a_(key, scanCode, modifiers);
            return super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return this.slotButton.func_230458_i_().getString().toLowerCase().contains(search.toLowerCase()) || this.typeButton.func_230458_i_().getString().toLowerCase().contains(search.toLowerCase()) || this.operationButton.func_230458_i_().getString().toLowerCase().contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amount.func_231044_a_((double)mouseX, (double)mouseY, mouseButton);
            if (mouseButton == 1 && GuiUtils.isHover((Widget)this.amount, mouseX, mouseY)) {
                this.amount.func_146180_a("");
            }
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public void update() {
            this.amount.func_146178_a();
            try {
                this.amountValue = this.amount.func_146179_b().isEmpty() ? 0.0 : Double.parseDouble(this.amount.func_146179_b());
                this.errAmount = false;
            }
            catch (NumberFormatException e) {
                this.errAmount = true;
            }
            super.update();
        }

        public ItemUtils.AttributeData getData() {
            this.data.setModifier(new AttributeModifier(this.data.getModifier().func_111167_a(), this.data.getModifier().func_111166_b(), this.amountValue, AttributeModifier.Operation.func_220372_a((int)this.operationValue)));
            return this.data;
        }
    }
}

