/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.matrix.MatrixStack;
import fr.atesab.act.gui.modifier.GuiModifier;
import fr.atesab.act.utils.GuiUtils;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;

public class GuiColorModifier
extends GuiModifier<Integer> {
    private final ResourceLocation PICKER = new ResourceLocation("textures/gui/picker.png");
    private BufferedImage pickerImage;
    private int color;
    private boolean drag;
    private boolean advanced = false;
    private Button advButton;
    private TextFieldWidget tfr;
    private TextFieldWidget tfg;
    private TextFieldWidget tfb;
    private TextFieldWidget intColor;
    private TextFieldWidget hexColor;
    private Slider r;
    private Slider g;
    private Slider b;
    private int defaultColor;

    public GuiColorModifier(Screen parent, Consumer<Integer> setter, int color) {
        this(parent, setter, color, 10511680);
    }

    public GuiColorModifier(Screen parent, Consumer<Integer> setter, int color, int defaultColor) {
        super(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.setColor"), setter);
        this.color = color & 0xFFFFFF;
        this.defaultColor = defaultColor;
        try {
            this.pickerImage = ImageIO.read(Minecraft.func_71410_x().func_195551_G().func_199002_a(this.PICKER).func_199027_b());
        }
        catch (Exception e) {
            this.pickerImage = new BufferedImage(200, 200, 2);
        }
    }

    public void func_231023_e_() {
        this.tfr.func_146178_a();
        this.tfg.func_146178_a();
        this.tfb.func_146178_a();
        this.hexColor.func_146178_a();
        this.intColor.func_146178_a();
        this.g.field_230694_p_ = this.b.field_230694_p_ = this.advanced;
        this.r.field_230694_p_ = this.b.field_230694_p_;
        this.advButton.setFGColor(this.b.field_230694_p_ ? -1 : -5592406);
        super.func_231023_e_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (!this.advanced) {
            GuiUtils.color3f(1.0f, 1.0f, 1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(this.PICKER);
            GuiUtils.drawScaledCustomSizeModalRect(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 80, 0.0f, 0.0f, 200, 200, 200, 160, 200.0f, 200.0f);
        } else {
            GuiUtils.drawRect(matrixStack, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 80, this.field_230708_k_ / 2 + 100, this.field_230709_l_ / 2 + 80, -1728053248);
        }
        if (this.advanced) {
            GuiUtils.drawString(this.field_230712_o_, I18n.func_135052_a((String)"gui.act.red", (Object[])new Object[0]) + ":", this.r.field_230690_l_ + 1, this.r.field_230691_m_ - 10, -1, 10);
            this.tfr.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            GuiUtils.drawString(this.field_230712_o_, I18n.func_135052_a((String)"gui.act.green", (Object[])new Object[0]) + ":", this.g.field_230690_l_ + 1, this.g.field_230691_m_ - 10, -1, 10);
            this.tfg.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            GuiUtils.drawString(this.field_230712_o_, I18n.func_135052_a((String)"gui.act.blue", (Object[])new Object[0]) + ":", this.b.field_230690_l_ + 1, this.b.field_230691_m_ - 10, -1, 10);
            this.tfb.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            GuiUtils.drawString(this.field_230712_o_, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor.intColor", (Object[])new Object[0]) + ":", this.intColor.field_230690_l_ - 1, this.intColor.field_230691_m_ - 11, -1, 10);
            GuiUtils.drawString(this.field_230712_o_, I18n.func_135052_a((String)"gui.act.modifier.meta.setColor.hexColor", (Object[])new Object[0]) + ":", this.hexColor.field_230690_l_ - 1, this.hexColor.field_230691_m_ - 11, -1, 10);
            this.intColor.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.hexColor.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        if (this.color >= 0) {
            GuiUtils.drawRect(matrixStack, this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 - 100, this.field_230708_k_ / 2 + 120, this.field_230709_l_ / 2 - 80, this.color + -16777216);
        }
        Runnable show = () -> {};
        for (int i = 0; i < DyeColor.values().length; ++i) {
            int x = this.field_230708_k_ / 2 - 120 + i % 2 * 220;
            int y = this.field_230709_l_ / 2 - 80 + i / 2 * 20;
            GuiUtils.drawRect(matrixStack, x, y, x + 20, y + 20, 0xFF000000 | DyeColor.values()[i].func_196060_f());
            if (GuiUtils.isHover(x, y, 20, 20, mouseX, mouseY)) {
                int j = i;
                show = () -> GuiUtils.drawTextBox(this.field_230712_o_, mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, this.getZLevel(), I18n.func_135052_a((String)("item.minecraft.firework_star." + DyeColor.values()[j].func_176762_d()), (Object[])new Object[0]));
            }
            GuiUtils.drawItemStack(this.field_230707_j_, this, new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)DyeColor.values()[i])), x + 2, y + 2);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        show.run();
    }

    public void func_231160_c_() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 + 81, 80, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> {
            this.set(this.color);
            this.getMinecraft().func_147108_a(this.parent);
        }));
        this.advButton = new Button(this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 + 81, 80, 20, (ITextComponent)new TranslationTextComponent("gui.act.advanced"), b -> {
            this.advanced = !this.advanced;
        });
        this.func_230480_a_((Widget)this.advButton);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 43, this.field_230709_l_ / 2 + 81, 79, 20, (ITextComponent)new TranslationTextComponent("gui.act.cancel"), b -> this.getMinecraft().func_147108_a(this.parent)));
        this.r = new Slider(this.field_230708_k_ / 2 - 99, this.field_230709_l_ / 2 - 70, 158, 20, (ITextComponent)new TranslationTextComponent("gui.act.red"), (ITextComponent)new StringTextComponent(""), 0.0, 255.0, (double)(this.color >> 16 & 0xFF), false, false, b -> {}, s -> this.updateRed(s.getValueInt()));
        this.func_230480_a_((Widget)this.r);
        this.tfr = new TextFieldWidget(this.field_230712_o_, this.r.field_230690_l_ + this.r.func_230998_h_() + 2, this.r.field_230691_m_ + 1, 36, 18, (ITextComponent)new StringTextComponent(""));
        this.g = new Slider(this.field_230708_k_ / 2 - 99, this.field_230709_l_ / 2 - 38, 158, 20, (ITextComponent)new TranslationTextComponent("gui.act.green"), (ITextComponent)new StringTextComponent(""), 0.0, 255.0, (double)(this.color >> 8 & 0xFF), false, false, b -> {}, s -> this.updateGreen(s.getValueInt()));
        this.func_230480_a_((Widget)this.g);
        this.tfg = new TextFieldWidget(this.field_230712_o_, this.g.field_230690_l_ + this.g.func_230998_h_() + 2, this.g.field_230691_m_ + 1, 36, 18, (ITextComponent)new StringTextComponent(""));
        this.b = new Slider(this.field_230708_k_ / 2 - 99, this.field_230709_l_ / 2 - 3, 158, 20, (ITextComponent)new TranslationTextComponent("gui.act.blue"), (ITextComponent)new StringTextComponent(""), 0.0, 255.0, (double)(this.color & 0xFF), false, false, b -> {}, s -> this.updateBlue(s.getValueInt()));
        this.func_230480_a_((Widget)this.b);
        this.tfb = new TextFieldWidget(this.field_230712_o_, this.b.field_230690_l_ + this.b.func_230998_h_() + 2, this.b.field_230691_m_ + 1, 36, 18, (ITextComponent)new StringTextComponent(""));
        this.intColor = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 97, this.field_230709_l_ / 2 + 28, 194, 18, (ITextComponent)new StringTextComponent(""));
        this.hexColor = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 97, this.field_230709_l_ / 2 + 60, 194, 18, (ITextComponent)new StringTextComponent(""));
        this.tfr.func_146203_f(4);
        this.tfg.func_146203_f(4);
        this.tfb.func_146203_f(4);
        this.b.field_230694_p_ = false;
        this.g.field_230694_p_ = false;
        this.r.field_230694_p_ = false;
        this.updateColor(this.color);
        super.func_231160_c_();
    }

    public boolean func_231042_a_(char key, int modifiers) {
        if (this.advanced) {
            this.tfr.func_231042_a_(key, modifiers);
            this.tfg.func_231042_a_(key, modifiers);
            this.tfb.func_231042_a_(key, modifiers);
            this.hexColor.func_231042_a_(key, modifiers);
            this.intColor.func_231042_a_(key, modifiers);
            if (this.tfr.func_230999_j_()) {
                try {
                    this.updateRed(this.tfr.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfr.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.func_230999_j_()) {
                try {
                    this.updateGreen(this.tfg.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfg.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.func_230999_j_()) {
                try {
                    this.updateBlue(this.tfb.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfb.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.func_230999_j_()) {
                try {
                    String s = this.hexColor.func_146179_b().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.func_230999_j_()) {
                try {
                    this.updateColor(this.intColor.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.intColor.func_146179_b()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.func_231042_a_(key, modifiers);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.advanced) {
            this.tfr.func_231046_a_(key, scanCode, modifiers);
            this.tfg.func_231046_a_(key, scanCode, modifiers);
            this.tfb.func_231046_a_(key, scanCode, modifiers);
            this.hexColor.func_231046_a_(key, scanCode, modifiers);
            this.intColor.func_231046_a_(key, scanCode, modifiers);
            if (this.tfr.func_230999_j_()) {
                try {
                    this.updateRed(this.tfr.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfr.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfg.func_230999_j_()) {
                try {
                    this.updateGreen(this.tfg.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfg.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.tfb.func_230999_j_()) {
                try {
                    this.updateBlue(this.tfb.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.tfb.func_146179_b()));
                }
                catch (Exception exception) {}
            } else if (this.hexColor.func_230999_j_()) {
                try {
                    String s = this.hexColor.func_146179_b().substring(1);
                    this.updateColor(s.isEmpty() ? 0 : Integer.valueOf(s, 16));
                }
                catch (Exception exception) {}
            } else if (this.intColor.func_230999_j_()) {
                try {
                    this.updateColor(this.intColor.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.intColor.func_146179_b()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.advanced) {
            if (mouseButton == 1) {
                if (GuiUtils.isHover((Widget)this.tfr, (int)mouseX, (int)mouseY)) {
                    this.tfr.func_146180_a("");
                } else if (GuiUtils.isHover((Widget)this.tfg, (int)mouseX, (int)mouseY)) {
                    this.tfg.func_146180_a("");
                } else if (GuiUtils.isHover((Widget)this.tfb, (int)mouseX, (int)mouseY)) {
                    this.tfb.func_146180_a("");
                } else if (GuiUtils.isHover((Widget)this.intColor, (int)mouseX, (int)mouseY)) {
                    this.intColor.func_146180_a("");
                } else if (GuiUtils.isHover((Widget)this.hexColor, (int)mouseX, (int)mouseY)) {
                    this.hexColor.func_146180_a("#");
                }
            }
            this.tfr.func_231044_a_(mouseX, mouseY, mouseButton);
            this.tfg.func_231044_a_(mouseX, mouseY, mouseButton);
            this.tfb.func_231044_a_(mouseX, mouseY, mouseButton);
            this.intColor.func_231044_a_(mouseX, mouseY, mouseButton);
            this.hexColor.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        this.drag = false;
        if (!this.advanced && GuiUtils.isHover(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 80, 200, 160, (int)mouseX, (int)mouseY)) {
            this.setColor((int)mouseX, (int)mouseY);
            this.drag = true;
        } else if (GuiUtils.isHover(this.field_230708_k_ / 2 - 120, this.field_230709_l_ / 2 - 100, 240, 20, (int)mouseX, (int)mouseY)) {
            this.updateColor(this.defaultColor);
        } else {
            for (int i = 0; i < DyeColor.values().length; ++i) {
                if (!GuiUtils.isHover(this.field_230708_k_ / 2 - 120 + i % 2 * 220, this.field_230709_l_ / 2 - 80 + i / 2 * 20, 20, 20, (int)mouseX, (int)mouseY)) continue;
                this.updateColor(DyeColor.values()[i].func_196060_f());
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.drag) {
            this.setColor((int)mouseX, (int)mouseY);
        }
        return super.func_231045_a_(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    private void updateColor(int value) {
        this.color = value == this.defaultColor ? value : MathHelper.func_76125_a((int)value, (int)0, (int)0xFFFFFF);
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color >> 0 & 0xFF;
        this.r.setValue((double)r);
        this.g.setValue((double)g);
        this.b.setValue((double)b);
        this.tfr.func_146180_a("" + r);
        this.tfg.func_146180_a("" + g);
        this.tfb.func_146180_a("" + b);
        this.intColor.func_146180_a("" + this.color);
        String s = Integer.toHexString(this.color);
        this.hexColor.func_146180_a("#" + s);
    }

    private void setColor(int mouseX, int mouseY) {
        int rx = MathHelper.func_76125_a((int)(mouseX - (this.field_230708_k_ / 2 - 100)), (int)0, (int)199);
        int ry = MathHelper.func_76125_a((int)(MathHelper.func_76125_a((int)(mouseY - (this.field_230709_l_ / 2 - 100)), (int)0, (int)160) * 20 / 16), (int)0, (int)199);
        int[] data = new int[3];
        this.pickerImage.getRaster().getPixel(rx, ry, data);
        this.updateColor((data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 0);
    }

    private void updateRed(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((v & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateGreen(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (v & 0xFF) << 8 | (this.color >> 0 & 0xFF & 0xFF) << 0);
    }

    private void updateBlue(int v) {
        v = MathHelper.func_76125_a((int)v, (int)0, (int)255);
        this.updateColor((this.color >> 16 & 0xFF & 0xFF) << 16 | (this.color >> 8 & 0xFF & 0xFF) << 8 | (v & 0xFF) << 0);
    }
}

