/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier;

import com.mojang.blaze3d.matrix.MatrixStack;
import fr.atesab.act.gui.modifier.GuiBooleanButton;
import fr.atesab.act.gui.modifier.GuiColorModifier;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.selector.GuiButtonListSelector;
import fr.atesab.act.utils.GuiUtils;
import fr.atesab.act.utils.ItemUtils;
import fr.atesab.act.utils.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPotionModifier
extends GuiListModifier<ItemUtils.PotionInformation> {
    private int customColor = -1;
    private Potion main;
    private final Supplier<GuiListModifier.ListElement> supplier = () -> new CustomPotionListElement(this, new EffectInstance(Effects.field_76424_c));

    public GuiPotionModifier(Screen parent, Consumer<ItemUtils.PotionInformation> setter, ItemUtils.PotionInformation info) {
        super(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion"), new ArrayList<GuiListModifier.ListElement>(), setter, new Tuple[0]);
        this.customColor = info.getCustomColor();
        this.main = info.getMain();
        this.addListElement(new MainPotionListElement(this));
        info.getCustomEffects().forEach(t -> this.addListElement(new CustomPotionListElement(this, (EffectInstance)t)));
        this.addListElement(new GuiListModifier.AddElementList(this, this.supplier));
    }

    @Override
    protected ItemUtils.PotionInformation get() {
        ArrayList<EffectInstance> customEffects = new ArrayList<EffectInstance>();
        this.getElements().stream().filter(le -> le instanceof CustomPotionListElement).map(le -> (CustomPotionListElement)le).forEach(cpl -> customEffects.add(cpl.getEffect()));
        return new ItemUtils.PotionInformation(this.customColor, this.main, customEffects);
    }

    private static class MainPotionListElement
    extends GuiListModifier.ListElement {
        private GuiPotionModifier parent;
        private Button type;

        private static String getPotionName(Potion pot) {
            String name = pot.func_185174_b("");
            return name + (pot.getRegistryName().toString().contains("long_") ? " (" + I18n.func_135052_a((String)"gui.act.modifier.meta.potion.long", (Object[])new Object[0]) + ")" : (pot.getRegistryName().toString().contains("strong_") ? " II" : ""));
        }

        public MainPotionListElement(GuiPotionModifier parent) {
            super(400, 29);
            this.parent = parent;
            this.buttonList.add(new Button(0, 0, 200, 20, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.setColor"), b -> this.mc.func_147108_a((Screen)new GuiColorModifier(parent, i -> parent.customColor = i, parent.customColor, -1))));
            this.type = new Button(201, 0, 199, 20, (ITextComponent)new StringTextComponent(""), b -> {
                ArrayList pots = new ArrayList();
                Registry.field_212621_j.forEach(type -> pots.add(new Tuple<String, Potion>(MainPotionListElement.getPotionName(type), (Potion)type)));
                this.mc.func_147108_a(new GuiButtonListSelector<Potion>(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.type"), pots, pot -> {
                    parent.main = pot;
                    this.defineButton();
                    return null;
                }));
            });
            this.buttonList.add(this.type);
            this.defineButton();
        }

        private void defineButton() {
            this.type.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.type").func_240702_b_(" (").func_240702_b_(MainPotionListElement.getPotionName(this.parent.main)).func_240702_b_(")"));
        }
    }

    private static class CustomPotionListElement
    extends GuiListModifier.ListElement {
        private TextFieldWidget duration;
        private TextFieldWidget amplifier;
        private Effect potion;
        private int durationTime;
        private int amplifierValue;
        private boolean ambient;
        private boolean showIcon;
        private boolean showParticles;
        private boolean errDur = false;
        private boolean errAmp = false;
        private Button type;

        public CustomPotionListElement(GuiPotionModifier parent, EffectInstance potionEffect) {
            super(400, 50);
            int l = 5 + Math.max(this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : "), this.font.func_78256_a(I18n.func_135052_a((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : "));
            this.potion = potionEffect.func_188419_a();
            this.durationTime = potionEffect.func_76459_b();
            this.amplifierValue = potionEffect.func_76458_c();
            this.ambient = potionEffect.func_82720_e();
            this.showIcon = potionEffect.func_205348_f();
            this.showParticles = potionEffect.func_188418_e();
            this.duration = new TextFieldWidget(this.font, l, 1, 150 - l, 18, (ITextComponent)new StringTextComponent(""));
            this.duration.func_146180_a(String.valueOf(this.durationTime));
            this.amplifier = new TextFieldWidget(this.font, l, 22, 150 - l, 18, (ITextComponent)new StringTextComponent(""));
            this.amplifier.func_146180_a(String.valueOf(this.amplifierValue));
            this.type = new Button(153, 0, 200, 20, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.type"), b -> {
                ArrayList pots = new ArrayList();
                Registry.field_212631_t.forEach(pot -> pots.add(new Tuple<String, Effect>(I18n.func_135052_a((String)pot.func_76393_a(), (Object[])new Object[0]), (Effect)pot)));
                this.mc.func_147108_a(new GuiButtonListSelector<Effect>(parent, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.type"), pots, pot -> {
                    this.potion = pot;
                    this.setButtonText();
                    return null;
                }));
            });
            this.buttonList.add(this.type);
            this.buttonList.add(new GuiBooleanButton(153, 21, 100, 20, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.ambient"), b -> {
                this.ambient = b;
            }, () -> this.ambient));
            this.buttonList.add(new GuiBooleanButton(255, 21, 99, 20, (ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.showParticles"), b -> {
                this.showParticles = b;
            }, () -> this.showParticles));
            this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, 355, 0, 20, 20, this));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 377, 0, 20, 20, this, parent.supplier));
            this.buttonList.add(new GuiListModifier.AddElementButton(parent, 355, 21, 43, 20, (ITextComponent)new TranslationTextComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, () -> new CustomPotionListElement(parent, this.getEffect())));
            this.setButtonText();
        }

        @Override
        public void draw(MatrixStack stack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
            GuiUtils.drawRelative(stack, (Widget)this.amplifier, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRelative(stack, (Widget)this.duration, offsetX, offsetY, mouseY, mouseY, partialTicks);
            GuiUtils.drawRightString(this.font, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.duration", (Object[])new Object[0]) + " : ", (Widget)this.duration, (this.errDur ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            GuiUtils.drawRightString(this.font, I18n.func_135052_a((String)"gui.act.modifier.meta.potion.amplifier", (Object[])new Object[0]) + " : ", (Widget)this.amplifier, (this.errAmp ? Color.RED : Color.WHITE).getRGB(), offsetX, offsetY);
            super.draw(stack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        }

        public EffectInstance getEffect() {
            return new EffectInstance(this.potion, this.durationTime, this.amplifierValue, this.ambient, this.showParticles, this.showIcon);
        }

        @Override
        public void init() {
            this.amplifier.func_146195_b(false);
            this.duration.func_146195_b(false);
            super.init();
        }

        @Override
        public boolean isFocused() {
            return this.amplifier.func_230999_j_() || this.duration.func_230999_j_();
        }

        @Override
        public boolean charTyped(char key, int modifiers) {
            return this.amplifier.func_231042_a_(key, modifiers) || this.duration.func_231042_a_(key, modifiers) || super.charTyped(key, modifiers);
        }

        @Override
        public boolean keyPressed(int key, int scanCode, int modifiers) {
            return this.amplifier.func_231046_a_(key, scanCode, modifiers) || this.duration.func_231046_a_(key, scanCode, modifiers) || super.keyPressed(key, scanCode, modifiers);
        }

        @Override
        public boolean match(String search) {
            return (this.potion == null ? "" : I18n.func_135052_a((String)this.potion.func_76393_a(), (Object[])new Object[0]).toLowerCase()).contains(search.toLowerCase());
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amplifier.func_231044_a_((double)mouseX, (double)mouseY, mouseButton);
            this.duration.func_231044_a_((double)mouseX, (double)mouseY, mouseButton);
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        private void setButtonText() {
            this.type.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.act.modifier.meta.potion.type").func_240702_b_(" (").func_230529_a_((ITextComponent)(this.potion == null ? new StringTextComponent("null") : new TranslationTextComponent(this.potion.func_76393_a()))).func_240702_b_(")"));
        }

        @Override
        public void update() {
            this.amplifier.func_146178_a();
            this.duration.func_146178_a();
            try {
                this.durationTime = Integer.parseInt(this.duration.func_146179_b());
                this.errDur = false;
            }
            catch (Exception e) {
                this.errDur = true;
            }
            try {
                int i = Integer.parseInt(this.amplifier.func_146179_b());
                this.errAmp = i < -128 || i > 127;
                if (!this.errAmp) {
                    this.amplifierValue = i;
                }
            }
            catch (Exception e) {
                this.errAmp = true;
            }
            super.update();
        }
    }
}

