/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.act.gui.modifier.nbtelement;

import com.mojang.blaze3d.matrix.MatrixStack;
import fr.atesab.act.gui.modifier.GuiListModifier;
import fr.atesab.act.gui.modifier.GuiStringModifier;
import fr.atesab.act.gui.modifier.nbt.GuiNBTModifier;
import fr.atesab.act.gui.modifier.nbtelement.NBTByteElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTDoubleElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTFloatElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTIntArrayElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTIntegerElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTListElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTLongArrayElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTLongElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTShortElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTStringElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTTagElement;
import fr.atesab.act.gui.modifier.nbtelement.NBTUnknownElement;
import fr.atesab.act.utils.GuiUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class NBTElement
extends GuiListModifier.ListElement
implements Cloneable {
    protected String key;
    protected GuiListModifier<?> parent;

    private static boolean isList(Object object) {
        return object.getClass().isAnnotationPresent(GuiNBTList.class);
    }

    public NBTElement(GuiListModifier<?> parent, String key, int sizeX, int sizeY) {
        super(sizeX + 82, Math.max(NBTElement.isList(parent) ? 22 : 43, sizeY));
        this.key = key;
        this.parent = parent;
        this.buttonList.add(new GuiListModifier.RemoveElementButton(parent, sizeX + 1, 0, 20, 20, this));
        this.buttonList.add(new GuiListModifier.AddElementButton(parent, sizeX + 22, 0, 20, 20, (ITextComponent)new StringTextComponent("+").func_240699_a_(TextFormatting.GREEN), (GuiListModifier.ListElement)this, i -> {
            GuiNBTModifier.ADD_ELEMENT.accept((Integer)i, parent);
            return null;
        }));
        this.buttonList.add(new GuiListModifier.AddElementButton(parent, sizeX + 43, 0, 37, 20, (ITextComponent)new TranslationTextComponent("gui.act.give.copy"), (GuiListModifier.ListElement)this, i -> {
            parent.addListElement((int)i, NBTElement.getElementByBase(parent, key, this.get()));
            return null;
        }));
        if (!NBTElement.isList(parent)) {
            this.buttonList.add(new GuiListModifier.RunElementButton(sizeX + 1, 21, 79, 20, (ITextComponent)new TranslationTextComponent("gui.act.config.name"), () -> this.mc.func_147108_a((Screen)new GuiStringModifier(parent, (ITextComponent)new TranslationTextComponent("gui.act.config.name"), this.getKey(), nk -> {
                this.key = nk;
            })), null));
        }
    }

    public abstract NBTElement clone();

    @Override
    public void draw(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.font.getClass();
        GuiUtils.drawGradientRect(offsetX - 2, offsetY - (6 + 9), offsetX + this.getSizeX() - 1, offsetY - 2, -1998725667, -2002081110, this.parent.getZLevel());
        GuiUtils.drawGradientRect(offsetX - 2, offsetY - 2, offsetX + this.getSizeX() - 1, offsetY + this.getSizeY() + 2, -2013265920, -2013265920, this.parent.getZLevel());
        String s = this.getType();
        if (!NBTElement.isList(this.parent)) {
            s = this.key + " (" + s + ")";
        }
        this.font.getClass();
        this.font.getClass();
        GuiUtils.drawString(this.font, s, offsetX + 2, offsetY - 9 - 4, -1, 9 + 2);
        super.draw(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
    }

    public abstract INBT get();

    public String getKey() {
        return this.key;
    }

    public abstract String getType();

    @Override
    public boolean match(String search) {
        return (this.key + " (" + I18n.func_135052_a((String)("gui.act.modifier.tag.editor." + this.getType()), (Object[])new Object[0]) + ")").toLowerCase().contains(search.toLowerCase());
    }

    public static NBTElement getElementByBase(GuiListModifier<?> parent, String key, INBT base) {
        switch (base.func_74732_a()) {
            case 0: {
                return new NBTTagElement(parent, key, new CompoundNBT());
            }
            case 1: {
                return new NBTByteElement(parent, key, ((ByteNBT)base).func_150290_f());
            }
            case 2: {
                return new NBTShortElement(parent, key, ((ShortNBT)base).func_150289_e());
            }
            case 3: {
                return new NBTIntegerElement(parent, key, ((IntNBT)base).func_150287_d());
            }
            case 4: {
                return new NBTLongElement(parent, key, ((LongNBT)base).func_150291_c());
            }
            case 5: {
                return new NBTFloatElement(parent, key, Float.valueOf(((FloatNBT)base).func_150288_h()));
            }
            case 6: {
                return new NBTDoubleElement(parent, key, ((DoubleNBT)base).func_150286_g());
            }
            case 8: {
                return new NBTStringElement(parent, key, ((StringNBT)base).func_150285_a_());
            }
            case 9: {
                return new NBTListElement(parent, key, (ListNBT)base);
            }
            case 10: {
                return new NBTTagElement(parent, key, (CompoundNBT)base);
            }
            case 11: {
                return new NBTIntArrayElement(parent, key, (IntArrayNBT)base);
            }
            case 12: {
                return new NBTLongArrayElement(parent, key, (LongArrayNBT)base);
            }
        }
        return new NBTUnknownElement(parent, key, base);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface GuiNBTList {
    }
}

